/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.transaction;

import com.hedera.hapi.node.base.SignatureMap;
import com.hedera.hapi.node.transaction.codec.SignedTransactionJsonCodec;
import com.hedera.hapi.node.transaction.codec.SignedTransactionProtoCodec;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.JsonCodec;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Objects;
import java.util.function.Consumer;

public record SignedTransaction(Bytes bodyBytes, @Nullable SignatureMap sigMap) {
    public static final Codec<SignedTransaction> PROTOBUF = new SignedTransactionProtoCodec();
    public static final JsonCodec<SignedTransaction> JSON = new SignedTransactionJsonCodec();
    public static final SignedTransaction DEFAULT = SignedTransaction.newBuilder().build();

    public boolean hasSigMap() {
        return this.sigMap != null;
    }

    public SignatureMap sigMapOrElse(@NonNull SignatureMap defaultValue) {
        return this.hasSigMap() ? this.sigMap : defaultValue;
    }

    @NonNull
    public SignatureMap sigMapOrThrow() {
        return Objects.requireNonNull(this.sigMap, "Field sigMap is null");
    }

    public void ifSigMap(@NonNull Consumer<SignatureMap> ifPresent) {
        if (this.hasSigMap()) {
            ifPresent.accept(this.sigMap);
        }
    }

    public Builder copyBuilder() {
        return new Builder(this.bodyBytes, this.sigMap);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        private Bytes bodyBytes = Bytes.EMPTY;
        private SignatureMap sigMap = null;

        public Builder() {
        }

        public Builder(Bytes bodyBytes, SignatureMap sigMap) {
            this.bodyBytes = bodyBytes;
            this.sigMap = sigMap;
        }

        public SignedTransaction build() {
            return new SignedTransaction(this.bodyBytes, this.sigMap);
        }

        public Builder bodyBytes(Bytes bodyBytes) {
            this.bodyBytes = bodyBytes;
            return this;
        }

        public Builder sigMap(SignatureMap sigMap) {
            this.sigMap = sigMap;
            return this;
        }

        public Builder sigMap(SignatureMap.Builder builder) {
            this.sigMap = builder.build();
            return this;
        }
    }
}

