/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.transaction;

import com.hedera.hapi.node.transaction.ThrottleGroup;
import com.hedera.hapi.node.transaction.codec.ThrottleBucketJsonCodec;
import com.hedera.hapi.node.transaction.codec.ThrottleBucketProtoCodec;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.JsonCodec;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;

public record ThrottleBucket(String name, long burstPeriodMs, @Nullable List<ThrottleGroup> throttleGroups) {
    public static final Codec<ThrottleBucket> PROTOBUF = new ThrottleBucketProtoCodec();
    public static final JsonCodec<ThrottleBucket> JSON = new ThrottleBucketJsonCodec();
    public static final ThrottleBucket DEFAULT = ThrottleBucket.newBuilder().build();

    public boolean hasThrottleGroups() {
        return this.throttleGroups != null;
    }

    public List<ThrottleGroup> throttleGroupsOrElse(@NonNull List<ThrottleGroup> defaultValue) {
        return this.hasThrottleGroups() ? this.throttleGroups : defaultValue;
    }

    @NonNull
    public List<ThrottleGroup> throttleGroupsOrThrow() {
        return Objects.requireNonNull(this.throttleGroups, "Field throttleGroups is null");
    }

    public void ifThrottleGroups(@NonNull Consumer<List<ThrottleGroup>> ifPresent) {
        if (this.hasThrottleGroups()) {
            ifPresent.accept(this.throttleGroups);
        }
    }

    public Builder copyBuilder() {
        return new Builder(this.name, this.burstPeriodMs, this.throttleGroups);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        private String name = "";
        private long burstPeriodMs = 0L;
        private List<ThrottleGroup> throttleGroups = Collections.emptyList();

        public Builder() {
        }

        public Builder(String name, long burstPeriodMs, List<ThrottleGroup> throttleGroups) {
            this.name = name;
            this.burstPeriodMs = burstPeriodMs;
            this.throttleGroups = throttleGroups;
        }

        public ThrottleBucket build() {
            return new ThrottleBucket(this.name, this.burstPeriodMs, this.throttleGroups);
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder burstPeriodMs(long burstPeriodMs) {
            this.burstPeriodMs = burstPeriodMs;
            return this;
        }

        public Builder throttleGroups(List<ThrottleGroup> throttleGroups) {
            this.throttleGroups = throttleGroups;
            return this;
        }

        public Builder throttleGroups(ThrottleGroup ... values) {
            this.throttleGroups = List.of(values);
            return this;
        }
    }
}

