/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.transaction.codec;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.TokenID;
import com.hedera.hapi.node.transaction.AssessedCustomFee;
import com.hedera.hapi.node.transaction.schema.AssessedCustomFeeSchema;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.FieldDefinition;
import com.hedera.pbj.runtime.ProtoParserTools;
import com.hedera.pbj.runtime.ProtoWriterTools;
import com.hedera.pbj.runtime.UnknownFieldException;
import com.hedera.pbj.runtime.io.ReadableSequentialData;
import com.hedera.pbj.runtime.io.WritableSequentialData;
import com.hedera.pbj.runtime.io.stream.EOFException;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import java.util.Collections;
import java.util.List;

public final class AssessedCustomFeeProtoCodec
implements Codec<AssessedCustomFee> {
    @NonNull
    public AssessedCustomFee parse(@NonNull ReadableSequentialData input) throws IOException {
        return this.parseInternal(input, false);
    }

    @NonNull
    public AssessedCustomFee parseStrict(@NonNull ReadableSequentialData input) throws IOException {
        return this.parseInternal(input, true);
    }

    public void write(@NonNull AssessedCustomFee data, @NonNull WritableSequentialData out) throws IOException {
        ProtoWriterTools.writeLong((WritableSequentialData)out, (FieldDefinition)AssessedCustomFeeSchema.AMOUNT, (long)data.amount());
        ProtoWriterTools.writeMessage((WritableSequentialData)out, (FieldDefinition)AssessedCustomFeeSchema.TOKEN_ID, (Object)data.tokenId(), (arg_0, arg_1) -> TokenID.PROTOBUF.write(arg_0, arg_1), arg_0 -> TokenID.PROTOBUF.measureRecord(arg_0));
        ProtoWriterTools.writeMessage((WritableSequentialData)out, (FieldDefinition)AssessedCustomFeeSchema.FEE_COLLECTOR_ACCOUNT_ID, (Object)data.feeCollectorAccountId(), (arg_0, arg_1) -> AccountID.PROTOBUF.write(arg_0, arg_1), arg_0 -> AccountID.PROTOBUF.measureRecord(arg_0));
        ProtoWriterTools.writeMessageList((WritableSequentialData)out, (FieldDefinition)AssessedCustomFeeSchema.EFFECTIVE_PAYER_ACCOUNT_ID, data.effectivePayerAccountId(), (arg_0, arg_1) -> AccountID.PROTOBUF.write(arg_0, arg_1), arg_0 -> AccountID.PROTOBUF.measureRecord(arg_0));
    }

    public int measure(@NonNull ReadableSequentialData input) throws IOException {
        long start = input.position();
        this.parse(input);
        long end = input.position();
        return (int)(end - start);
    }

    public int measureRecord(AssessedCustomFee data) {
        int size = 0;
        size += ProtoWriterTools.sizeOfLong((FieldDefinition)AssessedCustomFeeSchema.AMOUNT, (long)data.amount());
        size += ProtoWriterTools.sizeOfMessage((FieldDefinition)AssessedCustomFeeSchema.TOKEN_ID, (Object)data.tokenId(), arg_0 -> TokenID.PROTOBUF.measureRecord(arg_0));
        size += ProtoWriterTools.sizeOfMessage((FieldDefinition)AssessedCustomFeeSchema.FEE_COLLECTOR_ACCOUNT_ID, (Object)data.feeCollectorAccountId(), arg_0 -> AccountID.PROTOBUF.measureRecord(arg_0));
        return size += ProtoWriterTools.sizeOfMessageList((FieldDefinition)AssessedCustomFeeSchema.EFFECTIVE_PAYER_ACCOUNT_ID, data.effectivePayerAccountId(), arg_0 -> AccountID.PROTOBUF.measureRecord(arg_0));
    }

    public boolean fastEquals(@NonNull AssessedCustomFee item, @NonNull ReadableSequentialData input) throws IOException {
        return item.equals(this.parse(input));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NonNull
    private AssessedCustomFee parseInternal(@NonNull ReadableSequentialData input, boolean strictMode) throws IOException {
        long temp_amount = 0L;
        Record temp_token_id = null;
        Record temp_fee_collector_account_id = null;
        List temp_effective_payer_account_id = Collections.emptyList();
        try {
            block8: while (input.hasRemaining()) {
                int tag = input.readVarInt(false);
                int field = tag >>> 3;
                FieldDefinition f = AssessedCustomFeeSchema.getField(field);
                switch (tag) {
                    case 8: {
                        long value;
                        temp_amount = value = ProtoParserTools.readInt64((ReadableSequentialData)input);
                        continue block8;
                    }
                    case 18: {
                        int messageLength = input.readVarInt(false);
                        long limitBefore = input.limit();
                        input.limit(input.position() + (long)messageLength);
                        Record value = strictMode ? (TokenID)TokenID.PROTOBUF.parseStrict(input) : (TokenID)TokenID.PROTOBUF.parse(input);
                        input.limit(limitBefore);
                        temp_token_id = value;
                        continue block8;
                    }
                    case 26: {
                        int messageLength = input.readVarInt(false);
                        long limitBefore = input.limit();
                        input.limit(input.position() + (long)messageLength);
                        Record value = strictMode ? (AccountID)AccountID.PROTOBUF.parseStrict(input) : (AccountID)AccountID.PROTOBUF.parse(input);
                        input.limit(limitBefore);
                        temp_fee_collector_account_id = value;
                        continue block8;
                    }
                    case 34: {
                        int messageLength = input.readVarInt(false);
                        long limitBefore = input.limit();
                        input.limit(input.position() + (long)messageLength);
                        Record value = strictMode ? (AccountID)AccountID.PROTOBUF.parseStrict(input) : (AccountID)AccountID.PROTOBUF.parse(input);
                        input.limit(limitBefore);
                        temp_effective_payer_account_id = ProtoParserTools.addToList(temp_effective_payer_account_id, (Object)value);
                        continue block8;
                    }
                }
                int wireType = tag & 7;
                if (field == 0) {
                    throw new IOException("Bad protobuf encoding. We read a field value of " + field);
                }
                if (wireType > 5) {
                    throw new IOException("Cannot understand wire_type of " + wireType);
                }
                if (f != null) throw new IOException("Bad tag [" + tag + "], field [" + field + "] wireType [" + wireType + "]");
                if (strictMode) {
                    throw new UnknownFieldException(field);
                }
                ProtoParserTools.skipField((ReadableSequentialData)input, (int)wireType);
            }
            return new AssessedCustomFee(temp_amount, (TokenID)temp_token_id, (AccountID)temp_fee_collector_account_id, temp_effective_payer_account_id);
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        return new AssessedCustomFee(temp_amount, (TokenID)temp_token_id, (AccountID)temp_fee_collector_account_id, temp_effective_payer_account_id);
    }
}

