/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.transaction.codec;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.ContractID;
import com.hedera.hapi.node.base.FileID;
import com.hedera.hapi.node.token.LiveHash;
import com.hedera.hapi.node.transaction.EntityID;
import com.hedera.hapi.node.transaction.schema.EntityIDSchema;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.FieldDefinition;
import com.hedera.pbj.runtime.OneOf;
import com.hedera.pbj.runtime.ProtoParserTools;
import com.hedera.pbj.runtime.ProtoWriterTools;
import com.hedera.pbj.runtime.UnknownFieldException;
import com.hedera.pbj.runtime.io.ReadableSequentialData;
import com.hedera.pbj.runtime.io.WritableSequentialData;
import com.hedera.pbj.runtime.io.stream.EOFException;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;

public final class EntityIDProtoCodec
implements Codec<EntityID> {
    public static final OneOf<EntityID.EntityOneOfType> ENTITY_UNSET = new OneOf((Object)EntityID.EntityOneOfType.UNSET, null);

    @NonNull
    public EntityID parse(@NonNull ReadableSequentialData input) throws IOException {
        return this.parseInternal(input, false);
    }

    @NonNull
    public EntityID parseStrict(@NonNull ReadableSequentialData input) throws IOException {
        return this.parseInternal(input, true);
    }

    public void write(@NonNull EntityID data, @NonNull WritableSequentialData out) throws IOException {
        if (data.entity().kind() == EntityID.EntityOneOfType.ACCOUNT_ID) {
            ProtoWriterTools.writeMessage((WritableSequentialData)out, (FieldDefinition)EntityIDSchema.ACCOUNT_ID, (Object)((AccountID)data.entity().as()), (arg_0, arg_1) -> AccountID.PROTOBUF.write(arg_0, arg_1), arg_0 -> AccountID.PROTOBUF.measureRecord(arg_0));
        }
        if (data.entity().kind() == EntityID.EntityOneOfType.LIVE_HASH) {
            ProtoWriterTools.writeMessage((WritableSequentialData)out, (FieldDefinition)EntityIDSchema.LIVE_HASH, (Object)((LiveHash)data.entity().as()), (arg_0, arg_1) -> LiveHash.PROTOBUF.write(arg_0, arg_1), arg_0 -> LiveHash.PROTOBUF.measureRecord(arg_0));
        }
        if (data.entity().kind() == EntityID.EntityOneOfType.FILE_ID) {
            ProtoWriterTools.writeMessage((WritableSequentialData)out, (FieldDefinition)EntityIDSchema.FILE_ID, (Object)((FileID)data.entity().as()), (arg_0, arg_1) -> FileID.PROTOBUF.write(arg_0, arg_1), arg_0 -> FileID.PROTOBUF.measureRecord(arg_0));
        }
        if (data.entity().kind() == EntityID.EntityOneOfType.CONTRACT_ID) {
            ProtoWriterTools.writeMessage((WritableSequentialData)out, (FieldDefinition)EntityIDSchema.CONTRACT_ID, (Object)((ContractID)data.entity().as()), (arg_0, arg_1) -> ContractID.PROTOBUF.write(arg_0, arg_1), arg_0 -> ContractID.PROTOBUF.measureRecord(arg_0));
        }
    }

    public int measure(@NonNull ReadableSequentialData input) throws IOException {
        long start = input.position();
        this.parse(input);
        long end = input.position();
        return (int)(end - start);
    }

    public int measureRecord(EntityID data) {
        int size = 0;
        if (data.entity().kind() == EntityID.EntityOneOfType.ACCOUNT_ID) {
            size += ProtoWriterTools.sizeOfMessage((FieldDefinition)EntityIDSchema.ACCOUNT_ID, (Object)((AccountID)data.entity().as()), arg_0 -> AccountID.PROTOBUF.measureRecord(arg_0));
        }
        if (data.entity().kind() == EntityID.EntityOneOfType.LIVE_HASH) {
            size += ProtoWriterTools.sizeOfMessage((FieldDefinition)EntityIDSchema.LIVE_HASH, (Object)((LiveHash)data.entity().as()), arg_0 -> LiveHash.PROTOBUF.measureRecord(arg_0));
        }
        if (data.entity().kind() == EntityID.EntityOneOfType.FILE_ID) {
            size += ProtoWriterTools.sizeOfMessage((FieldDefinition)EntityIDSchema.FILE_ID, (Object)((FileID)data.entity().as()), arg_0 -> FileID.PROTOBUF.measureRecord(arg_0));
        }
        if (data.entity().kind() == EntityID.EntityOneOfType.CONTRACT_ID) {
            size += ProtoWriterTools.sizeOfMessage((FieldDefinition)EntityIDSchema.CONTRACT_ID, (Object)((ContractID)data.entity().as()), arg_0 -> ContractID.PROTOBUF.measureRecord(arg_0));
        }
        return size;
    }

    public boolean fastEquals(@NonNull EntityID item, @NonNull ReadableSequentialData input) throws IOException {
        return item.equals(this.parse(input));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NonNull
    private EntityID parseInternal(@NonNull ReadableSequentialData input, boolean strictMode) throws IOException {
        OneOf temp_entity = ENTITY_UNSET;
        try {
            block8: while (input.hasRemaining()) {
                int tag = input.readVarInt(false);
                int field = tag >>> 3;
                FieldDefinition f = EntityIDSchema.getField(field);
                switch (tag) {
                    case 10: {
                        int messageLength = input.readVarInt(false);
                        long limitBefore = input.limit();
                        input.limit(input.position() + (long)messageLength);
                        Record value = strictMode ? (AccountID)AccountID.PROTOBUF.parseStrict(input) : (AccountID)AccountID.PROTOBUF.parse(input);
                        input.limit(limitBefore);
                        temp_entity = new OneOf((Object)EntityID.EntityOneOfType.ACCOUNT_ID, (Object)value);
                        continue block8;
                    }
                    case 18: {
                        int messageLength = input.readVarInt(false);
                        long limitBefore = input.limit();
                        input.limit(input.position() + (long)messageLength);
                        Record value = strictMode ? (LiveHash)LiveHash.PROTOBUF.parseStrict(input) : (LiveHash)LiveHash.PROTOBUF.parse(input);
                        input.limit(limitBefore);
                        temp_entity = new OneOf((Object)EntityID.EntityOneOfType.LIVE_HASH, (Object)value);
                        continue block8;
                    }
                    case 26: {
                        int messageLength = input.readVarInt(false);
                        long limitBefore = input.limit();
                        input.limit(input.position() + (long)messageLength);
                        Record value = strictMode ? (FileID)FileID.PROTOBUF.parseStrict(input) : (FileID)FileID.PROTOBUF.parse(input);
                        input.limit(limitBefore);
                        temp_entity = new OneOf((Object)EntityID.EntityOneOfType.FILE_ID, (Object)value);
                        continue block8;
                    }
                    case 34: {
                        int messageLength = input.readVarInt(false);
                        long limitBefore = input.limit();
                        input.limit(input.position() + (long)messageLength);
                        Record value = strictMode ? (ContractID)ContractID.PROTOBUF.parseStrict(input) : (ContractID)ContractID.PROTOBUF.parse(input);
                        input.limit(limitBefore);
                        temp_entity = new OneOf((Object)EntityID.EntityOneOfType.CONTRACT_ID, (Object)value);
                        continue block8;
                    }
                }
                int wireType = tag & 7;
                if (field == 0) {
                    throw new IOException("Bad protobuf encoding. We read a field value of " + field);
                }
                if (wireType > 5) {
                    throw new IOException("Cannot understand wire_type of " + wireType);
                }
                if (f != null) throw new IOException("Bad tag [" + tag + "], field [" + field + "] wireType [" + wireType + "]");
                if (strictMode) {
                    throw new UnknownFieldException(field);
                }
                ProtoParserTools.skipField((ReadableSequentialData)input, (int)wireType);
            }
            return new EntityID(temp_entity);
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        return new EntityID(temp_entity);
    }
}

