/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.transaction.codec;

import com.hedera.hapi.node.base.TimestampSeconds;
import com.hedera.hapi.node.transaction.ExchangeRate;
import com.hedera.hapi.node.transaction.schema.ExchangeRateSchema;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.FieldDefinition;
import com.hedera.pbj.runtime.ProtoParserTools;
import com.hedera.pbj.runtime.ProtoWriterTools;
import com.hedera.pbj.runtime.UnknownFieldException;
import com.hedera.pbj.runtime.io.ReadableSequentialData;
import com.hedera.pbj.runtime.io.WritableSequentialData;
import com.hedera.pbj.runtime.io.stream.EOFException;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;

public final class ExchangeRateProtoCodec
implements Codec<ExchangeRate> {
    @NonNull
    public ExchangeRate parse(@NonNull ReadableSequentialData input) throws IOException {
        return this.parseInternal(input, false);
    }

    @NonNull
    public ExchangeRate parseStrict(@NonNull ReadableSequentialData input) throws IOException {
        return this.parseInternal(input, true);
    }

    public void write(@NonNull ExchangeRate data, @NonNull WritableSequentialData out) throws IOException {
        ProtoWriterTools.writeInteger((WritableSequentialData)out, (FieldDefinition)ExchangeRateSchema.HBAR_EQUIV, (int)data.hbarEquiv());
        ProtoWriterTools.writeInteger((WritableSequentialData)out, (FieldDefinition)ExchangeRateSchema.CENT_EQUIV, (int)data.centEquiv());
        ProtoWriterTools.writeMessage((WritableSequentialData)out, (FieldDefinition)ExchangeRateSchema.EXPIRATION_TIME, (Object)data.expirationTime(), (arg_0, arg_1) -> TimestampSeconds.PROTOBUF.write(arg_0, arg_1), arg_0 -> TimestampSeconds.PROTOBUF.measureRecord(arg_0));
    }

    public int measure(@NonNull ReadableSequentialData input) throws IOException {
        long start = input.position();
        this.parse(input);
        long end = input.position();
        return (int)(end - start);
    }

    public int measureRecord(ExchangeRate data) {
        int size = 0;
        size += ProtoWriterTools.sizeOfInteger((FieldDefinition)ExchangeRateSchema.HBAR_EQUIV, (int)data.hbarEquiv());
        size += ProtoWriterTools.sizeOfInteger((FieldDefinition)ExchangeRateSchema.CENT_EQUIV, (int)data.centEquiv());
        return size += ProtoWriterTools.sizeOfMessage((FieldDefinition)ExchangeRateSchema.EXPIRATION_TIME, (Object)data.expirationTime(), arg_0 -> TimestampSeconds.PROTOBUF.measureRecord(arg_0));
    }

    public boolean fastEquals(@NonNull ExchangeRate item, @NonNull ReadableSequentialData input) throws IOException {
        return item.equals(this.parse(input));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NonNull
    private ExchangeRate parseInternal(@NonNull ReadableSequentialData input, boolean strictMode) throws IOException {
        int temp_hbarEquiv = 0;
        int temp_centEquiv = 0;
        TimestampSeconds temp_expirationTime = null;
        try {
            block7: while (input.hasRemaining()) {
                int tag = input.readVarInt(false);
                int field = tag >>> 3;
                FieldDefinition f = ExchangeRateSchema.getField(field);
                switch (tag) {
                    case 8: {
                        int value;
                        temp_hbarEquiv = value = ProtoParserTools.readInt32((ReadableSequentialData)input);
                        continue block7;
                    }
                    case 16: {
                        int value;
                        temp_centEquiv = value = ProtoParserTools.readInt32((ReadableSequentialData)input);
                        continue block7;
                    }
                    case 26: {
                        int messageLength = input.readVarInt(false);
                        long limitBefore = input.limit();
                        input.limit(input.position() + (long)messageLength);
                        TimestampSeconds value = strictMode ? (TimestampSeconds)TimestampSeconds.PROTOBUF.parseStrict(input) : (TimestampSeconds)TimestampSeconds.PROTOBUF.parse(input);
                        input.limit(limitBefore);
                        temp_expirationTime = value;
                        continue block7;
                    }
                }
                int wireType = tag & 7;
                if (field == 0) {
                    throw new IOException("Bad protobuf encoding. We read a field value of " + field);
                }
                if (wireType > 5) {
                    throw new IOException("Cannot understand wire_type of " + wireType);
                }
                if (f != null) throw new IOException("Bad tag [" + tag + "], field [" + field + "] wireType [" + wireType + "]");
                if (strictMode) {
                    throw new UnknownFieldException(field);
                }
                ProtoParserTools.skipField((ReadableSequentialData)input, (int)wireType);
            }
            return new ExchangeRate(temp_hbarEquiv, temp_centEquiv, temp_expirationTime);
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        return new ExchangeRate(temp_hbarEquiv, temp_centEquiv, temp_expirationTime);
    }
}

