/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.transaction.codec;

import com.hedera.hapi.node.transaction.ThrottleBucket;
import com.hedera.hapi.node.transaction.ThrottleGroup;
import com.hedera.hapi.node.transaction.schema.ThrottleBucketSchema;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.FieldDefinition;
import com.hedera.pbj.runtime.ProtoParserTools;
import com.hedera.pbj.runtime.ProtoWriterTools;
import com.hedera.pbj.runtime.UnknownFieldException;
import com.hedera.pbj.runtime.io.ReadableSequentialData;
import com.hedera.pbj.runtime.io.WritableSequentialData;
import com.hedera.pbj.runtime.io.stream.EOFException;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import java.util.Collections;
import java.util.List;

public final class ThrottleBucketProtoCodec
implements Codec<ThrottleBucket> {
    @NonNull
    public ThrottleBucket parse(@NonNull ReadableSequentialData input) throws IOException {
        return this.parseInternal(input, false);
    }

    @NonNull
    public ThrottleBucket parseStrict(@NonNull ReadableSequentialData input) throws IOException {
        return this.parseInternal(input, true);
    }

    public void write(@NonNull ThrottleBucket data, @NonNull WritableSequentialData out) throws IOException {
        ProtoWriterTools.writeString((WritableSequentialData)out, (FieldDefinition)ThrottleBucketSchema.NAME, (String)data.name());
        ProtoWriterTools.writeLong((WritableSequentialData)out, (FieldDefinition)ThrottleBucketSchema.BURST_PERIOD_MS, (long)data.burstPeriodMs());
        ProtoWriterTools.writeMessageList((WritableSequentialData)out, (FieldDefinition)ThrottleBucketSchema.THROTTLE_GROUPS, data.throttleGroups(), (arg_0, arg_1) -> ThrottleGroup.PROTOBUF.write(arg_0, arg_1), arg_0 -> ThrottleGroup.PROTOBUF.measureRecord(arg_0));
    }

    public int measure(@NonNull ReadableSequentialData input) throws IOException {
        long start = input.position();
        this.parse(input);
        long end = input.position();
        return (int)(end - start);
    }

    public int measureRecord(ThrottleBucket data) {
        int size = 0;
        size += ProtoWriterTools.sizeOfString((FieldDefinition)ThrottleBucketSchema.NAME, (String)data.name());
        size += ProtoWriterTools.sizeOfLong((FieldDefinition)ThrottleBucketSchema.BURST_PERIOD_MS, (long)data.burstPeriodMs());
        return size += ProtoWriterTools.sizeOfMessageList((FieldDefinition)ThrottleBucketSchema.THROTTLE_GROUPS, data.throttleGroups(), arg_0 -> ThrottleGroup.PROTOBUF.measureRecord(arg_0));
    }

    public boolean fastEquals(@NonNull ThrottleBucket item, @NonNull ReadableSequentialData input) throws IOException {
        return item.equals(this.parse(input));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NonNull
    private ThrottleBucket parseInternal(@NonNull ReadableSequentialData input, boolean strictMode) throws IOException {
        String temp_name = "";
        long temp_burstPeriodMs = 0L;
        List temp_throttleGroups = Collections.emptyList();
        try {
            block7: while (input.hasRemaining()) {
                int tag = input.readVarInt(false);
                int field = tag >>> 3;
                FieldDefinition f = ThrottleBucketSchema.getField(field);
                switch (tag) {
                    case 10: {
                        String value;
                        temp_name = value = ProtoParserTools.readString((ReadableSequentialData)input);
                        continue block7;
                    }
                    case 16: {
                        long value;
                        temp_burstPeriodMs = value = ProtoParserTools.readUint64((ReadableSequentialData)input);
                        continue block7;
                    }
                    case 26: {
                        int messageLength = input.readVarInt(false);
                        long limitBefore = input.limit();
                        input.limit(input.position() + (long)messageLength);
                        ThrottleGroup value = strictMode ? (ThrottleGroup)ThrottleGroup.PROTOBUF.parseStrict(input) : (ThrottleGroup)ThrottleGroup.PROTOBUF.parse(input);
                        input.limit(limitBefore);
                        temp_throttleGroups = ProtoParserTools.addToList(temp_throttleGroups, (Object)value);
                        continue block7;
                    }
                }
                int wireType = tag & 7;
                if (field == 0) {
                    throw new IOException("Bad protobuf encoding. We read a field value of " + field);
                }
                if (wireType > 5) {
                    throw new IOException("Cannot understand wire_type of " + wireType);
                }
                if (f != null) throw new IOException("Bad tag [" + tag + "], field [" + field + "] wireType [" + wireType + "]");
                if (strictMode) {
                    throw new UnknownFieldException(field);
                }
                ProtoParserTools.skipField((ReadableSequentialData)input, (int)wireType);
            }
            return new ThrottleBucket(temp_name, temp_burstPeriodMs, temp_throttleGroups);
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        return new ThrottleBucket(temp_name, temp_burstPeriodMs, temp_throttleGroups);
    }
}

