/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.streams;

import com.hedera.hapi.streams.codec.StorageChangeJsonCodec;
import com.hedera.hapi.streams.codec.StorageChangeProtoCodec;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.JsonCodec;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Objects;
import java.util.function.Consumer;

public record StorageChange(Bytes slot, Bytes valueRead, @Nullable Bytes valueWritten) {
    public static final Codec<StorageChange> PROTOBUF = new StorageChangeProtoCodec();
    public static final JsonCodec<StorageChange> JSON = new StorageChangeJsonCodec();
    public static final StorageChange DEFAULT = StorageChange.newBuilder().build();

    public boolean hasValueWritten() {
        return this.valueWritten != null;
    }

    public Bytes valueWrittenOrElse(@NonNull Bytes defaultValue) {
        return this.hasValueWritten() ? this.valueWritten : defaultValue;
    }

    @NonNull
    public Bytes valueWrittenOrThrow() {
        return Objects.requireNonNull(this.valueWritten, "Field valueWritten is null");
    }

    public void ifValueWritten(@NonNull Consumer<Bytes> ifPresent) {
        if (this.hasValueWritten()) {
            ifPresent.accept(this.valueWritten);
        }
    }

    public Builder copyBuilder() {
        return new Builder(this.slot, this.valueRead, this.valueWritten);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        private Bytes slot = Bytes.EMPTY;
        private Bytes valueRead = Bytes.EMPTY;
        private Bytes valueWritten = null;

        public Builder() {
        }

        public Builder(Bytes slot, Bytes valueRead, Bytes valueWritten) {
            this.slot = slot;
            this.valueRead = valueRead;
            this.valueWritten = valueWritten;
        }

        public StorageChange build() {
            return new StorageChange(this.slot, this.valueRead, this.valueWritten);
        }

        public Builder slot(Bytes slot) {
            this.slot = slot;
            return this;
        }

        public Builder valueRead(Bytes valueRead) {
            this.valueRead = valueRead;
            return this;
        }

        public Builder valueWritten(Bytes valueWritten) {
            this.valueWritten = valueWritten;
            return this;
        }
    }
}

