/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.streams.codec;

import com.hedera.hapi.node.base.ContractID;
import com.hedera.hapi.streams.ContractBytecode;
import com.hedera.hapi.streams.schema.ContractBytecodeSchema;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.FieldDefinition;
import com.hedera.pbj.runtime.ProtoParserTools;
import com.hedera.pbj.runtime.ProtoWriterTools;
import com.hedera.pbj.runtime.UnknownFieldException;
import com.hedera.pbj.runtime.io.ReadableSequentialData;
import com.hedera.pbj.runtime.io.WritableSequentialData;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.hedera.pbj.runtime.io.buffer.RandomAccessData;
import com.hedera.pbj.runtime.io.stream.EOFException;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;

public final class ContractBytecodeProtoCodec
implements Codec<ContractBytecode> {
    @NonNull
    public ContractBytecode parse(@NonNull ReadableSequentialData input) throws IOException {
        return this.parseInternal(input, false);
    }

    @NonNull
    public ContractBytecode parseStrict(@NonNull ReadableSequentialData input) throws IOException {
        return this.parseInternal(input, true);
    }

    public void write(@NonNull ContractBytecode data, @NonNull WritableSequentialData out) throws IOException {
        ProtoWriterTools.writeMessage((WritableSequentialData)out, (FieldDefinition)ContractBytecodeSchema.CONTRACT_ID, (Object)data.contractId(), (arg_0, arg_1) -> ContractID.PROTOBUF.write(arg_0, arg_1), arg_0 -> ContractID.PROTOBUF.measureRecord(arg_0));
        ProtoWriterTools.writeBytes((WritableSequentialData)out, (FieldDefinition)ContractBytecodeSchema.INITCODE, (RandomAccessData)data.initcode());
        ProtoWriterTools.writeBytes((WritableSequentialData)out, (FieldDefinition)ContractBytecodeSchema.RUNTIME_BYTECODE, (RandomAccessData)data.runtimeBytecode());
    }

    public int measure(@NonNull ReadableSequentialData input) throws IOException {
        long start = input.position();
        this.parse(input);
        long end = input.position();
        return (int)(end - start);
    }

    public int measureRecord(ContractBytecode data) {
        int size = 0;
        size += ProtoWriterTools.sizeOfMessage((FieldDefinition)ContractBytecodeSchema.CONTRACT_ID, (Object)data.contractId(), arg_0 -> ContractID.PROTOBUF.measureRecord(arg_0));
        size += ProtoWriterTools.sizeOfBytes((FieldDefinition)ContractBytecodeSchema.INITCODE, (RandomAccessData)data.initcode());
        return size += ProtoWriterTools.sizeOfBytes((FieldDefinition)ContractBytecodeSchema.RUNTIME_BYTECODE, (RandomAccessData)data.runtimeBytecode());
    }

    public boolean fastEquals(@NonNull ContractBytecode item, @NonNull ReadableSequentialData input) throws IOException {
        return item.equals(this.parse(input));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NonNull
    private ContractBytecode parseInternal(@NonNull ReadableSequentialData input, boolean strictMode) throws IOException {
        ContractID temp_contract_id = null;
        Bytes temp_initcode = Bytes.EMPTY;
        Bytes temp_runtime_bytecode = Bytes.EMPTY;
        try {
            block7: while (input.hasRemaining()) {
                int tag = input.readVarInt(false);
                int field = tag >>> 3;
                FieldDefinition f = ContractBytecodeSchema.getField(field);
                switch (tag) {
                    case 10: {
                        int messageLength = input.readVarInt(false);
                        long limitBefore = input.limit();
                        input.limit(input.position() + (long)messageLength);
                        ContractID value = strictMode ? (ContractID)ContractID.PROTOBUF.parseStrict(input) : (ContractID)ContractID.PROTOBUF.parse(input);
                        input.limit(limitBefore);
                        temp_contract_id = value;
                        continue block7;
                    }
                    case 18: {
                        Bytes value;
                        temp_initcode = value = ProtoParserTools.readBytes((ReadableSequentialData)input);
                        continue block7;
                    }
                    case 26: {
                        Bytes value;
                        temp_runtime_bytecode = value = ProtoParserTools.readBytes((ReadableSequentialData)input);
                        continue block7;
                    }
                }
                int wireType = tag & 7;
                if (field == 0) {
                    throw new IOException("Bad protobuf encoding. We read a field value of " + field);
                }
                if (wireType > 5) {
                    throw new IOException("Cannot understand wire_type of " + wireType);
                }
                if (f != null) throw new IOException("Bad tag [" + tag + "], field [" + field + "] wireType [" + wireType + "]");
                if (strictMode) {
                    throw new UnknownFieldException(field);
                }
                ProtoParserTools.skipField((ReadableSequentialData)input, (int)wireType);
            }
            return new ContractBytecode(temp_contract_id, temp_initcode, temp_runtime_bytecode);
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        return new ContractBytecode(temp_contract_id, temp_initcode, temp_runtime_bytecode);
    }
}

