/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.streams.codec;

import com.hedera.hapi.node.base.SemanticVersion;
import com.hedera.hapi.streams.HashObject;
import com.hedera.hapi.streams.RecordStreamFile;
import com.hedera.hapi.streams.RecordStreamItem;
import com.hedera.hapi.streams.SidecarMetadata;
import com.hedera.hapi.streams.schema.RecordStreamFileSchema;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.FieldDefinition;
import com.hedera.pbj.runtime.ProtoParserTools;
import com.hedera.pbj.runtime.ProtoWriterTools;
import com.hedera.pbj.runtime.UnknownFieldException;
import com.hedera.pbj.runtime.io.ReadableSequentialData;
import com.hedera.pbj.runtime.io.WritableSequentialData;
import com.hedera.pbj.runtime.io.stream.EOFException;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import java.util.Collections;
import java.util.List;

public final class RecordStreamFileProtoCodec
implements Codec<RecordStreamFile> {
    @NonNull
    public RecordStreamFile parse(@NonNull ReadableSequentialData input) throws IOException {
        return this.parseInternal(input, false);
    }

    @NonNull
    public RecordStreamFile parseStrict(@NonNull ReadableSequentialData input) throws IOException {
        return this.parseInternal(input, true);
    }

    public void write(@NonNull RecordStreamFile data, @NonNull WritableSequentialData out) throws IOException {
        ProtoWriterTools.writeMessage((WritableSequentialData)out, (FieldDefinition)RecordStreamFileSchema.HAPI_PROTO_VERSION, (Object)data.hapiProtoVersion(), (arg_0, arg_1) -> SemanticVersion.PROTOBUF.write(arg_0, arg_1), arg_0 -> SemanticVersion.PROTOBUF.measureRecord(arg_0));
        ProtoWriterTools.writeMessage((WritableSequentialData)out, (FieldDefinition)RecordStreamFileSchema.START_OBJECT_RUNNING_HASH, (Object)data.startObjectRunningHash(), (arg_0, arg_1) -> HashObject.PROTOBUF.write(arg_0, arg_1), arg_0 -> HashObject.PROTOBUF.measureRecord(arg_0));
        ProtoWriterTools.writeMessageList((WritableSequentialData)out, (FieldDefinition)RecordStreamFileSchema.RECORD_STREAM_ITEMS, data.recordStreamItems(), (arg_0, arg_1) -> RecordStreamItem.PROTOBUF.write(arg_0, arg_1), arg_0 -> RecordStreamItem.PROTOBUF.measureRecord(arg_0));
        ProtoWriterTools.writeMessage((WritableSequentialData)out, (FieldDefinition)RecordStreamFileSchema.END_OBJECT_RUNNING_HASH, (Object)data.endObjectRunningHash(), (arg_0, arg_1) -> HashObject.PROTOBUF.write(arg_0, arg_1), arg_0 -> HashObject.PROTOBUF.measureRecord(arg_0));
        ProtoWriterTools.writeLong((WritableSequentialData)out, (FieldDefinition)RecordStreamFileSchema.BLOCK_NUMBER, (long)data.blockNumber());
        ProtoWriterTools.writeMessageList((WritableSequentialData)out, (FieldDefinition)RecordStreamFileSchema.SIDECARS, data.sidecars(), (arg_0, arg_1) -> SidecarMetadata.PROTOBUF.write(arg_0, arg_1), arg_0 -> SidecarMetadata.PROTOBUF.measureRecord(arg_0));
    }

    public int measure(@NonNull ReadableSequentialData input) throws IOException {
        long start = input.position();
        this.parse(input);
        long end = input.position();
        return (int)(end - start);
    }

    public int measureRecord(RecordStreamFile data) {
        int size = 0;
        size += ProtoWriterTools.sizeOfMessage((FieldDefinition)RecordStreamFileSchema.HAPI_PROTO_VERSION, (Object)data.hapiProtoVersion(), arg_0 -> SemanticVersion.PROTOBUF.measureRecord(arg_0));
        size += ProtoWriterTools.sizeOfMessage((FieldDefinition)RecordStreamFileSchema.START_OBJECT_RUNNING_HASH, (Object)data.startObjectRunningHash(), arg_0 -> HashObject.PROTOBUF.measureRecord(arg_0));
        size += ProtoWriterTools.sizeOfMessageList((FieldDefinition)RecordStreamFileSchema.RECORD_STREAM_ITEMS, data.recordStreamItems(), arg_0 -> RecordStreamItem.PROTOBUF.measureRecord(arg_0));
        size += ProtoWriterTools.sizeOfMessage((FieldDefinition)RecordStreamFileSchema.END_OBJECT_RUNNING_HASH, (Object)data.endObjectRunningHash(), arg_0 -> HashObject.PROTOBUF.measureRecord(arg_0));
        size += ProtoWriterTools.sizeOfLong((FieldDefinition)RecordStreamFileSchema.BLOCK_NUMBER, (long)data.blockNumber());
        return size += ProtoWriterTools.sizeOfMessageList((FieldDefinition)RecordStreamFileSchema.SIDECARS, data.sidecars(), arg_0 -> SidecarMetadata.PROTOBUF.measureRecord(arg_0));
    }

    public boolean fastEquals(@NonNull RecordStreamFile item, @NonNull ReadableSequentialData input) throws IOException {
        return item.equals(this.parse(input));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NonNull
    private RecordStreamFile parseInternal(@NonNull ReadableSequentialData input, boolean strictMode) throws IOException {
        Record temp_hapi_proto_version = null;
        Record temp_start_object_running_hash = null;
        List temp_record_stream_items = Collections.emptyList();
        Record temp_end_object_running_hash = null;
        long temp_block_number = 0L;
        List temp_sidecars = Collections.emptyList();
        try {
            block10: while (input.hasRemaining()) {
                int tag = input.readVarInt(false);
                int field = tag >>> 3;
                FieldDefinition f = RecordStreamFileSchema.getField(field);
                switch (tag) {
                    case 10: {
                        int messageLength = input.readVarInt(false);
                        long limitBefore = input.limit();
                        input.limit(input.position() + (long)messageLength);
                        Record value = strictMode ? (SemanticVersion)SemanticVersion.PROTOBUF.parseStrict(input) : (SemanticVersion)SemanticVersion.PROTOBUF.parse(input);
                        input.limit(limitBefore);
                        temp_hapi_proto_version = value;
                        continue block10;
                    }
                    case 18: {
                        int messageLength = input.readVarInt(false);
                        long limitBefore = input.limit();
                        input.limit(input.position() + (long)messageLength);
                        Record value = strictMode ? (HashObject)HashObject.PROTOBUF.parseStrict(input) : (HashObject)HashObject.PROTOBUF.parse(input);
                        input.limit(limitBefore);
                        temp_start_object_running_hash = value;
                        continue block10;
                    }
                    case 26: {
                        int messageLength = input.readVarInt(false);
                        long limitBefore = input.limit();
                        input.limit(input.position() + (long)messageLength);
                        Record value = strictMode ? (RecordStreamItem)RecordStreamItem.PROTOBUF.parseStrict(input) : (RecordStreamItem)RecordStreamItem.PROTOBUF.parse(input);
                        input.limit(limitBefore);
                        temp_record_stream_items = ProtoParserTools.addToList(temp_record_stream_items, (Object)value);
                        continue block10;
                    }
                    case 34: {
                        int messageLength = input.readVarInt(false);
                        long limitBefore = input.limit();
                        input.limit(input.position() + (long)messageLength);
                        Record value = strictMode ? (HashObject)HashObject.PROTOBUF.parseStrict(input) : (HashObject)HashObject.PROTOBUF.parse(input);
                        input.limit(limitBefore);
                        temp_end_object_running_hash = value;
                        continue block10;
                    }
                    case 40: {
                        long value;
                        temp_block_number = value = ProtoParserTools.readInt64((ReadableSequentialData)input);
                        continue block10;
                    }
                    case 50: {
                        int messageLength = input.readVarInt(false);
                        long limitBefore = input.limit();
                        input.limit(input.position() + (long)messageLength);
                        Record value = strictMode ? (SidecarMetadata)SidecarMetadata.PROTOBUF.parseStrict(input) : (SidecarMetadata)SidecarMetadata.PROTOBUF.parse(input);
                        input.limit(limitBefore);
                        temp_sidecars = ProtoParserTools.addToList(temp_sidecars, (Object)value);
                        continue block10;
                    }
                }
                int wireType = tag & 7;
                if (field == 0) {
                    throw new IOException("Bad protobuf encoding. We read a field value of " + field);
                }
                if (wireType > 5) {
                    throw new IOException("Cannot understand wire_type of " + wireType);
                }
                if (f != null) throw new IOException("Bad tag [" + tag + "], field [" + field + "] wireType [" + wireType + "]");
                if (strictMode) {
                    throw new UnknownFieldException(field);
                }
                ProtoParserTools.skipField((ReadableSequentialData)input, (int)wireType);
            }
            return new RecordStreamFile((SemanticVersion)temp_hapi_proto_version, (HashObject)temp_start_object_running_hash, temp_record_stream_items, (HashObject)temp_end_object_running_hash, temp_block_number, temp_sidecars);
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        return new RecordStreamFile((SemanticVersion)temp_hapi_proto_version, (HashObject)temp_start_object_running_hash, temp_record_stream_items, (HashObject)temp_end_object_running_hash, temp_block_number, temp_sidecars);
    }
}

