/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.streams.codec;

import com.hedera.hapi.node.base.Transaction;
import com.hedera.hapi.node.transaction.TransactionRecord;
import com.hedera.hapi.streams.RecordStreamItem;
import com.hedera.hapi.streams.schema.RecordStreamItemSchema;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.FieldDefinition;
import com.hedera.pbj.runtime.ProtoParserTools;
import com.hedera.pbj.runtime.ProtoWriterTools;
import com.hedera.pbj.runtime.UnknownFieldException;
import com.hedera.pbj.runtime.io.ReadableSequentialData;
import com.hedera.pbj.runtime.io.WritableSequentialData;
import com.hedera.pbj.runtime.io.stream.EOFException;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;

public final class RecordStreamItemProtoCodec
implements Codec<RecordStreamItem> {
    @NonNull
    public RecordStreamItem parse(@NonNull ReadableSequentialData input) throws IOException {
        return this.parseInternal(input, false);
    }

    @NonNull
    public RecordStreamItem parseStrict(@NonNull ReadableSequentialData input) throws IOException {
        return this.parseInternal(input, true);
    }

    public void write(@NonNull RecordStreamItem data, @NonNull WritableSequentialData out) throws IOException {
        ProtoWriterTools.writeMessage((WritableSequentialData)out, (FieldDefinition)RecordStreamItemSchema.TRANSACTION, (Object)data.transaction(), (arg_0, arg_1) -> Transaction.PROTOBUF.write(arg_0, arg_1), arg_0 -> Transaction.PROTOBUF.measureRecord(arg_0));
        ProtoWriterTools.writeMessage((WritableSequentialData)out, (FieldDefinition)RecordStreamItemSchema.RECORD, (Object)data.record(), (arg_0, arg_1) -> TransactionRecord.PROTOBUF.write(arg_0, arg_1), arg_0 -> TransactionRecord.PROTOBUF.measureRecord(arg_0));
    }

    public int measure(@NonNull ReadableSequentialData input) throws IOException {
        long start = input.position();
        this.parse(input);
        long end = input.position();
        return (int)(end - start);
    }

    public int measureRecord(RecordStreamItem data) {
        int size = 0;
        size += ProtoWriterTools.sizeOfMessage((FieldDefinition)RecordStreamItemSchema.TRANSACTION, (Object)data.transaction(), arg_0 -> Transaction.PROTOBUF.measureRecord(arg_0));
        return size += ProtoWriterTools.sizeOfMessage((FieldDefinition)RecordStreamItemSchema.RECORD, (Object)data.record(), arg_0 -> TransactionRecord.PROTOBUF.measureRecord(arg_0));
    }

    public boolean fastEquals(@NonNull RecordStreamItem item, @NonNull ReadableSequentialData input) throws IOException {
        return item.equals(this.parse(input));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NonNull
    private RecordStreamItem parseInternal(@NonNull ReadableSequentialData input, boolean strictMode) throws IOException {
        Record temp_transaction = null;
        Record temp_record = null;
        try {
            block6: while (input.hasRemaining()) {
                int tag = input.readVarInt(false);
                int field = tag >>> 3;
                FieldDefinition f = RecordStreamItemSchema.getField(field);
                switch (tag) {
                    case 10: {
                        int messageLength = input.readVarInt(false);
                        long limitBefore = input.limit();
                        input.limit(input.position() + (long)messageLength);
                        Record value = strictMode ? (Transaction)Transaction.PROTOBUF.parseStrict(input) : (Transaction)Transaction.PROTOBUF.parse(input);
                        input.limit(limitBefore);
                        temp_transaction = value;
                        continue block6;
                    }
                    case 18: {
                        int messageLength = input.readVarInt(false);
                        long limitBefore = input.limit();
                        input.limit(input.position() + (long)messageLength);
                        Record value = strictMode ? (TransactionRecord)TransactionRecord.PROTOBUF.parseStrict(input) : (TransactionRecord)TransactionRecord.PROTOBUF.parse(input);
                        input.limit(limitBefore);
                        temp_record = value;
                        continue block6;
                    }
                }
                int wireType = tag & 7;
                if (field == 0) {
                    throw new IOException("Bad protobuf encoding. We read a field value of " + field);
                }
                if (wireType > 5) {
                    throw new IOException("Cannot understand wire_type of " + wireType);
                }
                if (f != null) throw new IOException("Bad tag [" + tag + "], field [" + field + "] wireType [" + wireType + "]");
                if (strictMode) {
                    throw new UnknownFieldException(field);
                }
                ProtoParserTools.skipField((ReadableSequentialData)input, (int)wireType);
            }
            return new RecordStreamItem((Transaction)temp_transaction, (TransactionRecord)temp_record);
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        return new RecordStreamItem((Transaction)temp_transaction, (TransactionRecord)temp_record);
    }
}

