/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.streams.codec;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.streams.SingleAccountBalances;
import com.hedera.hapi.streams.TokenUnitBalance;
import com.hedera.hapi.streams.schema.SingleAccountBalancesSchema;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.FieldDefinition;
import com.hedera.pbj.runtime.ProtoParserTools;
import com.hedera.pbj.runtime.ProtoWriterTools;
import com.hedera.pbj.runtime.UnknownFieldException;
import com.hedera.pbj.runtime.io.ReadableSequentialData;
import com.hedera.pbj.runtime.io.WritableSequentialData;
import com.hedera.pbj.runtime.io.stream.EOFException;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import java.util.Collections;
import java.util.List;

public final class SingleAccountBalancesProtoCodec
implements Codec<SingleAccountBalances> {
    @NonNull
    public SingleAccountBalances parse(@NonNull ReadableSequentialData input) throws IOException {
        return this.parseInternal(input, false);
    }

    @NonNull
    public SingleAccountBalances parseStrict(@NonNull ReadableSequentialData input) throws IOException {
        return this.parseInternal(input, true);
    }

    public void write(@NonNull SingleAccountBalances data, @NonNull WritableSequentialData out) throws IOException {
        ProtoWriterTools.writeMessage((WritableSequentialData)out, (FieldDefinition)SingleAccountBalancesSchema.ACCOUNT_ID, (Object)data.accountID(), (arg_0, arg_1) -> AccountID.PROTOBUF.write(arg_0, arg_1), arg_0 -> AccountID.PROTOBUF.measureRecord(arg_0));
        ProtoWriterTools.writeLong((WritableSequentialData)out, (FieldDefinition)SingleAccountBalancesSchema.HBAR_BALANCE, (long)data.hbarBalance());
        ProtoWriterTools.writeMessageList((WritableSequentialData)out, (FieldDefinition)SingleAccountBalancesSchema.TOKEN_UNIT_BALANCES, data.tokenUnitBalances(), (arg_0, arg_1) -> TokenUnitBalance.PROTOBUF.write(arg_0, arg_1), arg_0 -> TokenUnitBalance.PROTOBUF.measureRecord(arg_0));
    }

    public int measure(@NonNull ReadableSequentialData input) throws IOException {
        long start = input.position();
        this.parse(input);
        long end = input.position();
        return (int)(end - start);
    }

    public int measureRecord(SingleAccountBalances data) {
        int size = 0;
        size += ProtoWriterTools.sizeOfMessage((FieldDefinition)SingleAccountBalancesSchema.ACCOUNT_ID, (Object)data.accountID(), arg_0 -> AccountID.PROTOBUF.measureRecord(arg_0));
        size += ProtoWriterTools.sizeOfLong((FieldDefinition)SingleAccountBalancesSchema.HBAR_BALANCE, (long)data.hbarBalance());
        return size += ProtoWriterTools.sizeOfMessageList((FieldDefinition)SingleAccountBalancesSchema.TOKEN_UNIT_BALANCES, data.tokenUnitBalances(), arg_0 -> TokenUnitBalance.PROTOBUF.measureRecord(arg_0));
    }

    public boolean fastEquals(@NonNull SingleAccountBalances item, @NonNull ReadableSequentialData input) throws IOException {
        return item.equals(this.parse(input));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NonNull
    private SingleAccountBalances parseInternal(@NonNull ReadableSequentialData input, boolean strictMode) throws IOException {
        Record temp_accountID = null;
        long temp_hbarBalance = 0L;
        List temp_tokenUnitBalances = Collections.emptyList();
        try {
            block7: while (input.hasRemaining()) {
                int tag = input.readVarInt(false);
                int field = tag >>> 3;
                FieldDefinition f = SingleAccountBalancesSchema.getField(field);
                switch (tag) {
                    case 10: {
                        int messageLength = input.readVarInt(false);
                        long limitBefore = input.limit();
                        input.limit(input.position() + (long)messageLength);
                        Record value = strictMode ? (AccountID)AccountID.PROTOBUF.parseStrict(input) : (AccountID)AccountID.PROTOBUF.parse(input);
                        input.limit(limitBefore);
                        temp_accountID = value;
                        continue block7;
                    }
                    case 16: {
                        long value;
                        temp_hbarBalance = value = ProtoParserTools.readUint64((ReadableSequentialData)input);
                        continue block7;
                    }
                    case 26: {
                        int messageLength = input.readVarInt(false);
                        long limitBefore = input.limit();
                        input.limit(input.position() + (long)messageLength);
                        Record value = strictMode ? (TokenUnitBalance)TokenUnitBalance.PROTOBUF.parseStrict(input) : (TokenUnitBalance)TokenUnitBalance.PROTOBUF.parse(input);
                        input.limit(limitBefore);
                        temp_tokenUnitBalances = ProtoParserTools.addToList(temp_tokenUnitBalances, (Object)value);
                        continue block7;
                    }
                }
                int wireType = tag & 7;
                if (field == 0) {
                    throw new IOException("Bad protobuf encoding. We read a field value of " + field);
                }
                if (wireType > 5) {
                    throw new IOException("Cannot understand wire_type of " + wireType);
                }
                if (f != null) throw new IOException("Bad tag [" + tag + "], field [" + field + "] wireType [" + wireType + "]");
                if (strictMode) {
                    throw new UnknownFieldException(field);
                }
                ProtoParserTools.skipField((ReadableSequentialData)input, (int)wireType);
            }
            return new SingleAccountBalances((AccountID)temp_accountID, temp_hbarBalance, temp_tokenUnitBalances);
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        return new SingleAccountBalances((AccountID)temp_accountID, temp_hbarBalance, temp_tokenUnitBalances);
    }
}

