/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.streams.codec;

import com.hedera.hapi.node.base.TokenID;
import com.hedera.hapi.streams.TokenUnitBalance;
import com.hedera.hapi.streams.schema.TokenUnitBalanceSchema;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.FieldDefinition;
import com.hedera.pbj.runtime.ProtoParserTools;
import com.hedera.pbj.runtime.ProtoWriterTools;
import com.hedera.pbj.runtime.UnknownFieldException;
import com.hedera.pbj.runtime.io.ReadableSequentialData;
import com.hedera.pbj.runtime.io.WritableSequentialData;
import com.hedera.pbj.runtime.io.stream.EOFException;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;

public final class TokenUnitBalanceProtoCodec
implements Codec<TokenUnitBalance> {
    @NonNull
    public TokenUnitBalance parse(@NonNull ReadableSequentialData input) throws IOException {
        return this.parseInternal(input, false);
    }

    @NonNull
    public TokenUnitBalance parseStrict(@NonNull ReadableSequentialData input) throws IOException {
        return this.parseInternal(input, true);
    }

    public void write(@NonNull TokenUnitBalance data, @NonNull WritableSequentialData out) throws IOException {
        ProtoWriterTools.writeMessage((WritableSequentialData)out, (FieldDefinition)TokenUnitBalanceSchema.TOKEN_ID, (Object)data.tokenId(), (arg_0, arg_1) -> TokenID.PROTOBUF.write(arg_0, arg_1), arg_0 -> TokenID.PROTOBUF.measureRecord(arg_0));
        ProtoWriterTools.writeLong((WritableSequentialData)out, (FieldDefinition)TokenUnitBalanceSchema.BALANCE, (long)data.balance());
    }

    public int measure(@NonNull ReadableSequentialData input) throws IOException {
        long start = input.position();
        this.parse(input);
        long end = input.position();
        return (int)(end - start);
    }

    public int measureRecord(TokenUnitBalance data) {
        int size = 0;
        size += ProtoWriterTools.sizeOfMessage((FieldDefinition)TokenUnitBalanceSchema.TOKEN_ID, (Object)data.tokenId(), arg_0 -> TokenID.PROTOBUF.measureRecord(arg_0));
        return size += ProtoWriterTools.sizeOfLong((FieldDefinition)TokenUnitBalanceSchema.BALANCE, (long)data.balance());
    }

    public boolean fastEquals(@NonNull TokenUnitBalance item, @NonNull ReadableSequentialData input) throws IOException {
        return item.equals(this.parse(input));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NonNull
    private TokenUnitBalance parseInternal(@NonNull ReadableSequentialData input, boolean strictMode) throws IOException {
        TokenID temp_tokenId = null;
        long temp_balance = 0L;
        try {
            block6: while (input.hasRemaining()) {
                int tag = input.readVarInt(false);
                int field = tag >>> 3;
                FieldDefinition f = TokenUnitBalanceSchema.getField(field);
                switch (tag) {
                    case 10: {
                        int messageLength = input.readVarInt(false);
                        long limitBefore = input.limit();
                        input.limit(input.position() + (long)messageLength);
                        TokenID value = strictMode ? (TokenID)TokenID.PROTOBUF.parseStrict(input) : (TokenID)TokenID.PROTOBUF.parse(input);
                        input.limit(limitBefore);
                        temp_tokenId = value;
                        continue block6;
                    }
                    case 16: {
                        long value;
                        temp_balance = value = ProtoParserTools.readUint64((ReadableSequentialData)input);
                        continue block6;
                    }
                }
                int wireType = tag & 7;
                if (field == 0) {
                    throw new IOException("Bad protobuf encoding. We read a field value of " + field);
                }
                if (wireType > 5) {
                    throw new IOException("Cannot understand wire_type of " + wireType);
                }
                if (f != null) throw new IOException("Bad tag [" + tag + "], field [" + field + "] wireType [" + wireType + "]");
                if (strictMode) {
                    throw new UnknownFieldException(field);
                }
                ProtoParserTools.skipField((ReadableSequentialData)input, (int)wireType);
            }
            return new TokenUnitBalance(temp_tokenId, temp_balance);
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        return new TokenUnitBalance(temp_tokenId, temp_balance);
    }
}

