/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.streams.codec;

import com.hedera.hapi.node.base.Timestamp;
import com.hedera.hapi.streams.ContractActions;
import com.hedera.hapi.streams.ContractBytecode;
import com.hedera.hapi.streams.ContractStateChanges;
import com.hedera.hapi.streams.TransactionSidecarRecord;
import com.hedera.hapi.streams.schema.TransactionSidecarRecordSchema;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.FieldDefinition;
import com.hedera.pbj.runtime.OneOf;
import com.hedera.pbj.runtime.ProtoParserTools;
import com.hedera.pbj.runtime.ProtoWriterTools;
import com.hedera.pbj.runtime.UnknownFieldException;
import com.hedera.pbj.runtime.io.ReadableSequentialData;
import com.hedera.pbj.runtime.io.WritableSequentialData;
import com.hedera.pbj.runtime.io.stream.EOFException;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;

public final class TransactionSidecarRecordProtoCodec
implements Codec<TransactionSidecarRecord> {
    public static final OneOf<TransactionSidecarRecord.SidecarRecordsOneOfType> SIDECAR_RECORDS_UNSET = new OneOf((Object)TransactionSidecarRecord.SidecarRecordsOneOfType.UNSET, null);

    @NonNull
    public TransactionSidecarRecord parse(@NonNull ReadableSequentialData input) throws IOException {
        return this.parseInternal(input, false);
    }

    @NonNull
    public TransactionSidecarRecord parseStrict(@NonNull ReadableSequentialData input) throws IOException {
        return this.parseInternal(input, true);
    }

    public void write(@NonNull TransactionSidecarRecord data, @NonNull WritableSequentialData out) throws IOException {
        ProtoWriterTools.writeMessage((WritableSequentialData)out, (FieldDefinition)TransactionSidecarRecordSchema.CONSENSUS_TIMESTAMP, (Object)data.consensusTimestamp(), (arg_0, arg_1) -> Timestamp.PROTOBUF.write(arg_0, arg_1), arg_0 -> Timestamp.PROTOBUF.measureRecord(arg_0));
        ProtoWriterTools.writeBoolean((WritableSequentialData)out, (FieldDefinition)TransactionSidecarRecordSchema.MIGRATION, (boolean)data.migration());
        if (data.sidecarRecords().kind() == TransactionSidecarRecord.SidecarRecordsOneOfType.STATE_CHANGES) {
            ProtoWriterTools.writeMessage((WritableSequentialData)out, (FieldDefinition)TransactionSidecarRecordSchema.STATE_CHANGES, (Object)((ContractStateChanges)data.sidecarRecords().as()), (arg_0, arg_1) -> ContractStateChanges.PROTOBUF.write(arg_0, arg_1), arg_0 -> ContractStateChanges.PROTOBUF.measureRecord(arg_0));
        }
        if (data.sidecarRecords().kind() == TransactionSidecarRecord.SidecarRecordsOneOfType.ACTIONS) {
            ProtoWriterTools.writeMessage((WritableSequentialData)out, (FieldDefinition)TransactionSidecarRecordSchema.ACTIONS, (Object)((ContractActions)data.sidecarRecords().as()), (arg_0, arg_1) -> ContractActions.PROTOBUF.write(arg_0, arg_1), arg_0 -> ContractActions.PROTOBUF.measureRecord(arg_0));
        }
        if (data.sidecarRecords().kind() == TransactionSidecarRecord.SidecarRecordsOneOfType.BYTECODE) {
            ProtoWriterTools.writeMessage((WritableSequentialData)out, (FieldDefinition)TransactionSidecarRecordSchema.BYTECODE, (Object)((ContractBytecode)data.sidecarRecords().as()), (arg_0, arg_1) -> ContractBytecode.PROTOBUF.write(arg_0, arg_1), arg_0 -> ContractBytecode.PROTOBUF.measureRecord(arg_0));
        }
    }

    public int measure(@NonNull ReadableSequentialData input) throws IOException {
        long start = input.position();
        this.parse(input);
        long end = input.position();
        return (int)(end - start);
    }

    public int measureRecord(TransactionSidecarRecord data) {
        int size = 0;
        size += ProtoWriterTools.sizeOfMessage((FieldDefinition)TransactionSidecarRecordSchema.CONSENSUS_TIMESTAMP, (Object)data.consensusTimestamp(), arg_0 -> Timestamp.PROTOBUF.measureRecord(arg_0));
        size += ProtoWriterTools.sizeOfBoolean((FieldDefinition)TransactionSidecarRecordSchema.MIGRATION, (boolean)data.migration());
        if (data.sidecarRecords().kind() == TransactionSidecarRecord.SidecarRecordsOneOfType.STATE_CHANGES) {
            size += ProtoWriterTools.sizeOfMessage((FieldDefinition)TransactionSidecarRecordSchema.STATE_CHANGES, (Object)((ContractStateChanges)data.sidecarRecords().as()), arg_0 -> ContractStateChanges.PROTOBUF.measureRecord(arg_0));
        }
        if (data.sidecarRecords().kind() == TransactionSidecarRecord.SidecarRecordsOneOfType.ACTIONS) {
            size += ProtoWriterTools.sizeOfMessage((FieldDefinition)TransactionSidecarRecordSchema.ACTIONS, (Object)((ContractActions)data.sidecarRecords().as()), arg_0 -> ContractActions.PROTOBUF.measureRecord(arg_0));
        }
        if (data.sidecarRecords().kind() == TransactionSidecarRecord.SidecarRecordsOneOfType.BYTECODE) {
            size += ProtoWriterTools.sizeOfMessage((FieldDefinition)TransactionSidecarRecordSchema.BYTECODE, (Object)((ContractBytecode)data.sidecarRecords().as()), arg_0 -> ContractBytecode.PROTOBUF.measureRecord(arg_0));
        }
        return size;
    }

    public boolean fastEquals(@NonNull TransactionSidecarRecord item, @NonNull ReadableSequentialData input) throws IOException {
        return item.equals(this.parse(input));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NonNull
    private TransactionSidecarRecord parseInternal(@NonNull ReadableSequentialData input, boolean strictMode) throws IOException {
        Record temp_consensus_timestamp = null;
        boolean temp_migration = false;
        OneOf temp_sidecar_records = SIDECAR_RECORDS_UNSET;
        try {
            block9: while (input.hasRemaining()) {
                int tag = input.readVarInt(false);
                int field = tag >>> 3;
                FieldDefinition f = TransactionSidecarRecordSchema.getField(field);
                switch (tag) {
                    case 10: {
                        int messageLength = input.readVarInt(false);
                        long limitBefore = input.limit();
                        input.limit(input.position() + (long)messageLength);
                        Record value = strictMode ? (Timestamp)Timestamp.PROTOBUF.parseStrict(input) : (Timestamp)Timestamp.PROTOBUF.parse(input);
                        input.limit(limitBefore);
                        temp_consensus_timestamp = value;
                        continue block9;
                    }
                    case 16: {
                        boolean value;
                        temp_migration = value = ProtoParserTools.readBool((ReadableSequentialData)input);
                        continue block9;
                    }
                    case 26: {
                        int messageLength = input.readVarInt(false);
                        long limitBefore = input.limit();
                        input.limit(input.position() + (long)messageLength);
                        Record value = strictMode ? (ContractStateChanges)ContractStateChanges.PROTOBUF.parseStrict(input) : (ContractStateChanges)ContractStateChanges.PROTOBUF.parse(input);
                        input.limit(limitBefore);
                        temp_sidecar_records = new OneOf((Object)TransactionSidecarRecord.SidecarRecordsOneOfType.STATE_CHANGES, (Object)value);
                        continue block9;
                    }
                    case 34: {
                        int messageLength = input.readVarInt(false);
                        long limitBefore = input.limit();
                        input.limit(input.position() + (long)messageLength);
                        Record value = strictMode ? (ContractActions)ContractActions.PROTOBUF.parseStrict(input) : (ContractActions)ContractActions.PROTOBUF.parse(input);
                        input.limit(limitBefore);
                        temp_sidecar_records = new OneOf((Object)TransactionSidecarRecord.SidecarRecordsOneOfType.ACTIONS, (Object)value);
                        continue block9;
                    }
                    case 42: {
                        int messageLength = input.readVarInt(false);
                        long limitBefore = input.limit();
                        input.limit(input.position() + (long)messageLength);
                        Record value = strictMode ? (ContractBytecode)ContractBytecode.PROTOBUF.parseStrict(input) : (ContractBytecode)ContractBytecode.PROTOBUF.parse(input);
                        input.limit(limitBefore);
                        temp_sidecar_records = new OneOf((Object)TransactionSidecarRecord.SidecarRecordsOneOfType.BYTECODE, (Object)value);
                        continue block9;
                    }
                }
                int wireType = tag & 7;
                if (field == 0) {
                    throw new IOException("Bad protobuf encoding. We read a field value of " + field);
                }
                if (wireType > 5) {
                    throw new IOException("Cannot understand wire_type of " + wireType);
                }
                if (f != null) throw new IOException("Bad tag [" + tag + "], field [" + field + "] wireType [" + wireType + "]");
                if (strictMode) {
                    throw new UnknownFieldException(field);
                }
                ProtoParserTools.skipField((ReadableSequentialData)input, (int)wireType);
            }
            return new TransactionSidecarRecord((Timestamp)temp_consensus_timestamp, temp_migration, (OneOf<TransactionSidecarRecord.SidecarRecordsOneOfType>)temp_sidecar_records);
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        return new TransactionSidecarRecord((Timestamp)temp_consensus_timestamp, temp_migration, (OneOf<TransactionSidecarRecord.SidecarRecordsOneOfType>)temp_sidecar_records);
    }
}

