/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.base;

import com.hedera.pbj.runtime.EnumWithProtoMetadata;

public enum HederaFunctionality implements EnumWithProtoMetadata
{
    NONE(0, "NONE"),
    CRYPTO_TRANSFER(1, "CryptoTransfer"),
    CRYPTO_UPDATE(2, "CryptoUpdate"),
    CRYPTO_DELETE(3, "CryptoDelete"),
    CRYPTO_ADD_LIVE_HASH(4, "CryptoAddLiveHash"),
    CRYPTO_DELETE_LIVE_HASH(5, "CryptoDeleteLiveHash"),
    CONTRACT_CALL(6, "ContractCall"),
    CONTRACT_CREATE(7, "ContractCreate"),
    CONTRACT_UPDATE(8, "ContractUpdate"),
    FILE_CREATE(9, "FileCreate"),
    FILE_APPEND(10, "FileAppend"),
    FILE_UPDATE(11, "FileUpdate"),
    FILE_DELETE(12, "FileDelete"),
    CRYPTO_GET_ACCOUNT_BALANCE(13, "CryptoGetAccountBalance"),
    CRYPTO_GET_ACCOUNT_RECORDS(14, "CryptoGetAccountRecords"),
    CRYPTO_GET_INFO(15, "CryptoGetInfo"),
    CONTRACT_CALL_LOCAL(16, "ContractCallLocal"),
    CONTRACT_GET_INFO(17, "ContractGetInfo"),
    CONTRACT_GET_BYTECODE(18, "ContractGetBytecode"),
    GET_BY_SOLIDITY_ID(19, "GetBySolidityID"),
    GET_BY_KEY(20, "GetByKey"),
    CRYPTO_GET_LIVE_HASH(21, "CryptoGetLiveHash"),
    CRYPTO_GET_STAKERS(22, "CryptoGetStakers"),
    FILE_GET_CONTENTS(23, "FileGetContents"),
    FILE_GET_INFO(24, "FileGetInfo"),
    TRANSACTION_GET_RECORD(25, "TransactionGetRecord"),
    CONTRACT_GET_RECORDS(26, "ContractGetRecords"),
    CRYPTO_CREATE(27, "CryptoCreate"),
    SYSTEM_DELETE(28, "SystemDelete"),
    SYSTEM_UNDELETE(29, "SystemUndelete"),
    CONTRACT_DELETE(30, "ContractDelete"),
    FREEZE(31, "Freeze"),
    CREATE_TRANSACTION_RECORD(32, "CreateTransactionRecord"),
    CRYPTO_ACCOUNT_AUTO_RENEW(33, "CryptoAccountAutoRenew"),
    CONTRACT_AUTO_RENEW(34, "ContractAutoRenew"),
    GET_VERSION_INFO(35, "GetVersionInfo"),
    TRANSACTION_GET_RECEIPT(36, "TransactionGetReceipt"),
    CONSENSUS_CREATE_TOPIC(50, "ConsensusCreateTopic"),
    CONSENSUS_UPDATE_TOPIC(51, "ConsensusUpdateTopic"),
    CONSENSUS_DELETE_TOPIC(52, "ConsensusDeleteTopic"),
    CONSENSUS_GET_TOPIC_INFO(53, "ConsensusGetTopicInfo"),
    CONSENSUS_SUBMIT_MESSAGE(54, "ConsensusSubmitMessage"),
    UNCHECKED_SUBMIT(55, "UncheckedSubmit"),
    TOKEN_CREATE(56, "TokenCreate"),
    TOKEN_GET_INFO(58, "TokenGetInfo"),
    TOKEN_FREEZE_ACCOUNT(59, "TokenFreezeAccount"),
    TOKEN_UNFREEZE_ACCOUNT(60, "TokenUnfreezeAccount"),
    TOKEN_GRANT_KYC_TO_ACCOUNT(61, "TokenGrantKycToAccount"),
    TOKEN_REVOKE_KYC_FROM_ACCOUNT(62, "TokenRevokeKycFromAccount"),
    TOKEN_DELETE(63, "TokenDelete"),
    TOKEN_UPDATE(64, "TokenUpdate"),
    TOKEN_MINT(65, "TokenMint"),
    TOKEN_BURN(66, "TokenBurn"),
    TOKEN_ACCOUNT_WIPE(67, "TokenAccountWipe"),
    TOKEN_ASSOCIATE_TO_ACCOUNT(68, "TokenAssociateToAccount"),
    TOKEN_DISSOCIATE_FROM_ACCOUNT(69, "TokenDissociateFromAccount"),
    SCHEDULE_CREATE(70, "ScheduleCreate"),
    SCHEDULE_DELETE(71, "ScheduleDelete"),
    SCHEDULE_SIGN(72, "ScheduleSign"),
    SCHEDULE_GET_INFO(73, "ScheduleGetInfo"),
    TOKEN_GET_ACCOUNT_NFT_INFOS(74, "TokenGetAccountNftInfos"),
    TOKEN_GET_NFT_INFO(75, "TokenGetNftInfo"),
    TOKEN_GET_NFT_INFOS(76, "TokenGetNftInfos"),
    TOKEN_FEE_SCHEDULE_UPDATE(77, "TokenFeeScheduleUpdate"),
    NETWORK_GET_EXECUTION_TIME(78, "NetworkGetExecutionTime"),
    TOKEN_PAUSE(79, "TokenPause"),
    TOKEN_UNPAUSE(80, "TokenUnpause"),
    CRYPTO_APPROVE_ALLOWANCE(81, "CryptoApproveAllowance"),
    CRYPTO_DELETE_ALLOWANCE(82, "CryptoDeleteAllowance"),
    GET_ACCOUNT_DETAILS(83, "GetAccountDetails"),
    ETHEREUM_TRANSACTION(84, "EthereumTransaction"),
    NODE_STAKE_UPDATE(85, "NodeStakeUpdate"),
    UTIL_PRNG(86, "UtilPrng"),
    TRANSACTION_GET_FAST_RECORD(87, "TransactionGetFastRecord");

    private final int protoOrdinal;
    private final String protoName;

    private HederaFunctionality(int protoOrdinal, String protoName) {
        this.protoOrdinal = protoOrdinal;
        this.protoName = protoName;
    }

    public int protoOrdinal() {
        return this.protoOrdinal;
    }

    public String protoName() {
        return this.protoName;
    }

    public static HederaFunctionality fromProtobufOrdinal(int ordinal) {
        return switch (ordinal) {
            case 0 -> NONE;
            case 1 -> CRYPTO_TRANSFER;
            case 2 -> CRYPTO_UPDATE;
            case 3 -> CRYPTO_DELETE;
            case 4 -> CRYPTO_ADD_LIVE_HASH;
            case 5 -> CRYPTO_DELETE_LIVE_HASH;
            case 6 -> CONTRACT_CALL;
            case 7 -> CONTRACT_CREATE;
            case 8 -> CONTRACT_UPDATE;
            case 9 -> FILE_CREATE;
            case 10 -> FILE_APPEND;
            case 11 -> FILE_UPDATE;
            case 12 -> FILE_DELETE;
            case 13 -> CRYPTO_GET_ACCOUNT_BALANCE;
            case 14 -> CRYPTO_GET_ACCOUNT_RECORDS;
            case 15 -> CRYPTO_GET_INFO;
            case 16 -> CONTRACT_CALL_LOCAL;
            case 17 -> CONTRACT_GET_INFO;
            case 18 -> CONTRACT_GET_BYTECODE;
            case 19 -> GET_BY_SOLIDITY_ID;
            case 20 -> GET_BY_KEY;
            case 21 -> CRYPTO_GET_LIVE_HASH;
            case 22 -> CRYPTO_GET_STAKERS;
            case 23 -> FILE_GET_CONTENTS;
            case 24 -> FILE_GET_INFO;
            case 25 -> TRANSACTION_GET_RECORD;
            case 26 -> CONTRACT_GET_RECORDS;
            case 27 -> CRYPTO_CREATE;
            case 28 -> SYSTEM_DELETE;
            case 29 -> SYSTEM_UNDELETE;
            case 30 -> CONTRACT_DELETE;
            case 31 -> FREEZE;
            case 32 -> CREATE_TRANSACTION_RECORD;
            case 33 -> CRYPTO_ACCOUNT_AUTO_RENEW;
            case 34 -> CONTRACT_AUTO_RENEW;
            case 35 -> GET_VERSION_INFO;
            case 36 -> TRANSACTION_GET_RECEIPT;
            case 50 -> CONSENSUS_CREATE_TOPIC;
            case 51 -> CONSENSUS_UPDATE_TOPIC;
            case 52 -> CONSENSUS_DELETE_TOPIC;
            case 53 -> CONSENSUS_GET_TOPIC_INFO;
            case 54 -> CONSENSUS_SUBMIT_MESSAGE;
            case 55 -> UNCHECKED_SUBMIT;
            case 56 -> TOKEN_CREATE;
            case 58 -> TOKEN_GET_INFO;
            case 59 -> TOKEN_FREEZE_ACCOUNT;
            case 60 -> TOKEN_UNFREEZE_ACCOUNT;
            case 61 -> TOKEN_GRANT_KYC_TO_ACCOUNT;
            case 62 -> TOKEN_REVOKE_KYC_FROM_ACCOUNT;
            case 63 -> TOKEN_DELETE;
            case 64 -> TOKEN_UPDATE;
            case 65 -> TOKEN_MINT;
            case 66 -> TOKEN_BURN;
            case 67 -> TOKEN_ACCOUNT_WIPE;
            case 68 -> TOKEN_ASSOCIATE_TO_ACCOUNT;
            case 69 -> TOKEN_DISSOCIATE_FROM_ACCOUNT;
            case 70 -> SCHEDULE_CREATE;
            case 71 -> SCHEDULE_DELETE;
            case 72 -> SCHEDULE_SIGN;
            case 73 -> SCHEDULE_GET_INFO;
            case 74 -> TOKEN_GET_ACCOUNT_NFT_INFOS;
            case 75 -> TOKEN_GET_NFT_INFO;
            case 76 -> TOKEN_GET_NFT_INFOS;
            case 77 -> TOKEN_FEE_SCHEDULE_UPDATE;
            case 78 -> NETWORK_GET_EXECUTION_TIME;
            case 79 -> TOKEN_PAUSE;
            case 80 -> TOKEN_UNPAUSE;
            case 81 -> CRYPTO_APPROVE_ALLOWANCE;
            case 82 -> CRYPTO_DELETE_ALLOWANCE;
            case 83 -> GET_ACCOUNT_DETAILS;
            case 84 -> ETHEREUM_TRANSACTION;
            case 85 -> NODE_STAKE_UPDATE;
            case 86 -> UTIL_PRNG;
            case 87 -> TRANSACTION_GET_FAST_RECORD;
            default -> throw new IllegalArgumentException("Unknown protobuf ordinal " + ordinal);
        };
    }

    public static HederaFunctionality fromString(String name) {
        return switch (name) {
            case "NONE" -> NONE;
            case "CryptoTransfer", "CRYPTO_TRANSFER" -> CRYPTO_TRANSFER;
            case "CryptoUpdate", "CRYPTO_UPDATE" -> CRYPTO_UPDATE;
            case "CryptoDelete", "CRYPTO_DELETE" -> CRYPTO_DELETE;
            case "CryptoAddLiveHash", "CRYPTO_ADD_LIVE_HASH" -> CRYPTO_ADD_LIVE_HASH;
            case "CryptoDeleteLiveHash", "CRYPTO_DELETE_LIVE_HASH" -> CRYPTO_DELETE_LIVE_HASH;
            case "ContractCall", "CONTRACT_CALL" -> CONTRACT_CALL;
            case "ContractCreate", "CONTRACT_CREATE" -> CONTRACT_CREATE;
            case "ContractUpdate", "CONTRACT_UPDATE" -> CONTRACT_UPDATE;
            case "FileCreate", "FILE_CREATE" -> FILE_CREATE;
            case "FileAppend", "FILE_APPEND" -> FILE_APPEND;
            case "FileUpdate", "FILE_UPDATE" -> FILE_UPDATE;
            case "FileDelete", "FILE_DELETE" -> FILE_DELETE;
            case "CryptoGetAccountBalance", "CRYPTO_GET_ACCOUNT_BALANCE" -> CRYPTO_GET_ACCOUNT_BALANCE;
            case "CryptoGetAccountRecords", "CRYPTO_GET_ACCOUNT_RECORDS" -> CRYPTO_GET_ACCOUNT_RECORDS;
            case "CryptoGetInfo", "CRYPTO_GET_INFO" -> CRYPTO_GET_INFO;
            case "ContractCallLocal", "CONTRACT_CALL_LOCAL" -> CONTRACT_CALL_LOCAL;
            case "ContractGetInfo", "CONTRACT_GET_INFO" -> CONTRACT_GET_INFO;
            case "ContractGetBytecode", "CONTRACT_GET_BYTECODE" -> CONTRACT_GET_BYTECODE;
            case "GetBySolidityID", "GET_BY_SOLIDITY_ID" -> GET_BY_SOLIDITY_ID;
            case "GetByKey", "GET_BY_KEY" -> GET_BY_KEY;
            case "CryptoGetLiveHash", "CRYPTO_GET_LIVE_HASH" -> CRYPTO_GET_LIVE_HASH;
            case "CryptoGetStakers", "CRYPTO_GET_STAKERS" -> CRYPTO_GET_STAKERS;
            case "FileGetContents", "FILE_GET_CONTENTS" -> FILE_GET_CONTENTS;
            case "FileGetInfo", "FILE_GET_INFO" -> FILE_GET_INFO;
            case "TransactionGetRecord", "TRANSACTION_GET_RECORD" -> TRANSACTION_GET_RECORD;
            case "ContractGetRecords", "CONTRACT_GET_RECORDS" -> CONTRACT_GET_RECORDS;
            case "CryptoCreate", "CRYPTO_CREATE" -> CRYPTO_CREATE;
            case "SystemDelete", "SYSTEM_DELETE" -> SYSTEM_DELETE;
            case "SystemUndelete", "SYSTEM_UNDELETE" -> SYSTEM_UNDELETE;
            case "ContractDelete", "CONTRACT_DELETE" -> CONTRACT_DELETE;
            case "Freeze", "FREEZE" -> FREEZE;
            case "CreateTransactionRecord", "CREATE_TRANSACTION_RECORD" -> CREATE_TRANSACTION_RECORD;
            case "CryptoAccountAutoRenew", "CRYPTO_ACCOUNT_AUTO_RENEW" -> CRYPTO_ACCOUNT_AUTO_RENEW;
            case "ContractAutoRenew", "CONTRACT_AUTO_RENEW" -> CONTRACT_AUTO_RENEW;
            case "GetVersionInfo", "GET_VERSION_INFO" -> GET_VERSION_INFO;
            case "TransactionGetReceipt", "TRANSACTION_GET_RECEIPT" -> TRANSACTION_GET_RECEIPT;
            case "ConsensusCreateTopic", "CONSENSUS_CREATE_TOPIC" -> CONSENSUS_CREATE_TOPIC;
            case "ConsensusUpdateTopic", "CONSENSUS_UPDATE_TOPIC" -> CONSENSUS_UPDATE_TOPIC;
            case "ConsensusDeleteTopic", "CONSENSUS_DELETE_TOPIC" -> CONSENSUS_DELETE_TOPIC;
            case "ConsensusGetTopicInfo", "CONSENSUS_GET_TOPIC_INFO" -> CONSENSUS_GET_TOPIC_INFO;
            case "ConsensusSubmitMessage", "CONSENSUS_SUBMIT_MESSAGE" -> CONSENSUS_SUBMIT_MESSAGE;
            case "UncheckedSubmit", "UNCHECKED_SUBMIT" -> UNCHECKED_SUBMIT;
            case "TokenCreate", "TOKEN_CREATE" -> TOKEN_CREATE;
            case "TokenGetInfo", "TOKEN_GET_INFO" -> TOKEN_GET_INFO;
            case "TokenFreezeAccount", "TOKEN_FREEZE_ACCOUNT" -> TOKEN_FREEZE_ACCOUNT;
            case "TokenUnfreezeAccount", "TOKEN_UNFREEZE_ACCOUNT" -> TOKEN_UNFREEZE_ACCOUNT;
            case "TokenGrantKycToAccount", "TOKEN_GRANT_KYC_TO_ACCOUNT" -> TOKEN_GRANT_KYC_TO_ACCOUNT;
            case "TokenRevokeKycFromAccount", "TOKEN_REVOKE_KYC_FROM_ACCOUNT" -> TOKEN_REVOKE_KYC_FROM_ACCOUNT;
            case "TokenDelete", "TOKEN_DELETE" -> TOKEN_DELETE;
            case "TokenUpdate", "TOKEN_UPDATE" -> TOKEN_UPDATE;
            case "TokenMint", "TOKEN_MINT" -> TOKEN_MINT;
            case "TokenBurn", "TOKEN_BURN" -> TOKEN_BURN;
            case "TokenAccountWipe", "TOKEN_ACCOUNT_WIPE" -> TOKEN_ACCOUNT_WIPE;
            case "TokenAssociateToAccount", "TOKEN_ASSOCIATE_TO_ACCOUNT" -> TOKEN_ASSOCIATE_TO_ACCOUNT;
            case "TokenDissociateFromAccount", "TOKEN_DISSOCIATE_FROM_ACCOUNT" -> TOKEN_DISSOCIATE_FROM_ACCOUNT;
            case "ScheduleCreate", "SCHEDULE_CREATE" -> SCHEDULE_CREATE;
            case "ScheduleDelete", "SCHEDULE_DELETE" -> SCHEDULE_DELETE;
            case "ScheduleSign", "SCHEDULE_SIGN" -> SCHEDULE_SIGN;
            case "ScheduleGetInfo", "SCHEDULE_GET_INFO" -> SCHEDULE_GET_INFO;
            case "TokenGetAccountNftInfos", "TOKEN_GET_ACCOUNT_NFT_INFOS" -> TOKEN_GET_ACCOUNT_NFT_INFOS;
            case "TokenGetNftInfo", "TOKEN_GET_NFT_INFO" -> TOKEN_GET_NFT_INFO;
            case "TokenGetNftInfos", "TOKEN_GET_NFT_INFOS" -> TOKEN_GET_NFT_INFOS;
            case "TokenFeeScheduleUpdate", "TOKEN_FEE_SCHEDULE_UPDATE" -> TOKEN_FEE_SCHEDULE_UPDATE;
            case "NetworkGetExecutionTime", "NETWORK_GET_EXECUTION_TIME" -> NETWORK_GET_EXECUTION_TIME;
            case "TokenPause", "TOKEN_PAUSE" -> TOKEN_PAUSE;
            case "TokenUnpause", "TOKEN_UNPAUSE" -> TOKEN_UNPAUSE;
            case "CryptoApproveAllowance", "CRYPTO_APPROVE_ALLOWANCE" -> CRYPTO_APPROVE_ALLOWANCE;
            case "CryptoDeleteAllowance", "CRYPTO_DELETE_ALLOWANCE" -> CRYPTO_DELETE_ALLOWANCE;
            case "GetAccountDetails", "GET_ACCOUNT_DETAILS" -> GET_ACCOUNT_DETAILS;
            case "EthereumTransaction", "ETHEREUM_TRANSACTION" -> ETHEREUM_TRANSACTION;
            case "NodeStakeUpdate", "NODE_STAKE_UPDATE" -> NODE_STAKE_UPDATE;
            case "UtilPrng", "UTIL_PRNG" -> UTIL_PRNG;
            case "TransactionGetFastRecord", "TRANSACTION_GET_FAST_RECORD" -> TRANSACTION_GET_FAST_RECORD;
            default -> throw new IllegalArgumentException("Unknown token kyc status " + name);
        };
    }
}

