/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.base;

import com.hedera.hapi.node.base.TokenID;
import com.hedera.hapi.node.base.codec.NftIDJsonCodec;
import com.hedera.hapi.node.base.codec.NftIDProtoCodec;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.JsonCodec;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Objects;
import java.util.function.Consumer;

public record NftID(@Nullable TokenID tokenId, long serialNumber) {
    public static final Codec<NftID> PROTOBUF = new NftIDProtoCodec();
    public static final JsonCodec<NftID> JSON = new NftIDJsonCodec();
    public static final NftID DEFAULT = NftID.newBuilder().build();

    @Override
    public int hashCode() {
        int result = 1;
        if (this.tokenId != null && !this.tokenId.equals(NftID.DEFAULT.tokenId)) {
            result = 31 * result + this.tokenId.hashCode();
        }
        if (this.serialNumber != NftID.DEFAULT.serialNumber) {
            result = 31 * result + Long.hashCode(this.serialNumber);
        }
        long hashCode = result;
        hashCode += hashCode << 30;
        hashCode ^= hashCode >>> 27;
        hashCode += hashCode << 16;
        hashCode ^= hashCode >>> 20;
        hashCode += hashCode << 5;
        hashCode ^= hashCode >>> 18;
        hashCode += hashCode << 10;
        hashCode ^= hashCode >>> 24;
        hashCode += hashCode << 30;
        return (int)hashCode;
    }

    @Override
    public boolean equals(Object that) {
        if (that == null || this.getClass() != that.getClass()) {
            return false;
        }
        NftID thatObj = (NftID)that;
        if (this.tokenId == null && thatObj.tokenId != null) {
            return false;
        }
        if (this.tokenId != null && !this.tokenId.equals(thatObj.tokenId)) {
            return false;
        }
        return this.serialNumber == thatObj.serialNumber;
    }

    public boolean hasTokenId() {
        return this.tokenId != null;
    }

    public TokenID tokenIdOrElse(@NonNull TokenID defaultValue) {
        return this.hasTokenId() ? this.tokenId : defaultValue;
    }

    @NonNull
    public TokenID tokenIdOrThrow() {
        return Objects.requireNonNull(this.tokenId, "Field tokenId is null");
    }

    public void ifTokenId(@NonNull Consumer<TokenID> ifPresent) {
        if (this.hasTokenId()) {
            ifPresent.accept(this.tokenId);
        }
    }

    public Builder copyBuilder() {
        return new Builder(this.tokenId, this.serialNumber);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        private TokenID tokenId = null;
        private long serialNumber = 0L;

        public Builder() {
        }

        public Builder(TokenID tokenId, long serialNumber) {
            this.tokenId = tokenId;
            this.serialNumber = serialNumber;
        }

        public NftID build() {
            return new NftID(this.tokenId, this.serialNumber);
        }

        public Builder tokenId(TokenID tokenId) {
            this.tokenId = tokenId;
            return this;
        }

        public Builder tokenId(TokenID.Builder builder) {
            this.tokenId = builder.build();
            return this;
        }

        public Builder serialNumber(long serialNumber) {
            this.serialNumber = serialNumber;
            return this;
        }
    }
}

