/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.base;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.TokenID;
import com.hedera.hapi.node.base.codec.TokenAssociationJsonCodec;
import com.hedera.hapi.node.base.codec.TokenAssociationProtoCodec;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.JsonCodec;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Objects;
import java.util.function.Consumer;

public record TokenAssociation(@Nullable TokenID tokenId, @Nullable AccountID accountId) {
    public static final Codec<TokenAssociation> PROTOBUF = new TokenAssociationProtoCodec();
    public static final JsonCodec<TokenAssociation> JSON = new TokenAssociationJsonCodec();
    public static final TokenAssociation DEFAULT = TokenAssociation.newBuilder().build();

    @Override
    public int hashCode() {
        int result = 1;
        if (this.tokenId != null && !this.tokenId.equals(TokenAssociation.DEFAULT.tokenId)) {
            result = 31 * result + this.tokenId.hashCode();
        }
        if (this.accountId != null && !this.accountId.equals(TokenAssociation.DEFAULT.accountId)) {
            result = 31 * result + this.accountId.hashCode();
        }
        long hashCode = result;
        hashCode += hashCode << 30;
        hashCode ^= hashCode >>> 27;
        hashCode += hashCode << 16;
        hashCode ^= hashCode >>> 20;
        hashCode += hashCode << 5;
        hashCode ^= hashCode >>> 18;
        hashCode += hashCode << 10;
        hashCode ^= hashCode >>> 24;
        hashCode += hashCode << 30;
        return (int)hashCode;
    }

    @Override
    public boolean equals(Object that) {
        if (that == null || this.getClass() != that.getClass()) {
            return false;
        }
        TokenAssociation thatObj = (TokenAssociation)that;
        if (this.tokenId == null && thatObj.tokenId != null) {
            return false;
        }
        if (this.tokenId != null && !this.tokenId.equals(thatObj.tokenId)) {
            return false;
        }
        if (this.accountId == null && thatObj.accountId != null) {
            return false;
        }
        return this.accountId == null || this.accountId.equals(thatObj.accountId);
    }

    public boolean hasTokenId() {
        return this.tokenId != null;
    }

    public TokenID tokenIdOrElse(@NonNull TokenID defaultValue) {
        return this.hasTokenId() ? this.tokenId : defaultValue;
    }

    @NonNull
    public TokenID tokenIdOrThrow() {
        return Objects.requireNonNull(this.tokenId, "Field tokenId is null");
    }

    public void ifTokenId(@NonNull Consumer<TokenID> ifPresent) {
        if (this.hasTokenId()) {
            ifPresent.accept(this.tokenId);
        }
    }

    public boolean hasAccountId() {
        return this.accountId != null;
    }

    public AccountID accountIdOrElse(@NonNull AccountID defaultValue) {
        return this.hasAccountId() ? this.accountId : defaultValue;
    }

    @NonNull
    public AccountID accountIdOrThrow() {
        return Objects.requireNonNull(this.accountId, "Field accountId is null");
    }

    public void ifAccountId(@NonNull Consumer<AccountID> ifPresent) {
        if (this.hasAccountId()) {
            ifPresent.accept(this.accountId);
        }
    }

    public Builder copyBuilder() {
        return new Builder(this.tokenId, this.accountId);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        private TokenID tokenId = null;
        private AccountID accountId = null;

        public Builder() {
        }

        public Builder(TokenID tokenId, AccountID accountId) {
            this.tokenId = tokenId;
            this.accountId = accountId;
        }

        public TokenAssociation build() {
            return new TokenAssociation(this.tokenId, this.accountId);
        }

        public Builder tokenId(TokenID tokenId) {
            this.tokenId = tokenId;
            return this;
        }

        public Builder tokenId(TokenID.Builder builder) {
            this.tokenId = builder.build();
            return this;
        }

        public Builder accountId(AccountID accountId) {
            this.accountId = accountId;
            return this;
        }

        public Builder accountId(AccountID.Builder builder) {
            this.accountId = builder.build();
            return this;
        }
    }
}

