/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.base.codec;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.NodeAddress;
import com.hedera.hapi.node.base.ServiceEndpoint;
import com.hedera.hapi.node.base.schema.NodeAddressSchema;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.FieldDefinition;
import com.hedera.pbj.runtime.ProtoConstants;
import com.hedera.pbj.runtime.ProtoParserTools;
import com.hedera.pbj.runtime.ProtoWriterTools;
import com.hedera.pbj.runtime.UnknownFieldException;
import com.hedera.pbj.runtime.io.ReadableSequentialData;
import com.hedera.pbj.runtime.io.WritableSequentialData;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.hedera.pbj.runtime.io.buffer.RandomAccessData;
import com.hedera.pbj.runtime.io.stream.EOFException;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.util.Collections;

public final class NodeAddressProtoCodec
implements Codec<NodeAddress> {
    @NonNull
    public NodeAddress parse(@NonNull ReadableSequentialData input) throws IOException {
        return this.parseInternal(input, false);
    }

    @NonNull
    public NodeAddress parseStrict(@NonNull ReadableSequentialData input) throws IOException {
        return this.parseInternal(input, true);
    }

    public void write(@NonNull NodeAddress data, @NonNull WritableSequentialData out) throws IOException {
        ProtoWriterTools.writeBytes((WritableSequentialData)out, (FieldDefinition)NodeAddressSchema.IP_ADDRESS, (RandomAccessData)data.ipAddress());
        ProtoWriterTools.writeInteger((WritableSequentialData)out, (FieldDefinition)NodeAddressSchema.PORTNO, (int)data.portno());
        ProtoWriterTools.writeBytes((WritableSequentialData)out, (FieldDefinition)NodeAddressSchema.MEMO, (RandomAccessData)data.memo());
        ProtoWriterTools.writeString((WritableSequentialData)out, (FieldDefinition)NodeAddressSchema.RSA_PUBKEY, (String)data.rsaPubKey());
        ProtoWriterTools.writeLong((WritableSequentialData)out, (FieldDefinition)NodeAddressSchema.NODE_ID, (long)data.nodeId());
        ProtoWriterTools.writeMessage((WritableSequentialData)out, (FieldDefinition)NodeAddressSchema.NODE_ACCOUNT_ID, (Object)data.nodeAccountId(), (arg_0, arg_1) -> AccountID.PROTOBUF.write(arg_0, arg_1), arg_0 -> AccountID.PROTOBUF.measureRecord(arg_0));
        ProtoWriterTools.writeBytes((WritableSequentialData)out, (FieldDefinition)NodeAddressSchema.NODE_CERT_HASH, (RandomAccessData)data.nodeCertHash());
        ProtoWriterTools.writeMessageList((WritableSequentialData)out, (FieldDefinition)NodeAddressSchema.SERVICE_ENDPOINT, data.serviceEndpoint(), (arg_0, arg_1) -> ServiceEndpoint.PROTOBUF.write(arg_0, arg_1), arg_0 -> ServiceEndpoint.PROTOBUF.measureRecord(arg_0));
        ProtoWriterTools.writeString((WritableSequentialData)out, (FieldDefinition)NodeAddressSchema.DESCRIPTION, (String)data.description());
        ProtoWriterTools.writeLong((WritableSequentialData)out, (FieldDefinition)NodeAddressSchema.STAKE, (long)data.stake());
    }

    public int measure(@NonNull ReadableSequentialData input) throws IOException {
        long start = input.position();
        this.parse(input);
        long end = input.position();
        return (int)(end - start);
    }

    public int measureRecord(NodeAddress data) {
        int size = 0;
        size += ProtoWriterTools.sizeOfBytes((FieldDefinition)NodeAddressSchema.IP_ADDRESS, (RandomAccessData)data.ipAddress());
        size += ProtoWriterTools.sizeOfInteger((FieldDefinition)NodeAddressSchema.PORTNO, (int)data.portno());
        size += ProtoWriterTools.sizeOfBytes((FieldDefinition)NodeAddressSchema.MEMO, (RandomAccessData)data.memo());
        size += ProtoWriterTools.sizeOfString((FieldDefinition)NodeAddressSchema.RSA_PUBKEY, (String)data.rsaPubKey());
        size += ProtoWriterTools.sizeOfLong((FieldDefinition)NodeAddressSchema.NODE_ID, (long)data.nodeId());
        size += ProtoWriterTools.sizeOfMessage((FieldDefinition)NodeAddressSchema.NODE_ACCOUNT_ID, (Object)data.nodeAccountId(), arg_0 -> AccountID.PROTOBUF.measureRecord(arg_0));
        size += ProtoWriterTools.sizeOfBytes((FieldDefinition)NodeAddressSchema.NODE_CERT_HASH, (RandomAccessData)data.nodeCertHash());
        size += ProtoWriterTools.sizeOfMessageList((FieldDefinition)NodeAddressSchema.SERVICE_ENDPOINT, data.serviceEndpoint(), arg_0 -> ServiceEndpoint.PROTOBUF.measureRecord(arg_0));
        size += ProtoWriterTools.sizeOfString((FieldDefinition)NodeAddressSchema.DESCRIPTION, (String)data.description());
        return size += ProtoWriterTools.sizeOfLong((FieldDefinition)NodeAddressSchema.STAKE, (long)data.stake());
    }

    public boolean fastEquals(@NonNull NodeAddress item, @NonNull ReadableSequentialData input) throws IOException {
        return item.equals(this.parse(input));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NonNull
    private NodeAddress parseInternal(@NonNull ReadableSequentialData input, boolean strictMode) throws IOException {
        temp_ipAddress = Bytes.EMPTY;
        temp_portno = 0;
        temp_memo = Bytes.EMPTY;
        temp_RSA_PubKey = "";
        temp_nodeId = 0L;
        temp_nodeAccountId /* !! */  = null;
        temp_nodeCertHash = Bytes.EMPTY;
        temp_serviceEndpoint = Collections.emptyList();
        temp_description = "";
        temp_stake = 0L;
        try {
            block20: while (input.hasRemaining() != false) {
                tag = input.readVarInt(false);
                field = tag >>> 3;
                f = NodeAddressSchema.getField(field);
                switch (tag) {
                    case 10: {
                        temp_ipAddress = value = ProtoParserTools.readBytes((ReadableSequentialData)input);
                        continue block20;
                    }
                    case 16: {
                        temp_portno = value = ProtoParserTools.readInt32((ReadableSequentialData)input);
                        continue block20;
                    }
                    case 26: {
                        temp_memo = value = ProtoParserTools.readBytes((ReadableSequentialData)input);
                        continue block20;
                    }
                    case 34: {
                        temp_RSA_PubKey = value = ProtoParserTools.readString((ReadableSequentialData)input);
                        continue block20;
                    }
                    case 40: {
                        temp_nodeId = value = ProtoParserTools.readInt64((ReadableSequentialData)input);
                        continue block20;
                    }
                    case 50: {
                        messageLength = input.readVarInt(false);
                        if (messageLength != 0) ** GOTO lbl37
                        value /* !! */  = AccountID.DEFAULT;
                        ** GOTO lbl50
lbl37:
                        // 1 sources

                        limitBefore = input.limit();
                        startPos = input.position();
                        try {
                            if (startPos + (long)messageLength > limitBefore) {
                                throw new BufferUnderflowException();
                            }
                            input.limit(startPos + (long)messageLength);
                            v0 = value /* !! */  = strictMode != false ? (AccountID)AccountID.PROTOBUF.parseStrict(input) : (AccountID)AccountID.PROTOBUF.parse(input);
                            if (startPos + (long)messageLength != input.position()) {
                                throw new BufferOverflowException();
                            }
                        }
                        finally {
                            input.limit(limitBefore);
                        }
lbl50:
                        // 2 sources

                        temp_nodeAccountId /* !! */  = value /* !! */ ;
                        continue block20;
                    }
                    case 58: {
                        temp_nodeCertHash = value = ProtoParserTools.readBytes((ReadableSequentialData)input);
                        continue block20;
                    }
                    case 66: {
                        messageLength = input.readVarInt(false);
                        if (messageLength != 0) ** GOTO lbl60
                        value /* !! */  = ServiceEndpoint.DEFAULT;
                        ** GOTO lbl73
lbl60:
                        // 1 sources

                        limitBefore = input.limit();
                        startPos = input.position();
                        try {
                            if (startPos + (long)messageLength > limitBefore) {
                                throw new BufferUnderflowException();
                            }
                            input.limit(startPos + (long)messageLength);
                            v1 /* !! */  = value /* !! */  = strictMode != false ? (ServiceEndpoint)ServiceEndpoint.PROTOBUF.parseStrict(input) : (ServiceEndpoint)ServiceEndpoint.PROTOBUF.parse(input);
                            if (startPos + (long)messageLength != input.position()) {
                                throw new BufferOverflowException();
                            }
                        }
                        finally {
                            input.limit(limitBefore);
                        }
lbl73:
                        // 2 sources

                        temp_serviceEndpoint = ProtoParserTools.addToList(temp_serviceEndpoint, (Object)value /* !! */ );
                        continue block20;
                    }
                    case 74: {
                        temp_description = value = ProtoParserTools.readString((ReadableSequentialData)input);
                        continue block20;
                    }
                    case 80: {
                        temp_stake = value = ProtoParserTools.readInt64((ReadableSequentialData)input);
                        continue block20;
                    }
                }
                wireType = tag & 7;
                if (field == 0) {
                    throw new IOException("Bad protobuf encoding. We read a field value of " + field);
                }
                if (wireType > 5) {
                    throw new IOException("Cannot understand wire_type of " + wireType);
                }
                if (f != null) throw new IOException("Bad tag [" + tag + "], field [" + field + "] wireType [" + wireType + "]");
                if (strictMode) {
                    throw new UnknownFieldException(field);
                }
                ProtoParserTools.skipField((ReadableSequentialData)input, (ProtoConstants)ProtoConstants.get((int)wireType));
            }
            return new NodeAddress(temp_ipAddress, temp_portno, temp_memo, temp_RSA_PubKey, temp_nodeId, temp_nodeAccountId /* !! */ , temp_nodeCertHash, temp_serviceEndpoint, temp_description, temp_stake);
        }
        catch (EOFException var15_14) {
            // empty catch block
        }
        return new NodeAddress(temp_ipAddress, temp_portno, temp_memo, temp_RSA_PubKey, temp_nodeId, temp_nodeAccountId /* !! */ , temp_nodeCertHash, temp_serviceEndpoint, temp_description, temp_stake);
    }
}

