/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.base.codec;

import com.hedera.hapi.node.base.SignaturePair;
import com.hedera.pbj.runtime.JsonCodec;
import com.hedera.pbj.runtime.JsonTools;
import com.hedera.pbj.runtime.OneOf;
import com.hedera.pbj.runtime.UnknownFieldException;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.hedera.pbj.runtime.jsonparser.JSONParser;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.io.IOException;
import java.util.ArrayList;

public final class SignaturePairJsonCodec
implements JsonCodec<SignaturePair> {
    public static final OneOf<SignaturePair.SignatureOneOfType> SIGNATURE_UNSET = new OneOf((Object)SignaturePair.SignatureOneOfType.UNSET, null);

    @NonNull
    public SignaturePair parse(@Nullable JSONParser.ObjContext root, boolean strictMode) throws IOException {
        Bytes temp_pubKeyPrefix = Bytes.EMPTY;
        OneOf temp_signature = SIGNATURE_UNSET;
        block16: for (JSONParser.PairContext kvPair : root.pair()) {
            switch (kvPair.STRING().getText()) {
                case "pubKeyPrefix": {
                    temp_pubKeyPrefix = Bytes.fromBase64((String)kvPair.value().STRING().getText());
                    continue block16;
                }
                case "contract": {
                    temp_signature = new OneOf((Object)SignaturePair.SignatureOneOfType.CONTRACT, (Object)Bytes.fromBase64((String)kvPair.value().STRING().getText()));
                    continue block16;
                }
                case "ed25519": {
                    temp_signature = new OneOf((Object)SignaturePair.SignatureOneOfType.ED25519, (Object)Bytes.fromBase64((String)kvPair.value().STRING().getText()));
                    continue block16;
                }
                case "RSA3072": {
                    temp_signature = new OneOf((Object)SignaturePair.SignatureOneOfType.RSA_3072, (Object)Bytes.fromBase64((String)kvPair.value().STRING().getText()));
                    continue block16;
                }
                case "ECDSA384": {
                    temp_signature = new OneOf((Object)SignaturePair.SignatureOneOfType.ECDSA_384, (Object)Bytes.fromBase64((String)kvPair.value().STRING().getText()));
                    continue block16;
                }
                case "ECDSASecp256k1": {
                    temp_signature = new OneOf((Object)SignaturePair.SignatureOneOfType.ECDSA_SECP256K1, (Object)Bytes.fromBase64((String)kvPair.value().STRING().getText()));
                    continue block16;
                }
            }
            if (!strictMode) continue;
            throw new UnknownFieldException(kvPair.STRING().getText());
        }
        return new SignaturePair(temp_pubKeyPrefix, temp_signature);
    }

    public String toJSON(@NonNull SignaturePair data, String indent, boolean inline) {
        StringBuilder sb = new StringBuilder();
        sb.append((String)(inline ? "{\n" : indent + "{\n"));
        String childIndent = indent + "  ";
        ArrayList<String> fieldLines = new ArrayList<String>();
        if (data.pubKeyPrefix() != Bytes.EMPTY && data.pubKeyPrefix() != null && data.pubKeyPrefix().length() > 0L) {
            fieldLines.add(JsonTools.field((String)"pubKeyPrefix", (Bytes)data.pubKeyPrefix()));
        }
        if (data.signature().kind() == SignaturePair.SignatureOneOfType.CONTRACT) {
            fieldLines.add(JsonTools.field((String)"contract", (Bytes)data.contract()));
        }
        if (data.signature().kind() == SignaturePair.SignatureOneOfType.ED25519) {
            fieldLines.add(JsonTools.field((String)"ed25519", (Bytes)data.ed25519()));
        }
        if (data.signature().kind() == SignaturePair.SignatureOneOfType.RSA_3072) {
            fieldLines.add(JsonTools.field((String)"RSA3072", (Bytes)data.rsa3072()));
        }
        if (data.signature().kind() == SignaturePair.SignatureOneOfType.ECDSA_384) {
            fieldLines.add(JsonTools.field((String)"ECDSA384", (Bytes)data.ecdsa384()));
        }
        if (data.signature().kind() == SignaturePair.SignatureOneOfType.ECDSA_SECP256K1) {
            fieldLines.add(JsonTools.field((String)"ECDSASecp256k1", (Bytes)data.ecdsaSecp256k1()));
        }
        if (!fieldLines.isEmpty()) {
            sb.append(childIndent);
            sb.append(String.join((CharSequence)(",\n" + childIndent), fieldLines));
            sb.append("\n");
        }
        sb.append(indent + "}");
        return sb.toString();
    }
}

