/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.base.codec;

import com.hedera.hapi.node.base.Signature;
import com.hedera.hapi.node.base.SignatureList;
import com.hedera.hapi.node.base.ThresholdSignature;
import com.hedera.hapi.node.base.schema.SignatureSchema;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.FieldDefinition;
import com.hedera.pbj.runtime.OneOf;
import com.hedera.pbj.runtime.ProtoConstants;
import com.hedera.pbj.runtime.ProtoParserTools;
import com.hedera.pbj.runtime.ProtoWriterTools;
import com.hedera.pbj.runtime.UnknownFieldException;
import com.hedera.pbj.runtime.io.ReadableSequentialData;
import com.hedera.pbj.runtime.io.WritableSequentialData;
import com.hedera.pbj.runtime.io.buffer.RandomAccessData;
import com.hedera.pbj.runtime.io.stream.EOFException;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;

public final class SignatureProtoCodec
implements Codec<Signature> {
    public static final OneOf<Signature.SignatureOneOfType> SIGNATURE_UNSET = new OneOf((Object)Signature.SignatureOneOfType.UNSET, null);

    @NonNull
    public Signature parse(@NonNull ReadableSequentialData input) throws IOException {
        return this.parseInternal(input, false);
    }

    @NonNull
    public Signature parseStrict(@NonNull ReadableSequentialData input) throws IOException {
        return this.parseInternal(input, true);
    }

    public void write(@NonNull Signature data, @NonNull WritableSequentialData out) throws IOException {
        if (data.signature().kind() == Signature.SignatureOneOfType.CONTRACT) {
            ProtoWriterTools.writeBytes((WritableSequentialData)out, (FieldDefinition)SignatureSchema.CONTRACT, (RandomAccessData)((RandomAccessData)data.signature().as()));
        }
        if (data.signature().kind() == Signature.SignatureOneOfType.ED25519) {
            ProtoWriterTools.writeBytes((WritableSequentialData)out, (FieldDefinition)SignatureSchema.ED25519, (RandomAccessData)((RandomAccessData)data.signature().as()));
        }
        if (data.signature().kind() == Signature.SignatureOneOfType.RSA_3072) {
            ProtoWriterTools.writeBytes((WritableSequentialData)out, (FieldDefinition)SignatureSchema.RSA_3072, (RandomAccessData)((RandomAccessData)data.signature().as()));
        }
        if (data.signature().kind() == Signature.SignatureOneOfType.ECDSA_384) {
            ProtoWriterTools.writeBytes((WritableSequentialData)out, (FieldDefinition)SignatureSchema.ECDSA_384, (RandomAccessData)((RandomAccessData)data.signature().as()));
        }
        if (data.signature().kind() == Signature.SignatureOneOfType.THRESHOLD_SIGNATURE) {
            ProtoWriterTools.writeMessage((WritableSequentialData)out, (FieldDefinition)SignatureSchema.THRESHOLD_SIGNATURE, (Object)((ThresholdSignature)data.signature().as()), (arg_0, arg_1) -> ThresholdSignature.PROTOBUF.write(arg_0, arg_1), arg_0 -> ThresholdSignature.PROTOBUF.measureRecord(arg_0));
        }
        if (data.signature().kind() == Signature.SignatureOneOfType.SIGNATURE_LIST) {
            ProtoWriterTools.writeMessage((WritableSequentialData)out, (FieldDefinition)SignatureSchema.SIGNATURE_LIST, (Object)((SignatureList)data.signature().as()), (arg_0, arg_1) -> SignatureList.PROTOBUF.write(arg_0, arg_1), arg_0 -> SignatureList.PROTOBUF.measureRecord(arg_0));
        }
    }

    public int measure(@NonNull ReadableSequentialData input) throws IOException {
        long start = input.position();
        this.parse(input);
        long end = input.position();
        return (int)(end - start);
    }

    public int measureRecord(Signature data) {
        int size = 0;
        if (data.signature().kind() == Signature.SignatureOneOfType.CONTRACT) {
            size += ProtoWriterTools.sizeOfBytes((FieldDefinition)SignatureSchema.CONTRACT, (RandomAccessData)((RandomAccessData)data.signature().as()));
        }
        if (data.signature().kind() == Signature.SignatureOneOfType.ED25519) {
            size += ProtoWriterTools.sizeOfBytes((FieldDefinition)SignatureSchema.ED25519, (RandomAccessData)((RandomAccessData)data.signature().as()));
        }
        if (data.signature().kind() == Signature.SignatureOneOfType.RSA_3072) {
            size += ProtoWriterTools.sizeOfBytes((FieldDefinition)SignatureSchema.RSA_3072, (RandomAccessData)((RandomAccessData)data.signature().as()));
        }
        if (data.signature().kind() == Signature.SignatureOneOfType.ECDSA_384) {
            size += ProtoWriterTools.sizeOfBytes((FieldDefinition)SignatureSchema.ECDSA_384, (RandomAccessData)((RandomAccessData)data.signature().as()));
        }
        if (data.signature().kind() == Signature.SignatureOneOfType.THRESHOLD_SIGNATURE) {
            size += ProtoWriterTools.sizeOfMessage((FieldDefinition)SignatureSchema.THRESHOLD_SIGNATURE, (Object)((ThresholdSignature)data.signature().as()), arg_0 -> ThresholdSignature.PROTOBUF.measureRecord(arg_0));
        }
        if (data.signature().kind() == Signature.SignatureOneOfType.SIGNATURE_LIST) {
            size += ProtoWriterTools.sizeOfMessage((FieldDefinition)SignatureSchema.SIGNATURE_LIST, (Object)((SignatureList)data.signature().as()), arg_0 -> SignatureList.PROTOBUF.measureRecord(arg_0));
        }
        return size;
    }

    public boolean fastEquals(@NonNull Signature item, @NonNull ReadableSequentialData input) throws IOException {
        return item.equals(this.parse(input));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NonNull
    private Signature parseInternal(@NonNull ReadableSequentialData input, boolean strictMode) throws IOException {
        temp_signature = SignatureProtoCodec.SIGNATURE_UNSET;
        try {
            block16: while (input.hasRemaining() != false) {
                tag = input.readVarInt(false);
                field = tag >>> 3;
                f = SignatureSchema.getField(field);
                switch (tag) {
                    case 10: {
                        value = ProtoParserTools.readBytes((ReadableSequentialData)input);
                        temp_signature = new OneOf((Object)Signature.SignatureOneOfType.CONTRACT, (Object)value);
                        continue block16;
                    }
                    case 18: {
                        value = ProtoParserTools.readBytes((ReadableSequentialData)input);
                        temp_signature = new OneOf((Object)Signature.SignatureOneOfType.ED25519, (Object)value);
                        continue block16;
                    }
                    case 26: {
                        value = ProtoParserTools.readBytes((ReadableSequentialData)input);
                        temp_signature = new OneOf((Object)Signature.SignatureOneOfType.RSA_3072, (Object)value);
                        continue block16;
                    }
                    case 34: {
                        value = ProtoParserTools.readBytes((ReadableSequentialData)input);
                        temp_signature = new OneOf((Object)Signature.SignatureOneOfType.ECDSA_384, (Object)value);
                        continue block16;
                    }
                    case 42: {
                        messageLength = input.readVarInt(false);
                        if (messageLength != 0) ** GOTO lbl29
                        value /* !! */  = ThresholdSignature.DEFAULT;
                        ** GOTO lbl42
lbl29:
                        // 1 sources

                        limitBefore = input.limit();
                        startPos = input.position();
                        try {
                            if (startPos + (long)messageLength > limitBefore) {
                                throw new BufferUnderflowException();
                            }
                            input.limit(startPos + (long)messageLength);
                            v0 = value /* !! */  = strictMode != false ? (ThresholdSignature)ThresholdSignature.PROTOBUF.parseStrict(input) : (ThresholdSignature)ThresholdSignature.PROTOBUF.parse(input);
                            if (startPos + (long)messageLength != input.position()) {
                                throw new BufferOverflowException();
                            }
                        }
                        finally {
                            input.limit(limitBefore);
                        }
lbl42:
                        // 2 sources

                        temp_signature = new OneOf((Object)Signature.SignatureOneOfType.THRESHOLD_SIGNATURE, (Object)value /* !! */ );
                        continue block16;
                    }
                    case 50: {
                        messageLength = input.readVarInt(false);
                        if (messageLength != 0) ** GOTO lbl49
                        value /* !! */  = SignatureList.DEFAULT;
                        ** GOTO lbl62
lbl49:
                        // 1 sources

                        limitBefore = input.limit();
                        startPos = input.position();
                        try {
                            if (startPos + (long)messageLength > limitBefore) {
                                throw new BufferUnderflowException();
                            }
                            input.limit(startPos + (long)messageLength);
                            v1 /* !! */  = value /* !! */  = strictMode != false ? (SignatureList)SignatureList.PROTOBUF.parseStrict(input) : (SignatureList)SignatureList.PROTOBUF.parse(input);
                            if (startPos + (long)messageLength != input.position()) {
                                throw new BufferOverflowException();
                            }
                        }
                        finally {
                            input.limit(limitBefore);
                        }
lbl62:
                        // 2 sources

                        temp_signature = new OneOf((Object)Signature.SignatureOneOfType.SIGNATURE_LIST, (Object)value /* !! */ );
                        continue block16;
                    }
                }
                wireType = tag & 7;
                if (field == 0) {
                    throw new IOException("Bad protobuf encoding. We read a field value of " + field);
                }
                if (wireType > 5) {
                    throw new IOException("Cannot understand wire_type of " + wireType);
                }
                if (f != null) throw new IOException("Bad tag [" + tag + "], field [" + field + "] wireType [" + wireType + "]");
                if (strictMode) {
                    throw new UnknownFieldException(field);
                }
                ProtoParserTools.skipField((ReadableSequentialData)input, (ProtoConstants)ProtoConstants.get((int)wireType));
            }
            return new Signature(temp_signature);
        }
        catch (EOFException var4_5) {
            // empty catch block
        }
        return new Signature(temp_signature);
    }
}

