/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.contract;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.ContractID;
import com.hedera.hapi.node.base.QueryHeader;
import com.hedera.hapi.node.contract.codec.ContractCallLocalQueryJsonCodec;
import com.hedera.hapi.node.contract.codec.ContractCallLocalQueryProtoCodec;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.JsonCodec;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Objects;
import java.util.function.Consumer;

public record ContractCallLocalQuery(@Nullable QueryHeader header, @Nullable ContractID contractID, long gas, Bytes functionParameters, long maxResultSize, @Nullable AccountID senderId) {
    public static final Codec<ContractCallLocalQuery> PROTOBUF = new ContractCallLocalQueryProtoCodec();
    public static final JsonCodec<ContractCallLocalQuery> JSON = new ContractCallLocalQueryJsonCodec();
    public static final ContractCallLocalQuery DEFAULT = ContractCallLocalQuery.newBuilder().build();

    @Override
    public int hashCode() {
        int result = 1;
        if (this.header != null && !this.header.equals(ContractCallLocalQuery.DEFAULT.header)) {
            result = 31 * result + this.header.hashCode();
        }
        if (this.contractID != null && !this.contractID.equals(ContractCallLocalQuery.DEFAULT.contractID)) {
            result = 31 * result + this.contractID.hashCode();
        }
        if (this.gas != ContractCallLocalQuery.DEFAULT.gas) {
            result = 31 * result + Long.hashCode(this.gas);
        }
        if (this.functionParameters != null && !this.functionParameters.equals((Object)ContractCallLocalQuery.DEFAULT.functionParameters)) {
            result = 31 * result + this.functionParameters.hashCode();
        }
        if (this.maxResultSize != ContractCallLocalQuery.DEFAULT.maxResultSize) {
            result = 31 * result + Long.hashCode(this.maxResultSize);
        }
        if (this.senderId != null && !this.senderId.equals(ContractCallLocalQuery.DEFAULT.senderId)) {
            result = 31 * result + this.senderId.hashCode();
        }
        long hashCode = result;
        hashCode += hashCode << 30;
        hashCode ^= hashCode >>> 27;
        hashCode += hashCode << 16;
        hashCode ^= hashCode >>> 20;
        hashCode += hashCode << 5;
        hashCode ^= hashCode >>> 18;
        hashCode += hashCode << 10;
        hashCode ^= hashCode >>> 24;
        hashCode += hashCode << 30;
        return (int)hashCode;
    }

    @Override
    public boolean equals(Object that) {
        if (that == null || this.getClass() != that.getClass()) {
            return false;
        }
        ContractCallLocalQuery thatObj = (ContractCallLocalQuery)that;
        if (this.header == null && thatObj.header != null) {
            return false;
        }
        if (this.header != null && !this.header.equals(thatObj.header)) {
            return false;
        }
        if (this.contractID == null && thatObj.contractID != null) {
            return false;
        }
        if (this.contractID != null && !this.contractID.equals(thatObj.contractID)) {
            return false;
        }
        if (this.gas != thatObj.gas) {
            return false;
        }
        if (this.functionParameters == null && thatObj.functionParameters != null) {
            return false;
        }
        if (this.functionParameters != null && !this.functionParameters.equals((Object)thatObj.functionParameters)) {
            return false;
        }
        if (this.maxResultSize != thatObj.maxResultSize) {
            return false;
        }
        if (this.senderId == null && thatObj.senderId != null) {
            return false;
        }
        return this.senderId == null || this.senderId.equals(thatObj.senderId);
    }

    public boolean hasHeader() {
        return this.header != null;
    }

    public QueryHeader headerOrElse(@NonNull QueryHeader defaultValue) {
        return this.hasHeader() ? this.header : defaultValue;
    }

    @NonNull
    public QueryHeader headerOrThrow() {
        return Objects.requireNonNull(this.header, "Field header is null");
    }

    public void ifHeader(@NonNull Consumer<QueryHeader> ifPresent) {
        if (this.hasHeader()) {
            ifPresent.accept(this.header);
        }
    }

    public boolean hasContractID() {
        return this.contractID != null;
    }

    public ContractID contractIDOrElse(@NonNull ContractID defaultValue) {
        return this.hasContractID() ? this.contractID : defaultValue;
    }

    @NonNull
    public ContractID contractIDOrThrow() {
        return Objects.requireNonNull(this.contractID, "Field contractID is null");
    }

    public void ifContractID(@NonNull Consumer<ContractID> ifPresent) {
        if (this.hasContractID()) {
            ifPresent.accept(this.contractID);
        }
    }

    public boolean hasSenderId() {
        return this.senderId != null;
    }

    public AccountID senderIdOrElse(@NonNull AccountID defaultValue) {
        return this.hasSenderId() ? this.senderId : defaultValue;
    }

    @NonNull
    public AccountID senderIdOrThrow() {
        return Objects.requireNonNull(this.senderId, "Field senderId is null");
    }

    public void ifSenderId(@NonNull Consumer<AccountID> ifPresent) {
        if (this.hasSenderId()) {
            ifPresent.accept(this.senderId);
        }
    }

    public Builder copyBuilder() {
        return new Builder(this.header, this.contractID, this.gas, this.functionParameters, this.maxResultSize, this.senderId);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        private QueryHeader header = null;
        private ContractID contractID = null;
        private long gas = 0L;
        private Bytes functionParameters = Bytes.EMPTY;
        private long maxResultSize = 0L;
        private AccountID senderId = null;

        public Builder() {
        }

        public Builder(QueryHeader header, ContractID contractID, long gas, Bytes functionParameters, long maxResultSize, AccountID senderId) {
            this.header = header;
            this.contractID = contractID;
            this.gas = gas;
            this.functionParameters = functionParameters;
            this.maxResultSize = maxResultSize;
            this.senderId = senderId;
        }

        public ContractCallLocalQuery build() {
            return new ContractCallLocalQuery(this.header, this.contractID, this.gas, this.functionParameters, this.maxResultSize, this.senderId);
        }

        public Builder header(QueryHeader header) {
            this.header = header;
            return this;
        }

        public Builder header(QueryHeader.Builder builder) {
            this.header = builder.build();
            return this;
        }

        public Builder contractID(ContractID contractID) {
            this.contractID = contractID;
            return this;
        }

        public Builder contractID(ContractID.Builder builder) {
            this.contractID = builder.build();
            return this;
        }

        public Builder gas(long gas) {
            this.gas = gas;
            return this;
        }

        public Builder functionParameters(Bytes functionParameters) {
            this.functionParameters = functionParameters;
            return this;
        }

        public Builder maxResultSize(long maxResultSize) {
            this.maxResultSize = maxResultSize;
            return this;
        }

        public Builder senderId(AccountID senderId) {
            this.senderId = senderId;
            return this;
        }

        public Builder senderId(AccountID.Builder builder) {
            this.senderId = builder.build();
            return this;
        }
    }
}

