/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.file.codec;

import com.hedera.hapi.node.base.FileID;
import com.hedera.hapi.node.base.KeyList;
import com.hedera.hapi.node.base.Timestamp;
import com.hedera.hapi.node.file.FileInfo;
import com.hedera.hapi.node.file.schema.FileInfoSchema;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.FieldDefinition;
import com.hedera.pbj.runtime.ProtoConstants;
import com.hedera.pbj.runtime.ProtoParserTools;
import com.hedera.pbj.runtime.ProtoWriterTools;
import com.hedera.pbj.runtime.UnknownFieldException;
import com.hedera.pbj.runtime.io.ReadableSequentialData;
import com.hedera.pbj.runtime.io.WritableSequentialData;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.hedera.pbj.runtime.io.buffer.RandomAccessData;
import com.hedera.pbj.runtime.io.stream.EOFException;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;

public final class FileInfoProtoCodec
implements Codec<FileInfo> {
    @NonNull
    public FileInfo parse(@NonNull ReadableSequentialData input) throws IOException {
        return this.parseInternal(input, false);
    }

    @NonNull
    public FileInfo parseStrict(@NonNull ReadableSequentialData input) throws IOException {
        return this.parseInternal(input, true);
    }

    public void write(@NonNull FileInfo data, @NonNull WritableSequentialData out) throws IOException {
        ProtoWriterTools.writeMessage((WritableSequentialData)out, (FieldDefinition)FileInfoSchema.FILE_ID, (Object)data.fileID(), (arg_0, arg_1) -> FileID.PROTOBUF.write(arg_0, arg_1), arg_0 -> FileID.PROTOBUF.measureRecord(arg_0));
        ProtoWriterTools.writeLong((WritableSequentialData)out, (FieldDefinition)FileInfoSchema.SIZE, (long)data.size());
        ProtoWriterTools.writeMessage((WritableSequentialData)out, (FieldDefinition)FileInfoSchema.EXPIRATION_TIME, (Object)data.expirationTime(), (arg_0, arg_1) -> Timestamp.PROTOBUF.write(arg_0, arg_1), arg_0 -> Timestamp.PROTOBUF.measureRecord(arg_0));
        ProtoWriterTools.writeBoolean((WritableSequentialData)out, (FieldDefinition)FileInfoSchema.DELETED, (boolean)data.deleted());
        ProtoWriterTools.writeMessage((WritableSequentialData)out, (FieldDefinition)FileInfoSchema.KEYS, (Object)data.keys(), (arg_0, arg_1) -> KeyList.PROTOBUF.write(arg_0, arg_1), arg_0 -> KeyList.PROTOBUF.measureRecord(arg_0));
        ProtoWriterTools.writeString((WritableSequentialData)out, (FieldDefinition)FileInfoSchema.MEMO, (String)data.memo());
        ProtoWriterTools.writeBytes((WritableSequentialData)out, (FieldDefinition)FileInfoSchema.LEDGER_ID, (RandomAccessData)data.ledgerId());
    }

    public int measure(@NonNull ReadableSequentialData input) throws IOException {
        long start = input.position();
        this.parse(input);
        long end = input.position();
        return (int)(end - start);
    }

    public int measureRecord(FileInfo data) {
        int size = 0;
        size += ProtoWriterTools.sizeOfMessage((FieldDefinition)FileInfoSchema.FILE_ID, (Object)data.fileID(), arg_0 -> FileID.PROTOBUF.measureRecord(arg_0));
        size += ProtoWriterTools.sizeOfLong((FieldDefinition)FileInfoSchema.SIZE, (long)data.size());
        size += ProtoWriterTools.sizeOfMessage((FieldDefinition)FileInfoSchema.EXPIRATION_TIME, (Object)data.expirationTime(), arg_0 -> Timestamp.PROTOBUF.measureRecord(arg_0));
        size += ProtoWriterTools.sizeOfBoolean((FieldDefinition)FileInfoSchema.DELETED, (boolean)data.deleted());
        size += ProtoWriterTools.sizeOfMessage((FieldDefinition)FileInfoSchema.KEYS, (Object)data.keys(), arg_0 -> KeyList.PROTOBUF.measureRecord(arg_0));
        size += ProtoWriterTools.sizeOfString((FieldDefinition)FileInfoSchema.MEMO, (String)data.memo());
        return size += ProtoWriterTools.sizeOfBytes((FieldDefinition)FileInfoSchema.LEDGER_ID, (RandomAccessData)data.ledgerId());
    }

    public boolean fastEquals(@NonNull FileInfo item, @NonNull ReadableSequentialData input) throws IOException {
        return item.equals(this.parse(input));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NonNull
    private FileInfo parseInternal(@NonNull ReadableSequentialData input, boolean strictMode) throws IOException {
        temp_fileID /* !! */  = null;
        temp_size = 0L;
        temp_expirationTime /* !! */  = null;
        temp_deleted = false;
        temp_keys /* !! */  = null;
        temp_memo = "";
        temp_ledger_id = Bytes.EMPTY;
        try {
            block20: while (input.hasRemaining() != false) {
                tag = input.readVarInt(false);
                field = tag >>> 3;
                f = FileInfoSchema.getField(field);
                switch (tag) {
                    case 10: {
                        messageLength = input.readVarInt(false);
                        if (messageLength != 0) ** GOTO lbl19
                        value /* !! */  = FileID.DEFAULT;
                        ** GOTO lbl32
lbl19:
                        // 1 sources

                        limitBefore = input.limit();
                        startPos = input.position();
                        try {
                            if (startPos + (long)messageLength > limitBefore) {
                                throw new BufferUnderflowException();
                            }
                            input.limit(startPos + (long)messageLength);
                            v0 = value /* !! */  = strictMode != false ? (FileID)FileID.PROTOBUF.parseStrict(input) : (FileID)FileID.PROTOBUF.parse(input);
                            if (startPos + (long)messageLength != input.position()) {
                                throw new BufferOverflowException();
                            }
                        }
                        finally {
                            input.limit(limitBefore);
                        }
lbl32:
                        // 2 sources

                        temp_fileID /* !! */  = value /* !! */ ;
                        continue block20;
                    }
                    case 16: {
                        temp_size = value = ProtoParserTools.readInt64((ReadableSequentialData)input);
                        continue block20;
                    }
                    case 26: {
                        messageLength = input.readVarInt(false);
                        if (messageLength != 0) ** GOTO lbl42
                        value /* !! */  = Timestamp.DEFAULT;
                        ** GOTO lbl55
lbl42:
                        // 1 sources

                        limitBefore = input.limit();
                        startPos = input.position();
                        try {
                            if (startPos + (long)messageLength > limitBefore) {
                                throw new BufferUnderflowException();
                            }
                            input.limit(startPos + (long)messageLength);
                            v1 /* !! */  = value /* !! */  = strictMode != false ? (Timestamp)Timestamp.PROTOBUF.parseStrict(input) : (Timestamp)Timestamp.PROTOBUF.parse(input);
                            if (startPos + (long)messageLength != input.position()) {
                                throw new BufferOverflowException();
                            }
                        }
                        finally {
                            input.limit(limitBefore);
                        }
lbl55:
                        // 2 sources

                        temp_expirationTime /* !! */  = value /* !! */ ;
                        continue block20;
                    }
                    case 32: {
                        temp_deleted = value = ProtoParserTools.readBool((ReadableSequentialData)input);
                        continue block20;
                    }
                    case 42: {
                        messageLength = input.readVarInt(false);
                        if (messageLength != 0) ** GOTO lbl65
                        value /* !! */  = KeyList.DEFAULT;
                        ** GOTO lbl78
lbl65:
                        // 1 sources

                        limitBefore = input.limit();
                        startPos = input.position();
                        try {
                            if (startPos + (long)messageLength > limitBefore) {
                                throw new BufferUnderflowException();
                            }
                            input.limit(startPos + (long)messageLength);
                            v2 /* !! */  = value /* !! */  = strictMode != false ? (KeyList)KeyList.PROTOBUF.parseStrict(input) : (KeyList)KeyList.PROTOBUF.parse(input);
                            if (startPos + (long)messageLength != input.position()) {
                                throw new BufferOverflowException();
                            }
                        }
                        finally {
                            input.limit(limitBefore);
                        }
lbl78:
                        // 2 sources

                        temp_keys /* !! */  = value /* !! */ ;
                        continue block20;
                    }
                    case 50: {
                        temp_memo = value = ProtoParserTools.readString((ReadableSequentialData)input);
                        continue block20;
                    }
                    case 58: {
                        temp_ledger_id = value = ProtoParserTools.readBytes((ReadableSequentialData)input);
                        continue block20;
                    }
                }
                wireType = tag & 7;
                if (field == 0) {
                    throw new IOException("Bad protobuf encoding. We read a field value of " + field);
                }
                if (wireType > 5) {
                    throw new IOException("Cannot understand wire_type of " + wireType);
                }
                if (f != null) throw new IOException("Bad tag [" + tag + "], field [" + field + "] wireType [" + wireType + "]");
                if (strictMode) {
                    throw new UnknownFieldException(field);
                }
                ProtoParserTools.skipField((ReadableSequentialData)input, (ProtoConstants)ProtoConstants.get((int)wireType));
            }
            return new FileInfo(temp_fileID /* !! */ , temp_size, (Timestamp)temp_expirationTime /* !! */ , temp_deleted, (KeyList)temp_keys /* !! */ , temp_memo, temp_ledger_id);
        }
        catch (EOFException var11_11) {
            // empty catch block
        }
        return new FileInfo(temp_fileID /* !! */ , temp_size, (Timestamp)temp_expirationTime /* !! */ , temp_deleted, (KeyList)temp_keys /* !! */ , temp_memo, temp_ledger_id);
    }
}

