/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.scheduled;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.Key;
import com.hedera.hapi.node.base.Timestamp;
import com.hedera.hapi.node.scheduled.SchedulableTransactionBody;
import com.hedera.hapi.node.scheduled.codec.ScheduleCreateTransactionBodyJsonCodec;
import com.hedera.hapi.node.scheduled.codec.ScheduleCreateTransactionBodyProtoCodec;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.JsonCodec;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Objects;
import java.util.function.Consumer;

public record ScheduleCreateTransactionBody(@Nullable SchedulableTransactionBody scheduledTransactionBody, String memo, @Nullable Key adminKey, @Nullable AccountID payerAccountID, @Nullable Timestamp expirationTime, boolean waitForExpiry) {
    public static final Codec<ScheduleCreateTransactionBody> PROTOBUF = new ScheduleCreateTransactionBodyProtoCodec();
    public static final JsonCodec<ScheduleCreateTransactionBody> JSON = new ScheduleCreateTransactionBodyJsonCodec();
    public static final ScheduleCreateTransactionBody DEFAULT = ScheduleCreateTransactionBody.newBuilder().build();

    @Override
    public int hashCode() {
        int result = 1;
        if (this.scheduledTransactionBody != null && !this.scheduledTransactionBody.equals(ScheduleCreateTransactionBody.DEFAULT.scheduledTransactionBody)) {
            result = 31 * result + this.scheduledTransactionBody.hashCode();
        }
        if (this.memo != null && !this.memo.equals(ScheduleCreateTransactionBody.DEFAULT.memo)) {
            result = 31 * result + this.memo.hashCode();
        }
        if (this.adminKey != null && !this.adminKey.equals(ScheduleCreateTransactionBody.DEFAULT.adminKey)) {
            result = 31 * result + this.adminKey.hashCode();
        }
        if (this.payerAccountID != null && !this.payerAccountID.equals(ScheduleCreateTransactionBody.DEFAULT.payerAccountID)) {
            result = 31 * result + this.payerAccountID.hashCode();
        }
        if (this.expirationTime != null && !this.expirationTime.equals(ScheduleCreateTransactionBody.DEFAULT.expirationTime)) {
            result = 31 * result + this.expirationTime.hashCode();
        }
        if (this.waitForExpiry != ScheduleCreateTransactionBody.DEFAULT.waitForExpiry) {
            result = 31 * result + Boolean.hashCode(this.waitForExpiry);
        }
        long hashCode = result;
        hashCode += hashCode << 30;
        hashCode ^= hashCode >>> 27;
        hashCode += hashCode << 16;
        hashCode ^= hashCode >>> 20;
        hashCode += hashCode << 5;
        hashCode ^= hashCode >>> 18;
        hashCode += hashCode << 10;
        hashCode ^= hashCode >>> 24;
        hashCode += hashCode << 30;
        return (int)hashCode;
    }

    @Override
    public boolean equals(Object that) {
        if (that == null || this.getClass() != that.getClass()) {
            return false;
        }
        ScheduleCreateTransactionBody thatObj = (ScheduleCreateTransactionBody)that;
        if (this.scheduledTransactionBody == null && thatObj.scheduledTransactionBody != null) {
            return false;
        }
        if (this.scheduledTransactionBody != null && !this.scheduledTransactionBody.equals(thatObj.scheduledTransactionBody)) {
            return false;
        }
        if (this.memo == null && thatObj.memo != null) {
            return false;
        }
        if (this.memo != null && !this.memo.equals(thatObj.memo)) {
            return false;
        }
        if (this.adminKey == null && thatObj.adminKey != null) {
            return false;
        }
        if (this.adminKey != null && !this.adminKey.equals(thatObj.adminKey)) {
            return false;
        }
        if (this.payerAccountID == null && thatObj.payerAccountID != null) {
            return false;
        }
        if (this.payerAccountID != null && !this.payerAccountID.equals(thatObj.payerAccountID)) {
            return false;
        }
        if (this.expirationTime == null && thatObj.expirationTime != null) {
            return false;
        }
        if (this.expirationTime != null && !this.expirationTime.equals(thatObj.expirationTime)) {
            return false;
        }
        return this.waitForExpiry == thatObj.waitForExpiry;
    }

    public boolean hasScheduledTransactionBody() {
        return this.scheduledTransactionBody != null;
    }

    public SchedulableTransactionBody scheduledTransactionBodyOrElse(@NonNull SchedulableTransactionBody defaultValue) {
        return this.hasScheduledTransactionBody() ? this.scheduledTransactionBody : defaultValue;
    }

    @NonNull
    public SchedulableTransactionBody scheduledTransactionBodyOrThrow() {
        return Objects.requireNonNull(this.scheduledTransactionBody, "Field scheduledTransactionBody is null");
    }

    public void ifScheduledTransactionBody(@NonNull Consumer<SchedulableTransactionBody> ifPresent) {
        if (this.hasScheduledTransactionBody()) {
            ifPresent.accept(this.scheduledTransactionBody);
        }
    }

    public boolean hasAdminKey() {
        return this.adminKey != null;
    }

    public Key adminKeyOrElse(@NonNull Key defaultValue) {
        return this.hasAdminKey() ? this.adminKey : defaultValue;
    }

    @NonNull
    public Key adminKeyOrThrow() {
        return Objects.requireNonNull(this.adminKey, "Field adminKey is null");
    }

    public void ifAdminKey(@NonNull Consumer<Key> ifPresent) {
        if (this.hasAdminKey()) {
            ifPresent.accept(this.adminKey);
        }
    }

    public boolean hasPayerAccountID() {
        return this.payerAccountID != null;
    }

    public AccountID payerAccountIDOrElse(@NonNull AccountID defaultValue) {
        return this.hasPayerAccountID() ? this.payerAccountID : defaultValue;
    }

    @NonNull
    public AccountID payerAccountIDOrThrow() {
        return Objects.requireNonNull(this.payerAccountID, "Field payerAccountID is null");
    }

    public void ifPayerAccountID(@NonNull Consumer<AccountID> ifPresent) {
        if (this.hasPayerAccountID()) {
            ifPresent.accept(this.payerAccountID);
        }
    }

    public boolean hasExpirationTime() {
        return this.expirationTime != null;
    }

    public Timestamp expirationTimeOrElse(@NonNull Timestamp defaultValue) {
        return this.hasExpirationTime() ? this.expirationTime : defaultValue;
    }

    @NonNull
    public Timestamp expirationTimeOrThrow() {
        return Objects.requireNonNull(this.expirationTime, "Field expirationTime is null");
    }

    public void ifExpirationTime(@NonNull Consumer<Timestamp> ifPresent) {
        if (this.hasExpirationTime()) {
            ifPresent.accept(this.expirationTime);
        }
    }

    public Builder copyBuilder() {
        return new Builder(this.scheduledTransactionBody, this.memo, this.adminKey, this.payerAccountID, this.expirationTime, this.waitForExpiry);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        private SchedulableTransactionBody scheduledTransactionBody = null;
        private String memo = "";
        private Key adminKey = null;
        private AccountID payerAccountID = null;
        private Timestamp expirationTime = null;
        private boolean waitForExpiry = false;

        public Builder() {
        }

        public Builder(SchedulableTransactionBody scheduledTransactionBody, String memo, Key adminKey, AccountID payerAccountID, Timestamp expirationTime, boolean waitForExpiry) {
            this.scheduledTransactionBody = scheduledTransactionBody;
            this.memo = memo;
            this.adminKey = adminKey;
            this.payerAccountID = payerAccountID;
            this.expirationTime = expirationTime;
            this.waitForExpiry = waitForExpiry;
        }

        public ScheduleCreateTransactionBody build() {
            return new ScheduleCreateTransactionBody(this.scheduledTransactionBody, this.memo, this.adminKey, this.payerAccountID, this.expirationTime, this.waitForExpiry);
        }

        public Builder scheduledTransactionBody(SchedulableTransactionBody scheduledTransactionBody) {
            this.scheduledTransactionBody = scheduledTransactionBody;
            return this;
        }

        public Builder scheduledTransactionBody(SchedulableTransactionBody.Builder builder) {
            this.scheduledTransactionBody = builder.build();
            return this;
        }

        public Builder memo(String memo) {
            this.memo = memo;
            return this;
        }

        public Builder adminKey(Key adminKey) {
            this.adminKey = adminKey;
            return this;
        }

        public Builder adminKey(Key.Builder builder) {
            this.adminKey = builder.build();
            return this;
        }

        public Builder payerAccountID(AccountID payerAccountID) {
            this.payerAccountID = payerAccountID;
            return this;
        }

        public Builder payerAccountID(AccountID.Builder builder) {
            this.payerAccountID = builder.build();
            return this;
        }

        public Builder expirationTime(Timestamp expirationTime) {
            this.expirationTime = expirationTime;
            return this;
        }

        public Builder expirationTime(Timestamp.Builder builder) {
            this.expirationTime = builder.build();
            return this;
        }

        public Builder waitForExpiry(boolean waitForExpiry) {
            this.waitForExpiry = waitForExpiry;
            return this;
        }
    }
}

