/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.state.contract.codec;

import com.hedera.hapi.node.state.contract.SlotKey;
import com.hedera.hapi.node.state.contract.schema.SlotKeySchema;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.FieldDefinition;
import com.hedera.pbj.runtime.ProtoConstants;
import com.hedera.pbj.runtime.ProtoParserTools;
import com.hedera.pbj.runtime.ProtoWriterTools;
import com.hedera.pbj.runtime.UnknownFieldException;
import com.hedera.pbj.runtime.io.ReadableSequentialData;
import com.hedera.pbj.runtime.io.WritableSequentialData;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.hedera.pbj.runtime.io.buffer.RandomAccessData;
import com.hedera.pbj.runtime.io.stream.EOFException;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;

public final class SlotKeyProtoCodec
implements Codec<SlotKey> {
    @NonNull
    public SlotKey parse(@NonNull ReadableSequentialData input) throws IOException {
        return this.parseInternal(input, false);
    }

    @NonNull
    public SlotKey parseStrict(@NonNull ReadableSequentialData input) throws IOException {
        return this.parseInternal(input, true);
    }

    public void write(@NonNull SlotKey data, @NonNull WritableSequentialData out) throws IOException {
        ProtoWriterTools.writeLong((WritableSequentialData)out, (FieldDefinition)SlotKeySchema.CONTRACT_NUMBER, (long)data.contractNumber());
        ProtoWriterTools.writeBytes((WritableSequentialData)out, (FieldDefinition)SlotKeySchema.KEY, (RandomAccessData)data.key());
    }

    public int measure(@NonNull ReadableSequentialData input) throws IOException {
        long start = input.position();
        this.parse(input);
        long end = input.position();
        return (int)(end - start);
    }

    public int measureRecord(SlotKey data) {
        int size = 0;
        size += ProtoWriterTools.sizeOfLong((FieldDefinition)SlotKeySchema.CONTRACT_NUMBER, (long)data.contractNumber());
        return size += ProtoWriterTools.sizeOfBytes((FieldDefinition)SlotKeySchema.KEY, (RandomAccessData)data.key());
    }

    public boolean fastEquals(@NonNull SlotKey item, @NonNull ReadableSequentialData input) throws IOException {
        return item.equals(this.parse(input));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NonNull
    private SlotKey parseInternal(@NonNull ReadableSequentialData input, boolean strictMode) throws IOException {
        long temp_contract_number = 0L;
        Bytes temp_key = Bytes.EMPTY;
        try {
            block6: while (input.hasRemaining()) {
                int tag = input.readVarInt(false);
                int field = tag >>> 3;
                FieldDefinition f = SlotKeySchema.getField(field);
                switch (tag) {
                    case 8: {
                        long value;
                        temp_contract_number = value = ProtoParserTools.readInt64((ReadableSequentialData)input);
                        continue block6;
                    }
                    case 18: {
                        Bytes value;
                        temp_key = value = ProtoParserTools.readBytes((ReadableSequentialData)input);
                        continue block6;
                    }
                }
                int wireType = tag & 7;
                if (field == 0) {
                    throw new IOException("Bad protobuf encoding. We read a field value of " + field);
                }
                if (wireType > 5) {
                    throw new IOException("Cannot understand wire_type of " + wireType);
                }
                if (f != null) throw new IOException("Bad tag [" + tag + "], field [" + field + "] wireType [" + wireType + "]");
                if (strictMode) {
                    throw new UnknownFieldException(field);
                }
                ProtoParserTools.skipField((ReadableSequentialData)input, (ProtoConstants)ProtoConstants.get((int)wireType));
            }
            return new SlotKey(temp_contract_number, temp_key);
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        return new SlotKey(temp_contract_number, temp_key);
    }
}

