/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.state.token;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.TokenID;
import com.hedera.hapi.node.state.token.codec.AccountFungibleTokenAllowanceJsonCodec;
import com.hedera.hapi.node.state.token.codec.AccountFungibleTokenAllowanceProtoCodec;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.JsonCodec;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Objects;
import java.util.function.Consumer;

public record AccountFungibleTokenAllowance(@Nullable TokenID tokenId, @Nullable AccountID spenderId, long amount) {
    public static final Codec<AccountFungibleTokenAllowance> PROTOBUF = new AccountFungibleTokenAllowanceProtoCodec();
    public static final JsonCodec<AccountFungibleTokenAllowance> JSON = new AccountFungibleTokenAllowanceJsonCodec();
    public static final AccountFungibleTokenAllowance DEFAULT = AccountFungibleTokenAllowance.newBuilder().build();

    @Override
    public int hashCode() {
        int result = 1;
        if (this.tokenId != null && !this.tokenId.equals(AccountFungibleTokenAllowance.DEFAULT.tokenId)) {
            result = 31 * result + this.tokenId.hashCode();
        }
        if (this.spenderId != null && !this.spenderId.equals(AccountFungibleTokenAllowance.DEFAULT.spenderId)) {
            result = 31 * result + this.spenderId.hashCode();
        }
        if (this.amount != AccountFungibleTokenAllowance.DEFAULT.amount) {
            result = 31 * result + Long.hashCode(this.amount);
        }
        long hashCode = result;
        hashCode += hashCode << 30;
        hashCode ^= hashCode >>> 27;
        hashCode += hashCode << 16;
        hashCode ^= hashCode >>> 20;
        hashCode += hashCode << 5;
        hashCode ^= hashCode >>> 18;
        hashCode += hashCode << 10;
        hashCode ^= hashCode >>> 24;
        hashCode += hashCode << 30;
        return (int)hashCode;
    }

    @Override
    public boolean equals(Object that) {
        if (that == null || this.getClass() != that.getClass()) {
            return false;
        }
        AccountFungibleTokenAllowance thatObj = (AccountFungibleTokenAllowance)that;
        if (this.tokenId == null && thatObj.tokenId != null) {
            return false;
        }
        if (this.tokenId != null && !this.tokenId.equals(thatObj.tokenId)) {
            return false;
        }
        if (this.spenderId == null && thatObj.spenderId != null) {
            return false;
        }
        if (this.spenderId != null && !this.spenderId.equals(thatObj.spenderId)) {
            return false;
        }
        return this.amount == thatObj.amount;
    }

    public boolean hasTokenId() {
        return this.tokenId != null;
    }

    public TokenID tokenIdOrElse(@NonNull TokenID defaultValue) {
        return this.hasTokenId() ? this.tokenId : defaultValue;
    }

    @NonNull
    public TokenID tokenIdOrThrow() {
        return Objects.requireNonNull(this.tokenId, "Field tokenId is null");
    }

    public void ifTokenId(@NonNull Consumer<TokenID> ifPresent) {
        if (this.hasTokenId()) {
            ifPresent.accept(this.tokenId);
        }
    }

    public boolean hasSpenderId() {
        return this.spenderId != null;
    }

    public AccountID spenderIdOrElse(@NonNull AccountID defaultValue) {
        return this.hasSpenderId() ? this.spenderId : defaultValue;
    }

    @NonNull
    public AccountID spenderIdOrThrow() {
        return Objects.requireNonNull(this.spenderId, "Field spenderId is null");
    }

    public void ifSpenderId(@NonNull Consumer<AccountID> ifPresent) {
        if (this.hasSpenderId()) {
            ifPresent.accept(this.spenderId);
        }
    }

    public Builder copyBuilder() {
        return new Builder(this.tokenId, this.spenderId, this.amount);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        private TokenID tokenId = null;
        private AccountID spenderId = null;
        private long amount = 0L;

        public Builder() {
        }

        public Builder(TokenID tokenId, AccountID spenderId, long amount) {
            this.tokenId = tokenId;
            this.spenderId = spenderId;
            this.amount = amount;
        }

        public AccountFungibleTokenAllowance build() {
            return new AccountFungibleTokenAllowance(this.tokenId, this.spenderId, this.amount);
        }

        public Builder tokenId(TokenID tokenId) {
            this.tokenId = tokenId;
            return this;
        }

        public Builder tokenId(TokenID.Builder builder) {
            this.tokenId = builder.build();
            return this;
        }

        public Builder spenderId(AccountID spenderId) {
            this.spenderId = spenderId;
            return this;
        }

        public Builder spenderId(AccountID.Builder builder) {
            this.spenderId = builder.build();
            return this;
        }

        public Builder amount(long amount) {
            this.amount = amount;
            return this;
        }
    }
}

