/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.token;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.Duration;
import com.hedera.hapi.node.base.Key;
import com.hedera.hapi.node.base.Timestamp;
import com.hedera.hapi.node.base.TokenRelationship;
import com.hedera.hapi.node.token.GrantedCryptoAllowance;
import com.hedera.hapi.node.token.GrantedNftAllowance;
import com.hedera.hapi.node.token.GrantedTokenAllowance;
import com.hedera.hapi.node.token.codec.AccountDetailsJsonCodec;
import com.hedera.hapi.node.token.codec.AccountDetailsProtoCodec;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.JsonCodec;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;

public record AccountDetails(@Nullable AccountID accountId, String contractAccountId, boolean deleted, @Nullable AccountID proxyAccountId, long proxyReceived, @Nullable Key key, long balance, boolean receiverSigRequired, @Nullable Timestamp expirationTime, @Nullable Duration autoRenewPeriod, @Nullable List<TokenRelationship> tokenRelationships, String memo, long ownedNfts, int maxAutomaticTokenAssociations, Bytes alias, Bytes ledgerId, @Nullable List<GrantedCryptoAllowance> grantedCryptoAllowances, @Nullable List<GrantedNftAllowance> grantedNftAllowances, @Nullable List<GrantedTokenAllowance> grantedTokenAllowances) {
    public static final Codec<AccountDetails> PROTOBUF = new AccountDetailsProtoCodec();
    public static final JsonCodec<AccountDetails> JSON = new AccountDetailsJsonCodec();
    public static final AccountDetails DEFAULT = AccountDetails.newBuilder().build();

    @Override
    public int hashCode() {
        List<GrantedTokenAllowance> list;
        List<GrantedNftAllowance> list2;
        List<GrantedCryptoAllowance> list$grantedCryptoAllowances;
        List<TokenRelationship> list$tokenRelationships;
        int result = 1;
        if (this.accountId != null && !this.accountId.equals(AccountDetails.DEFAULT.accountId)) {
            result = 31 * result + this.accountId.hashCode();
        }
        if (this.contractAccountId != null && !this.contractAccountId.equals(AccountDetails.DEFAULT.contractAccountId)) {
            result = 31 * result + this.contractAccountId.hashCode();
        }
        if (this.deleted != AccountDetails.DEFAULT.deleted) {
            result = 31 * result + Boolean.hashCode(this.deleted);
        }
        if (this.proxyAccountId != null && !this.proxyAccountId.equals(AccountDetails.DEFAULT.proxyAccountId)) {
            result = 31 * result + this.proxyAccountId.hashCode();
        }
        if (this.proxyReceived != AccountDetails.DEFAULT.proxyReceived) {
            result = 31 * result + Long.hashCode(this.proxyReceived);
        }
        if (this.key != null && !this.key.equals(AccountDetails.DEFAULT.key)) {
            result = 31 * result + this.key.hashCode();
        }
        if (this.balance != AccountDetails.DEFAULT.balance) {
            result = 31 * result + Long.hashCode(this.balance);
        }
        if (this.receiverSigRequired != AccountDetails.DEFAULT.receiverSigRequired) {
            result = 31 * result + Boolean.hashCode(this.receiverSigRequired);
        }
        if (this.expirationTime != null && !this.expirationTime.equals(AccountDetails.DEFAULT.expirationTime)) {
            result = 31 * result + this.expirationTime.hashCode();
        }
        if (this.autoRenewPeriod != null && !this.autoRenewPeriod.equals(AccountDetails.DEFAULT.autoRenewPeriod)) {
            result = 31 * result + this.autoRenewPeriod.hashCode();
        }
        if ((list$tokenRelationships = this.tokenRelationships) != null) {
            for (TokenRelationship tokenRelationship : list$tokenRelationships) {
                if (tokenRelationship != null) {
                    result = 31 * result + ((Object)tokenRelationship).hashCode();
                    continue;
                }
                result = 31 * result;
            }
        }
        if (this.memo != null && !this.memo.equals(AccountDetails.DEFAULT.memo)) {
            result = 31 * result + this.memo.hashCode();
        }
        if (this.ownedNfts != AccountDetails.DEFAULT.ownedNfts) {
            result = 31 * result + Long.hashCode(this.ownedNfts);
        }
        if (this.maxAutomaticTokenAssociations != AccountDetails.DEFAULT.maxAutomaticTokenAssociations) {
            result = 31 * result + Integer.hashCode(this.maxAutomaticTokenAssociations);
        }
        if (this.alias != null && !this.alias.equals((Object)AccountDetails.DEFAULT.alias)) {
            result = 31 * result + this.alias.hashCode();
        }
        if (this.ledgerId != null && !this.ledgerId.equals((Object)AccountDetails.DEFAULT.ledgerId)) {
            result = 31 * result + this.ledgerId.hashCode();
        }
        if ((list$grantedCryptoAllowances = this.grantedCryptoAllowances) != null) {
            for (GrantedCryptoAllowance grantedCryptoAllowance : list$grantedCryptoAllowances) {
                if (grantedCryptoAllowance != null) {
                    result = 31 * result + ((Object)grantedCryptoAllowance).hashCode();
                    continue;
                }
                result = 31 * result;
            }
        }
        if ((list2 = this.grantedNftAllowances) != null) {
            for (GrantedNftAllowance grantedNftAllowance : list2) {
                if (grantedNftAllowance != null) {
                    result = 31 * result + ((Object)grantedNftAllowance).hashCode();
                    continue;
                }
                result = 31 * result;
            }
        }
        if ((list = this.grantedTokenAllowances) != null) {
            for (GrantedTokenAllowance grantedTokenAllowance : list) {
                if (grantedTokenAllowance != null) {
                    result = 31 * result + ((Object)grantedTokenAllowance).hashCode();
                    continue;
                }
                result = 31 * result;
            }
        }
        long l = result;
        l += l << 30;
        l ^= l >>> 27;
        l += l << 16;
        l ^= l >>> 20;
        l += l << 5;
        l ^= l >>> 18;
        l += l << 10;
        l ^= l >>> 24;
        l += l << 30;
        return (int)l;
    }

    @Override
    public boolean equals(Object that) {
        if (that == null || this.getClass() != that.getClass()) {
            return false;
        }
        AccountDetails thatObj = (AccountDetails)that;
        if (this.accountId == null && thatObj.accountId != null) {
            return false;
        }
        if (this.accountId != null && !this.accountId.equals(thatObj.accountId)) {
            return false;
        }
        if (this.contractAccountId == null && thatObj.contractAccountId != null) {
            return false;
        }
        if (this.contractAccountId != null && !this.contractAccountId.equals(thatObj.contractAccountId)) {
            return false;
        }
        if (this.deleted != thatObj.deleted) {
            return false;
        }
        if (this.proxyAccountId == null && thatObj.proxyAccountId != null) {
            return false;
        }
        if (this.proxyAccountId != null && !this.proxyAccountId.equals(thatObj.proxyAccountId)) {
            return false;
        }
        if (this.proxyReceived != thatObj.proxyReceived) {
            return false;
        }
        if (this.key == null && thatObj.key != null) {
            return false;
        }
        if (this.key != null && !this.key.equals(thatObj.key)) {
            return false;
        }
        if (this.balance != thatObj.balance) {
            return false;
        }
        if (this.receiverSigRequired != thatObj.receiverSigRequired) {
            return false;
        }
        if (this.expirationTime == null && thatObj.expirationTime != null) {
            return false;
        }
        if (this.expirationTime != null && !this.expirationTime.equals(thatObj.expirationTime)) {
            return false;
        }
        if (this.autoRenewPeriod == null && thatObj.autoRenewPeriod != null) {
            return false;
        }
        if (this.autoRenewPeriod != null && !this.autoRenewPeriod.equals(thatObj.autoRenewPeriod)) {
            return false;
        }
        if (this.tokenRelationships == null && thatObj.tokenRelationships != null) {
            return false;
        }
        if (this.tokenRelationships != null && !this.tokenRelationships.equals(thatObj.tokenRelationships)) {
            return false;
        }
        if (this.memo == null && thatObj.memo != null) {
            return false;
        }
        if (this.memo != null && !this.memo.equals(thatObj.memo)) {
            return false;
        }
        if (this.ownedNfts != thatObj.ownedNfts) {
            return false;
        }
        if (this.maxAutomaticTokenAssociations != thatObj.maxAutomaticTokenAssociations) {
            return false;
        }
        if (this.alias == null && thatObj.alias != null) {
            return false;
        }
        if (this.alias != null && !this.alias.equals((Object)thatObj.alias)) {
            return false;
        }
        if (this.ledgerId == null && thatObj.ledgerId != null) {
            return false;
        }
        if (this.ledgerId != null && !this.ledgerId.equals((Object)thatObj.ledgerId)) {
            return false;
        }
        if (this.grantedCryptoAllowances == null && thatObj.grantedCryptoAllowances != null) {
            return false;
        }
        if (this.grantedCryptoAllowances != null && !this.grantedCryptoAllowances.equals(thatObj.grantedCryptoAllowances)) {
            return false;
        }
        if (this.grantedNftAllowances == null && thatObj.grantedNftAllowances != null) {
            return false;
        }
        if (this.grantedNftAllowances != null && !this.grantedNftAllowances.equals(thatObj.grantedNftAllowances)) {
            return false;
        }
        if (this.grantedTokenAllowances == null && thatObj.grantedTokenAllowances != null) {
            return false;
        }
        return this.grantedTokenAllowances == null || this.grantedTokenAllowances.equals(thatObj.grantedTokenAllowances);
    }

    public boolean hasAccountId() {
        return this.accountId != null;
    }

    public AccountID accountIdOrElse(@NonNull AccountID defaultValue) {
        return this.hasAccountId() ? this.accountId : defaultValue;
    }

    @NonNull
    public AccountID accountIdOrThrow() {
        return Objects.requireNonNull(this.accountId, "Field accountId is null");
    }

    public void ifAccountId(@NonNull Consumer<AccountID> ifPresent) {
        if (this.hasAccountId()) {
            ifPresent.accept(this.accountId);
        }
    }

    public boolean hasProxyAccountId() {
        return this.proxyAccountId != null;
    }

    public AccountID proxyAccountIdOrElse(@NonNull AccountID defaultValue) {
        return this.hasProxyAccountId() ? this.proxyAccountId : defaultValue;
    }

    @NonNull
    public AccountID proxyAccountIdOrThrow() {
        return Objects.requireNonNull(this.proxyAccountId, "Field proxyAccountId is null");
    }

    public void ifProxyAccountId(@NonNull Consumer<AccountID> ifPresent) {
        if (this.hasProxyAccountId()) {
            ifPresent.accept(this.proxyAccountId);
        }
    }

    public boolean hasKey() {
        return this.key != null;
    }

    public Key keyOrElse(@NonNull Key defaultValue) {
        return this.hasKey() ? this.key : defaultValue;
    }

    @NonNull
    public Key keyOrThrow() {
        return Objects.requireNonNull(this.key, "Field key is null");
    }

    public void ifKey(@NonNull Consumer<Key> ifPresent) {
        if (this.hasKey()) {
            ifPresent.accept(this.key);
        }
    }

    public boolean hasExpirationTime() {
        return this.expirationTime != null;
    }

    public Timestamp expirationTimeOrElse(@NonNull Timestamp defaultValue) {
        return this.hasExpirationTime() ? this.expirationTime : defaultValue;
    }

    @NonNull
    public Timestamp expirationTimeOrThrow() {
        return Objects.requireNonNull(this.expirationTime, "Field expirationTime is null");
    }

    public void ifExpirationTime(@NonNull Consumer<Timestamp> ifPresent) {
        if (this.hasExpirationTime()) {
            ifPresent.accept(this.expirationTime);
        }
    }

    public boolean hasAutoRenewPeriod() {
        return this.autoRenewPeriod != null;
    }

    public Duration autoRenewPeriodOrElse(@NonNull Duration defaultValue) {
        return this.hasAutoRenewPeriod() ? this.autoRenewPeriod : defaultValue;
    }

    @NonNull
    public Duration autoRenewPeriodOrThrow() {
        return Objects.requireNonNull(this.autoRenewPeriod, "Field autoRenewPeriod is null");
    }

    public void ifAutoRenewPeriod(@NonNull Consumer<Duration> ifPresent) {
        if (this.hasAutoRenewPeriod()) {
            ifPresent.accept(this.autoRenewPeriod);
        }
    }

    public boolean hasTokenRelationships() {
        return this.tokenRelationships != null;
    }

    public List<TokenRelationship> tokenRelationshipsOrElse(@NonNull List<TokenRelationship> defaultValue) {
        return this.hasTokenRelationships() ? this.tokenRelationships : defaultValue;
    }

    @NonNull
    public List<TokenRelationship> tokenRelationshipsOrThrow() {
        return Objects.requireNonNull(this.tokenRelationships, "Field tokenRelationships is null");
    }

    public void ifTokenRelationships(@NonNull Consumer<List<TokenRelationship>> ifPresent) {
        if (this.hasTokenRelationships()) {
            ifPresent.accept(this.tokenRelationships);
        }
    }

    public boolean hasGrantedCryptoAllowances() {
        return this.grantedCryptoAllowances != null;
    }

    public List<GrantedCryptoAllowance> grantedCryptoAllowancesOrElse(@NonNull List<GrantedCryptoAllowance> defaultValue) {
        return this.hasGrantedCryptoAllowances() ? this.grantedCryptoAllowances : defaultValue;
    }

    @NonNull
    public List<GrantedCryptoAllowance> grantedCryptoAllowancesOrThrow() {
        return Objects.requireNonNull(this.grantedCryptoAllowances, "Field grantedCryptoAllowances is null");
    }

    public void ifGrantedCryptoAllowances(@NonNull Consumer<List<GrantedCryptoAllowance>> ifPresent) {
        if (this.hasGrantedCryptoAllowances()) {
            ifPresent.accept(this.grantedCryptoAllowances);
        }
    }

    public boolean hasGrantedNftAllowances() {
        return this.grantedNftAllowances != null;
    }

    public List<GrantedNftAllowance> grantedNftAllowancesOrElse(@NonNull List<GrantedNftAllowance> defaultValue) {
        return this.hasGrantedNftAllowances() ? this.grantedNftAllowances : defaultValue;
    }

    @NonNull
    public List<GrantedNftAllowance> grantedNftAllowancesOrThrow() {
        return Objects.requireNonNull(this.grantedNftAllowances, "Field grantedNftAllowances is null");
    }

    public void ifGrantedNftAllowances(@NonNull Consumer<List<GrantedNftAllowance>> ifPresent) {
        if (this.hasGrantedNftAllowances()) {
            ifPresent.accept(this.grantedNftAllowances);
        }
    }

    public boolean hasGrantedTokenAllowances() {
        return this.grantedTokenAllowances != null;
    }

    public List<GrantedTokenAllowance> grantedTokenAllowancesOrElse(@NonNull List<GrantedTokenAllowance> defaultValue) {
        return this.hasGrantedTokenAllowances() ? this.grantedTokenAllowances : defaultValue;
    }

    @NonNull
    public List<GrantedTokenAllowance> grantedTokenAllowancesOrThrow() {
        return Objects.requireNonNull(this.grantedTokenAllowances, "Field grantedTokenAllowances is null");
    }

    public void ifGrantedTokenAllowances(@NonNull Consumer<List<GrantedTokenAllowance>> ifPresent) {
        if (this.hasGrantedTokenAllowances()) {
            ifPresent.accept(this.grantedTokenAllowances);
        }
    }

    public Builder copyBuilder() {
        return new Builder(this.accountId, this.contractAccountId, this.deleted, this.proxyAccountId, this.proxyReceived, this.key, this.balance, this.receiverSigRequired, this.expirationTime, this.autoRenewPeriod, this.tokenRelationships, this.memo, this.ownedNfts, this.maxAutomaticTokenAssociations, this.alias, this.ledgerId, this.grantedCryptoAllowances, this.grantedNftAllowances, this.grantedTokenAllowances);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        private AccountID accountId = null;
        private String contractAccountId = "";
        private boolean deleted = false;
        private AccountID proxyAccountId = null;
        private long proxyReceived = 0L;
        private Key key = null;
        private long balance = 0L;
        private boolean receiverSigRequired = false;
        private Timestamp expirationTime = null;
        private Duration autoRenewPeriod = null;
        private List<TokenRelationship> tokenRelationships = Collections.emptyList();
        private String memo = "";
        private long ownedNfts = 0L;
        private int maxAutomaticTokenAssociations = 0;
        private Bytes alias = Bytes.EMPTY;
        private Bytes ledgerId = Bytes.EMPTY;
        private List<GrantedCryptoAllowance> grantedCryptoAllowances = Collections.emptyList();
        private List<GrantedNftAllowance> grantedNftAllowances = Collections.emptyList();
        private List<GrantedTokenAllowance> grantedTokenAllowances = Collections.emptyList();

        public Builder() {
        }

        public Builder(AccountID accountId, String contractAccountId, boolean deleted, AccountID proxyAccountId, long proxyReceived, Key key, long balance, boolean receiverSigRequired, Timestamp expirationTime, Duration autoRenewPeriod, List<TokenRelationship> tokenRelationships, String memo, long ownedNfts, int maxAutomaticTokenAssociations, Bytes alias, Bytes ledgerId, List<GrantedCryptoAllowance> grantedCryptoAllowances, List<GrantedNftAllowance> grantedNftAllowances, List<GrantedTokenAllowance> grantedTokenAllowances) {
            this.accountId = accountId;
            this.contractAccountId = contractAccountId;
            this.deleted = deleted;
            this.proxyAccountId = proxyAccountId;
            this.proxyReceived = proxyReceived;
            this.key = key;
            this.balance = balance;
            this.receiverSigRequired = receiverSigRequired;
            this.expirationTime = expirationTime;
            this.autoRenewPeriod = autoRenewPeriod;
            this.tokenRelationships = tokenRelationships;
            this.memo = memo;
            this.ownedNfts = ownedNfts;
            this.maxAutomaticTokenAssociations = maxAutomaticTokenAssociations;
            this.alias = alias;
            this.ledgerId = ledgerId;
            this.grantedCryptoAllowances = grantedCryptoAllowances;
            this.grantedNftAllowances = grantedNftAllowances;
            this.grantedTokenAllowances = grantedTokenAllowances;
        }

        public AccountDetails build() {
            return new AccountDetails(this.accountId, this.contractAccountId, this.deleted, this.proxyAccountId, this.proxyReceived, this.key, this.balance, this.receiverSigRequired, this.expirationTime, this.autoRenewPeriod, this.tokenRelationships, this.memo, this.ownedNfts, this.maxAutomaticTokenAssociations, this.alias, this.ledgerId, this.grantedCryptoAllowances, this.grantedNftAllowances, this.grantedTokenAllowances);
        }

        public Builder accountId(AccountID accountId) {
            this.accountId = accountId;
            return this;
        }

        public Builder accountId(AccountID.Builder builder) {
            this.accountId = builder.build();
            return this;
        }

        public Builder contractAccountId(String contractAccountId) {
            this.contractAccountId = contractAccountId;
            return this;
        }

        public Builder deleted(boolean deleted) {
            this.deleted = deleted;
            return this;
        }

        public Builder proxyAccountId(AccountID proxyAccountId) {
            this.proxyAccountId = proxyAccountId;
            return this;
        }

        public Builder proxyAccountId(AccountID.Builder builder) {
            this.proxyAccountId = builder.build();
            return this;
        }

        public Builder proxyReceived(long proxyReceived) {
            this.proxyReceived = proxyReceived;
            return this;
        }

        public Builder key(Key key) {
            this.key = key;
            return this;
        }

        public Builder key(Key.Builder builder) {
            this.key = builder.build();
            return this;
        }

        public Builder balance(long balance) {
            this.balance = balance;
            return this;
        }

        public Builder receiverSigRequired(boolean receiverSigRequired) {
            this.receiverSigRequired = receiverSigRequired;
            return this;
        }

        public Builder expirationTime(Timestamp expirationTime) {
            this.expirationTime = expirationTime;
            return this;
        }

        public Builder expirationTime(Timestamp.Builder builder) {
            this.expirationTime = builder.build();
            return this;
        }

        public Builder autoRenewPeriod(Duration autoRenewPeriod) {
            this.autoRenewPeriod = autoRenewPeriod;
            return this;
        }

        public Builder autoRenewPeriod(Duration.Builder builder) {
            this.autoRenewPeriod = builder.build();
            return this;
        }

        public Builder tokenRelationships(List<TokenRelationship> tokenRelationships) {
            this.tokenRelationships = tokenRelationships;
            return this;
        }

        public Builder tokenRelationships(TokenRelationship ... values) {
            this.tokenRelationships = List.of(values);
            return this;
        }

        public Builder memo(String memo) {
            this.memo = memo;
            return this;
        }

        public Builder ownedNfts(long ownedNfts) {
            this.ownedNfts = ownedNfts;
            return this;
        }

        public Builder maxAutomaticTokenAssociations(int maxAutomaticTokenAssociations) {
            this.maxAutomaticTokenAssociations = maxAutomaticTokenAssociations;
            return this;
        }

        public Builder alias(Bytes alias) {
            this.alias = alias;
            return this;
        }

        public Builder ledgerId(Bytes ledgerId) {
            this.ledgerId = ledgerId;
            return this;
        }

        public Builder grantedCryptoAllowances(List<GrantedCryptoAllowance> grantedCryptoAllowances) {
            this.grantedCryptoAllowances = grantedCryptoAllowances;
            return this;
        }

        public Builder grantedCryptoAllowances(GrantedCryptoAllowance ... values) {
            this.grantedCryptoAllowances = List.of(values);
            return this;
        }

        public Builder grantedNftAllowances(List<GrantedNftAllowance> grantedNftAllowances) {
            this.grantedNftAllowances = grantedNftAllowances;
            return this;
        }

        public Builder grantedNftAllowances(GrantedNftAllowance ... values) {
            this.grantedNftAllowances = List.of(values);
            return this;
        }

        public Builder grantedTokenAllowances(List<GrantedTokenAllowance> grantedTokenAllowances) {
            this.grantedTokenAllowances = grantedTokenAllowances;
            return this;
        }

        public Builder grantedTokenAllowances(GrantedTokenAllowance ... values) {
            this.grantedTokenAllowances = List.of(values);
            return this;
        }
    }
}

