/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.token;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.token.ProxyStaker;
import com.hedera.hapi.node.token.codec.AllProxyStakersJsonCodec;
import com.hedera.hapi.node.token.codec.AllProxyStakersProtoCodec;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.JsonCodec;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;

public record AllProxyStakers(@Nullable AccountID accountID, @Nullable List<ProxyStaker> proxyStaker) {
    public static final Codec<AllProxyStakers> PROTOBUF = new AllProxyStakersProtoCodec();
    public static final JsonCodec<AllProxyStakers> JSON = new AllProxyStakersJsonCodec();
    public static final AllProxyStakers DEFAULT = AllProxyStakers.newBuilder().build();

    @Override
    public int hashCode() {
        List<ProxyStaker> list$proxyStaker;
        int result = 1;
        if (this.accountID != null && !this.accountID.equals(AllProxyStakers.DEFAULT.accountID)) {
            result = 31 * result + this.accountID.hashCode();
        }
        if ((list$proxyStaker = this.proxyStaker) != null) {
            for (ProxyStaker o : list$proxyStaker) {
                if (o != null) {
                    result = 31 * result + ((Object)o).hashCode();
                    continue;
                }
                result = 31 * result;
            }
        }
        long hashCode = result;
        hashCode += hashCode << 30;
        hashCode ^= hashCode >>> 27;
        hashCode += hashCode << 16;
        hashCode ^= hashCode >>> 20;
        hashCode += hashCode << 5;
        hashCode ^= hashCode >>> 18;
        hashCode += hashCode << 10;
        hashCode ^= hashCode >>> 24;
        hashCode += hashCode << 30;
        return (int)hashCode;
    }

    @Override
    public boolean equals(Object that) {
        if (that == null || this.getClass() != that.getClass()) {
            return false;
        }
        AllProxyStakers thatObj = (AllProxyStakers)that;
        if (this.accountID == null && thatObj.accountID != null) {
            return false;
        }
        if (this.accountID != null && !this.accountID.equals(thatObj.accountID)) {
            return false;
        }
        if (this.proxyStaker == null && thatObj.proxyStaker != null) {
            return false;
        }
        return this.proxyStaker == null || this.proxyStaker.equals(thatObj.proxyStaker);
    }

    public boolean hasAccountID() {
        return this.accountID != null;
    }

    public AccountID accountIDOrElse(@NonNull AccountID defaultValue) {
        return this.hasAccountID() ? this.accountID : defaultValue;
    }

    @NonNull
    public AccountID accountIDOrThrow() {
        return Objects.requireNonNull(this.accountID, "Field accountID is null");
    }

    public void ifAccountID(@NonNull Consumer<AccountID> ifPresent) {
        if (this.hasAccountID()) {
            ifPresent.accept(this.accountID);
        }
    }

    public boolean hasProxyStaker() {
        return this.proxyStaker != null;
    }

    public List<ProxyStaker> proxyStakerOrElse(@NonNull List<ProxyStaker> defaultValue) {
        return this.hasProxyStaker() ? this.proxyStaker : defaultValue;
    }

    @NonNull
    public List<ProxyStaker> proxyStakerOrThrow() {
        return Objects.requireNonNull(this.proxyStaker, "Field proxyStaker is null");
    }

    public void ifProxyStaker(@NonNull Consumer<List<ProxyStaker>> ifPresent) {
        if (this.hasProxyStaker()) {
            ifPresent.accept(this.proxyStaker);
        }
    }

    public Builder copyBuilder() {
        return new Builder(this.accountID, this.proxyStaker);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        private AccountID accountID = null;
        private List<ProxyStaker> proxyStaker = Collections.emptyList();

        public Builder() {
        }

        public Builder(AccountID accountID, List<ProxyStaker> proxyStaker) {
            this.accountID = accountID;
            this.proxyStaker = proxyStaker;
        }

        public AllProxyStakers build() {
            return new AllProxyStakers(this.accountID, this.proxyStaker);
        }

        public Builder accountID(AccountID accountID) {
            this.accountID = accountID;
            return this;
        }

        public Builder accountID(AccountID.Builder builder) {
            this.accountID = builder.build();
            return this;
        }

        public Builder proxyStaker(List<ProxyStaker> proxyStaker) {
            this.proxyStaker = proxyStaker;
            return this;
        }

        public Builder proxyStaker(ProxyStaker ... values) {
            this.proxyStaker = List.of(values);
            return this;
        }
    }
}

