/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.token;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.TokenID;
import com.hedera.hapi.node.token.codec.TokenAllowanceJsonCodec;
import com.hedera.hapi.node.token.codec.TokenAllowanceProtoCodec;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.JsonCodec;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Objects;
import java.util.function.Consumer;

public record TokenAllowance(@Nullable TokenID tokenId, @Nullable AccountID owner, @Nullable AccountID spender, long amount) {
    public static final Codec<TokenAllowance> PROTOBUF = new TokenAllowanceProtoCodec();
    public static final JsonCodec<TokenAllowance> JSON = new TokenAllowanceJsonCodec();
    public static final TokenAllowance DEFAULT = TokenAllowance.newBuilder().build();

    @Override
    public int hashCode() {
        int result = 1;
        if (this.tokenId != null && !this.tokenId.equals(TokenAllowance.DEFAULT.tokenId)) {
            result = 31 * result + this.tokenId.hashCode();
        }
        if (this.owner != null && !this.owner.equals(TokenAllowance.DEFAULT.owner)) {
            result = 31 * result + this.owner.hashCode();
        }
        if (this.spender != null && !this.spender.equals(TokenAllowance.DEFAULT.spender)) {
            result = 31 * result + this.spender.hashCode();
        }
        if (this.amount != TokenAllowance.DEFAULT.amount) {
            result = 31 * result + Long.hashCode(this.amount);
        }
        long hashCode = result;
        hashCode += hashCode << 30;
        hashCode ^= hashCode >>> 27;
        hashCode += hashCode << 16;
        hashCode ^= hashCode >>> 20;
        hashCode += hashCode << 5;
        hashCode ^= hashCode >>> 18;
        hashCode += hashCode << 10;
        hashCode ^= hashCode >>> 24;
        hashCode += hashCode << 30;
        return (int)hashCode;
    }

    @Override
    public boolean equals(Object that) {
        if (that == null || this.getClass() != that.getClass()) {
            return false;
        }
        TokenAllowance thatObj = (TokenAllowance)that;
        if (this.tokenId == null && thatObj.tokenId != null) {
            return false;
        }
        if (this.tokenId != null && !this.tokenId.equals(thatObj.tokenId)) {
            return false;
        }
        if (this.owner == null && thatObj.owner != null) {
            return false;
        }
        if (this.owner != null && !this.owner.equals(thatObj.owner)) {
            return false;
        }
        if (this.spender == null && thatObj.spender != null) {
            return false;
        }
        if (this.spender != null && !this.spender.equals(thatObj.spender)) {
            return false;
        }
        return this.amount == thatObj.amount;
    }

    public boolean hasTokenId() {
        return this.tokenId != null;
    }

    public TokenID tokenIdOrElse(@NonNull TokenID defaultValue) {
        return this.hasTokenId() ? this.tokenId : defaultValue;
    }

    @NonNull
    public TokenID tokenIdOrThrow() {
        return Objects.requireNonNull(this.tokenId, "Field tokenId is null");
    }

    public void ifTokenId(@NonNull Consumer<TokenID> ifPresent) {
        if (this.hasTokenId()) {
            ifPresent.accept(this.tokenId);
        }
    }

    public boolean hasOwner() {
        return this.owner != null;
    }

    public AccountID ownerOrElse(@NonNull AccountID defaultValue) {
        return this.hasOwner() ? this.owner : defaultValue;
    }

    @NonNull
    public AccountID ownerOrThrow() {
        return Objects.requireNonNull(this.owner, "Field owner is null");
    }

    public void ifOwner(@NonNull Consumer<AccountID> ifPresent) {
        if (this.hasOwner()) {
            ifPresent.accept(this.owner);
        }
    }

    public boolean hasSpender() {
        return this.spender != null;
    }

    public AccountID spenderOrElse(@NonNull AccountID defaultValue) {
        return this.hasSpender() ? this.spender : defaultValue;
    }

    @NonNull
    public AccountID spenderOrThrow() {
        return Objects.requireNonNull(this.spender, "Field spender is null");
    }

    public void ifSpender(@NonNull Consumer<AccountID> ifPresent) {
        if (this.hasSpender()) {
            ifPresent.accept(this.spender);
        }
    }

    public Builder copyBuilder() {
        return new Builder(this.tokenId, this.owner, this.spender, this.amount);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        private TokenID tokenId = null;
        private AccountID owner = null;
        private AccountID spender = null;
        private long amount = 0L;

        public Builder() {
        }

        public Builder(TokenID tokenId, AccountID owner, AccountID spender, long amount) {
            this.tokenId = tokenId;
            this.owner = owner;
            this.spender = spender;
            this.amount = amount;
        }

        public TokenAllowance build() {
            return new TokenAllowance(this.tokenId, this.owner, this.spender, this.amount);
        }

        public Builder tokenId(TokenID tokenId) {
            this.tokenId = tokenId;
            return this;
        }

        public Builder tokenId(TokenID.Builder builder) {
            this.tokenId = builder.build();
            return this;
        }

        public Builder owner(AccountID owner) {
            this.owner = owner;
            return this;
        }

        public Builder owner(AccountID.Builder builder) {
            this.owner = builder.build();
            return this;
        }

        public Builder spender(AccountID spender) {
            this.spender = spender;
            return this;
        }

        public Builder spender(AccountID.Builder builder) {
            this.spender = builder.build();
            return this;
        }

        public Builder amount(long amount) {
            this.amount = amount;
            return this;
        }
    }
}

