/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.token;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.NftID;
import com.hedera.hapi.node.base.Timestamp;
import com.hedera.hapi.node.token.codec.TokenNftInfoJsonCodec;
import com.hedera.hapi.node.token.codec.TokenNftInfoProtoCodec;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.JsonCodec;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Objects;
import java.util.function.Consumer;

public record TokenNftInfo(@Nullable NftID nftID, @Nullable AccountID accountID, @Nullable Timestamp creationTime, Bytes metadata, Bytes ledgerId, @Nullable AccountID spenderId) {
    public static final Codec<TokenNftInfo> PROTOBUF = new TokenNftInfoProtoCodec();
    public static final JsonCodec<TokenNftInfo> JSON = new TokenNftInfoJsonCodec();
    public static final TokenNftInfo DEFAULT = TokenNftInfo.newBuilder().build();

    @Override
    public int hashCode() {
        int result = 1;
        if (this.nftID != null && !this.nftID.equals(TokenNftInfo.DEFAULT.nftID)) {
            result = 31 * result + this.nftID.hashCode();
        }
        if (this.accountID != null && !this.accountID.equals(TokenNftInfo.DEFAULT.accountID)) {
            result = 31 * result + this.accountID.hashCode();
        }
        if (this.creationTime != null && !this.creationTime.equals(TokenNftInfo.DEFAULT.creationTime)) {
            result = 31 * result + this.creationTime.hashCode();
        }
        if (this.metadata != null && !this.metadata.equals((Object)TokenNftInfo.DEFAULT.metadata)) {
            result = 31 * result + this.metadata.hashCode();
        }
        if (this.ledgerId != null && !this.ledgerId.equals((Object)TokenNftInfo.DEFAULT.ledgerId)) {
            result = 31 * result + this.ledgerId.hashCode();
        }
        if (this.spenderId != null && !this.spenderId.equals(TokenNftInfo.DEFAULT.spenderId)) {
            result = 31 * result + this.spenderId.hashCode();
        }
        long hashCode = result;
        hashCode += hashCode << 30;
        hashCode ^= hashCode >>> 27;
        hashCode += hashCode << 16;
        hashCode ^= hashCode >>> 20;
        hashCode += hashCode << 5;
        hashCode ^= hashCode >>> 18;
        hashCode += hashCode << 10;
        hashCode ^= hashCode >>> 24;
        hashCode += hashCode << 30;
        return (int)hashCode;
    }

    @Override
    public boolean equals(Object that) {
        if (that == null || this.getClass() != that.getClass()) {
            return false;
        }
        TokenNftInfo thatObj = (TokenNftInfo)that;
        if (this.nftID == null && thatObj.nftID != null) {
            return false;
        }
        if (this.nftID != null && !this.nftID.equals(thatObj.nftID)) {
            return false;
        }
        if (this.accountID == null && thatObj.accountID != null) {
            return false;
        }
        if (this.accountID != null && !this.accountID.equals(thatObj.accountID)) {
            return false;
        }
        if (this.creationTime == null && thatObj.creationTime != null) {
            return false;
        }
        if (this.creationTime != null && !this.creationTime.equals(thatObj.creationTime)) {
            return false;
        }
        if (this.metadata == null && thatObj.metadata != null) {
            return false;
        }
        if (this.metadata != null && !this.metadata.equals((Object)thatObj.metadata)) {
            return false;
        }
        if (this.ledgerId == null && thatObj.ledgerId != null) {
            return false;
        }
        if (this.ledgerId != null && !this.ledgerId.equals((Object)thatObj.ledgerId)) {
            return false;
        }
        if (this.spenderId == null && thatObj.spenderId != null) {
            return false;
        }
        return this.spenderId == null || this.spenderId.equals(thatObj.spenderId);
    }

    public boolean hasNftID() {
        return this.nftID != null;
    }

    public NftID nftIDOrElse(@NonNull NftID defaultValue) {
        return this.hasNftID() ? this.nftID : defaultValue;
    }

    @NonNull
    public NftID nftIDOrThrow() {
        return Objects.requireNonNull(this.nftID, "Field nftID is null");
    }

    public void ifNftID(@NonNull Consumer<NftID> ifPresent) {
        if (this.hasNftID()) {
            ifPresent.accept(this.nftID);
        }
    }

    public boolean hasAccountID() {
        return this.accountID != null;
    }

    public AccountID accountIDOrElse(@NonNull AccountID defaultValue) {
        return this.hasAccountID() ? this.accountID : defaultValue;
    }

    @NonNull
    public AccountID accountIDOrThrow() {
        return Objects.requireNonNull(this.accountID, "Field accountID is null");
    }

    public void ifAccountID(@NonNull Consumer<AccountID> ifPresent) {
        if (this.hasAccountID()) {
            ifPresent.accept(this.accountID);
        }
    }

    public boolean hasCreationTime() {
        return this.creationTime != null;
    }

    public Timestamp creationTimeOrElse(@NonNull Timestamp defaultValue) {
        return this.hasCreationTime() ? this.creationTime : defaultValue;
    }

    @NonNull
    public Timestamp creationTimeOrThrow() {
        return Objects.requireNonNull(this.creationTime, "Field creationTime is null");
    }

    public void ifCreationTime(@NonNull Consumer<Timestamp> ifPresent) {
        if (this.hasCreationTime()) {
            ifPresent.accept(this.creationTime);
        }
    }

    public boolean hasSpenderId() {
        return this.spenderId != null;
    }

    public AccountID spenderIdOrElse(@NonNull AccountID defaultValue) {
        return this.hasSpenderId() ? this.spenderId : defaultValue;
    }

    @NonNull
    public AccountID spenderIdOrThrow() {
        return Objects.requireNonNull(this.spenderId, "Field spenderId is null");
    }

    public void ifSpenderId(@NonNull Consumer<AccountID> ifPresent) {
        if (this.hasSpenderId()) {
            ifPresent.accept(this.spenderId);
        }
    }

    public Builder copyBuilder() {
        return new Builder(this.nftID, this.accountID, this.creationTime, this.metadata, this.ledgerId, this.spenderId);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        private NftID nftID = null;
        private AccountID accountID = null;
        private Timestamp creationTime = null;
        private Bytes metadata = Bytes.EMPTY;
        private Bytes ledgerId = Bytes.EMPTY;
        private AccountID spenderId = null;

        public Builder() {
        }

        public Builder(NftID nftID, AccountID accountID, Timestamp creationTime, Bytes metadata, Bytes ledgerId, AccountID spenderId) {
            this.nftID = nftID;
            this.accountID = accountID;
            this.creationTime = creationTime;
            this.metadata = metadata;
            this.ledgerId = ledgerId;
            this.spenderId = spenderId;
        }

        public TokenNftInfo build() {
            return new TokenNftInfo(this.nftID, this.accountID, this.creationTime, this.metadata, this.ledgerId, this.spenderId);
        }

        public Builder nftID(NftID nftID) {
            this.nftID = nftID;
            return this;
        }

        public Builder nftID(NftID.Builder builder) {
            this.nftID = builder.build();
            return this;
        }

        public Builder accountID(AccountID accountID) {
            this.accountID = accountID;
            return this;
        }

        public Builder accountID(AccountID.Builder builder) {
            this.accountID = builder.build();
            return this;
        }

        public Builder creationTime(Timestamp creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public Builder creationTime(Timestamp.Builder builder) {
            this.creationTime = builder.build();
            return this;
        }

        public Builder metadata(Bytes metadata) {
            this.metadata = metadata;
            return this;
        }

        public Builder ledgerId(Bytes ledgerId) {
            this.ledgerId = ledgerId;
            return this;
        }

        public Builder spenderId(AccountID spenderId) {
            this.spenderId = spenderId;
            return this;
        }

        public Builder spenderId(AccountID.Builder builder) {
            this.spenderId = builder.build();
            return this;
        }
    }
}

