/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.token.codec;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.Duration;
import com.hedera.hapi.node.base.KeyList;
import com.hedera.hapi.node.token.LiveHash;
import com.hedera.hapi.node.token.schema.LiveHashSchema;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.FieldDefinition;
import com.hedera.pbj.runtime.ProtoConstants;
import com.hedera.pbj.runtime.ProtoParserTools;
import com.hedera.pbj.runtime.ProtoWriterTools;
import com.hedera.pbj.runtime.UnknownFieldException;
import com.hedera.pbj.runtime.io.ReadableSequentialData;
import com.hedera.pbj.runtime.io.WritableSequentialData;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.hedera.pbj.runtime.io.buffer.RandomAccessData;
import com.hedera.pbj.runtime.io.stream.EOFException;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;

public final class LiveHashProtoCodec
implements Codec<LiveHash> {
    @NonNull
    public LiveHash parse(@NonNull ReadableSequentialData input) throws IOException {
        return this.parseInternal(input, false);
    }

    @NonNull
    public LiveHash parseStrict(@NonNull ReadableSequentialData input) throws IOException {
        return this.parseInternal(input, true);
    }

    public void write(@NonNull LiveHash data, @NonNull WritableSequentialData out) throws IOException {
        ProtoWriterTools.writeMessage((WritableSequentialData)out, (FieldDefinition)LiveHashSchema.ACCOUNT_ID, (Object)data.accountId(), (arg_0, arg_1) -> AccountID.PROTOBUF.write(arg_0, arg_1), arg_0 -> AccountID.PROTOBUF.measureRecord(arg_0));
        ProtoWriterTools.writeBytes((WritableSequentialData)out, (FieldDefinition)LiveHashSchema.HASH, (RandomAccessData)data.hash());
        ProtoWriterTools.writeMessage((WritableSequentialData)out, (FieldDefinition)LiveHashSchema.KEYS, (Object)data.keys(), (arg_0, arg_1) -> KeyList.PROTOBUF.write(arg_0, arg_1), arg_0 -> KeyList.PROTOBUF.measureRecord(arg_0));
        ProtoWriterTools.writeMessage((WritableSequentialData)out, (FieldDefinition)LiveHashSchema.DURATION, (Object)data.duration(), (arg_0, arg_1) -> Duration.PROTOBUF.write(arg_0, arg_1), arg_0 -> Duration.PROTOBUF.measureRecord(arg_0));
    }

    public int measure(@NonNull ReadableSequentialData input) throws IOException {
        long start = input.position();
        this.parse(input);
        long end = input.position();
        return (int)(end - start);
    }

    public int measureRecord(LiveHash data) {
        int size = 0;
        size += ProtoWriterTools.sizeOfMessage((FieldDefinition)LiveHashSchema.ACCOUNT_ID, (Object)data.accountId(), arg_0 -> AccountID.PROTOBUF.measureRecord(arg_0));
        size += ProtoWriterTools.sizeOfBytes((FieldDefinition)LiveHashSchema.HASH, (RandomAccessData)data.hash());
        size += ProtoWriterTools.sizeOfMessage((FieldDefinition)LiveHashSchema.KEYS, (Object)data.keys(), arg_0 -> KeyList.PROTOBUF.measureRecord(arg_0));
        return size += ProtoWriterTools.sizeOfMessage((FieldDefinition)LiveHashSchema.DURATION, (Object)data.duration(), arg_0 -> Duration.PROTOBUF.measureRecord(arg_0));
    }

    public boolean fastEquals(@NonNull LiveHash item, @NonNull ReadableSequentialData input) throws IOException {
        return item.equals(this.parse(input));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NonNull
    private LiveHash parseInternal(@NonNull ReadableSequentialData input, boolean strictMode) throws IOException {
        temp_accountId /* !! */  = null;
        temp_hash = Bytes.EMPTY;
        temp_keys /* !! */  = null;
        temp_duration /* !! */  = null;
        try {
            block17: while (input.hasRemaining() != false) {
                tag = input.readVarInt(false);
                field = tag >>> 3;
                f = LiveHashSchema.getField(field);
                switch (tag) {
                    case 10: {
                        messageLength = input.readVarInt(false);
                        if (messageLength != 0) ** GOTO lbl16
                        value /* !! */  = AccountID.DEFAULT;
                        ** GOTO lbl29
lbl16:
                        // 1 sources

                        limitBefore = input.limit();
                        startPos = input.position();
                        try {
                            if (startPos + (long)messageLength > limitBefore) {
                                throw new BufferUnderflowException();
                            }
                            input.limit(startPos + (long)messageLength);
                            v0 = value /* !! */  = strictMode != false ? (AccountID)AccountID.PROTOBUF.parseStrict(input) : (AccountID)AccountID.PROTOBUF.parse(input);
                            if (startPos + (long)messageLength != input.position()) {
                                throw new BufferOverflowException();
                            }
                        }
                        finally {
                            input.limit(limitBefore);
                        }
lbl29:
                        // 2 sources

                        temp_accountId /* !! */  = value /* !! */ ;
                        continue block17;
                    }
                    case 18: {
                        temp_hash = value = ProtoParserTools.readBytes((ReadableSequentialData)input);
                        continue block17;
                    }
                    case 26: {
                        messageLength = input.readVarInt(false);
                        if (messageLength != 0) ** GOTO lbl39
                        value /* !! */  = KeyList.DEFAULT;
                        ** GOTO lbl52
lbl39:
                        // 1 sources

                        limitBefore = input.limit();
                        startPos = input.position();
                        try {
                            if (startPos + (long)messageLength > limitBefore) {
                                throw new BufferUnderflowException();
                            }
                            input.limit(startPos + (long)messageLength);
                            v1 /* !! */  = value /* !! */  = strictMode != false ? (KeyList)KeyList.PROTOBUF.parseStrict(input) : (KeyList)KeyList.PROTOBUF.parse(input);
                            if (startPos + (long)messageLength != input.position()) {
                                throw new BufferOverflowException();
                            }
                        }
                        finally {
                            input.limit(limitBefore);
                        }
lbl52:
                        // 2 sources

                        temp_keys /* !! */  = value /* !! */ ;
                        continue block17;
                    }
                    case 42: {
                        messageLength = input.readVarInt(false);
                        if (messageLength != 0) ** GOTO lbl59
                        value /* !! */  = Duration.DEFAULT;
                        ** GOTO lbl72
lbl59:
                        // 1 sources

                        limitBefore = input.limit();
                        startPos = input.position();
                        try {
                            if (startPos + (long)messageLength > limitBefore) {
                                throw new BufferUnderflowException();
                            }
                            input.limit(startPos + (long)messageLength);
                            v2 /* !! */  = value /* !! */  = strictMode != false ? (Duration)Duration.PROTOBUF.parseStrict(input) : (Duration)Duration.PROTOBUF.parse(input);
                            if (startPos + (long)messageLength != input.position()) {
                                throw new BufferOverflowException();
                            }
                        }
                        finally {
                            input.limit(limitBefore);
                        }
lbl72:
                        // 2 sources

                        temp_duration /* !! */  = value /* !! */ ;
                        continue block17;
                    }
                }
                wireType = tag & 7;
                if (field == 0) {
                    throw new IOException("Bad protobuf encoding. We read a field value of " + field);
                }
                if (wireType > 5) {
                    throw new IOException("Cannot understand wire_type of " + wireType);
                }
                if (f != null) throw new IOException("Bad tag [" + tag + "], field [" + field + "] wireType [" + wireType + "]");
                if (strictMode) {
                    throw new UnknownFieldException(field);
                }
                ProtoParserTools.skipField((ReadableSequentialData)input, (ProtoConstants)ProtoConstants.get((int)wireType));
            }
            return new LiveHash(temp_accountId /* !! */ , temp_hash, (KeyList)temp_keys /* !! */ , (Duration)temp_duration /* !! */ );
        }
        catch (EOFException var7_8) {
            // empty catch block
        }
        return new LiveHash(temp_accountId /* !! */ , temp_hash, (KeyList)temp_keys /* !! */ , (Duration)temp_duration /* !! */ );
    }
}

