/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.transaction;

import com.hedera.hapi.node.base.TimestampSeconds;
import com.hedera.hapi.node.transaction.codec.ExchangeRateJsonCodec;
import com.hedera.hapi.node.transaction.codec.ExchangeRateProtoCodec;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.JsonCodec;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Objects;
import java.util.function.Consumer;

public record ExchangeRate(int hbarEquiv, int centEquiv, @Nullable TimestampSeconds expirationTime) {
    public static final Codec<ExchangeRate> PROTOBUF = new ExchangeRateProtoCodec();
    public static final JsonCodec<ExchangeRate> JSON = new ExchangeRateJsonCodec();
    public static final ExchangeRate DEFAULT = ExchangeRate.newBuilder().build();

    @Override
    public int hashCode() {
        int result = 1;
        if (this.hbarEquiv != ExchangeRate.DEFAULT.hbarEquiv) {
            result = 31 * result + Integer.hashCode(this.hbarEquiv);
        }
        if (this.centEquiv != ExchangeRate.DEFAULT.centEquiv) {
            result = 31 * result + Integer.hashCode(this.centEquiv);
        }
        if (this.expirationTime != null && !this.expirationTime.equals(ExchangeRate.DEFAULT.expirationTime)) {
            result = 31 * result + this.expirationTime.hashCode();
        }
        long hashCode = result;
        hashCode += hashCode << 30;
        hashCode ^= hashCode >>> 27;
        hashCode += hashCode << 16;
        hashCode ^= hashCode >>> 20;
        hashCode += hashCode << 5;
        hashCode ^= hashCode >>> 18;
        hashCode += hashCode << 10;
        hashCode ^= hashCode >>> 24;
        hashCode += hashCode << 30;
        return (int)hashCode;
    }

    @Override
    public boolean equals(Object that) {
        if (that == null || this.getClass() != that.getClass()) {
            return false;
        }
        ExchangeRate thatObj = (ExchangeRate)that;
        if (this.hbarEquiv != thatObj.hbarEquiv) {
            return false;
        }
        if (this.centEquiv != thatObj.centEquiv) {
            return false;
        }
        if (this.expirationTime == null && thatObj.expirationTime != null) {
            return false;
        }
        return this.expirationTime == null || this.expirationTime.equals(thatObj.expirationTime);
    }

    public boolean hasExpirationTime() {
        return this.expirationTime != null;
    }

    public TimestampSeconds expirationTimeOrElse(@NonNull TimestampSeconds defaultValue) {
        return this.hasExpirationTime() ? this.expirationTime : defaultValue;
    }

    @NonNull
    public TimestampSeconds expirationTimeOrThrow() {
        return Objects.requireNonNull(this.expirationTime, "Field expirationTime is null");
    }

    public void ifExpirationTime(@NonNull Consumer<TimestampSeconds> ifPresent) {
        if (this.hasExpirationTime()) {
            ifPresent.accept(this.expirationTime);
        }
    }

    public Builder copyBuilder() {
        return new Builder(this.hbarEquiv, this.centEquiv, this.expirationTime);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        private int hbarEquiv = 0;
        private int centEquiv = 0;
        private TimestampSeconds expirationTime = null;

        public Builder() {
        }

        public Builder(int hbarEquiv, int centEquiv, TimestampSeconds expirationTime) {
            this.hbarEquiv = hbarEquiv;
            this.centEquiv = centEquiv;
            this.expirationTime = expirationTime;
        }

        public ExchangeRate build() {
            return new ExchangeRate(this.hbarEquiv, this.centEquiv, this.expirationTime);
        }

        public Builder hbarEquiv(int hbarEquiv) {
            this.hbarEquiv = hbarEquiv;
            return this;
        }

        public Builder centEquiv(int centEquiv) {
            this.centEquiv = centEquiv;
            return this;
        }

        public Builder expirationTime(TimestampSeconds expirationTime) {
            this.expirationTime = expirationTime;
            return this;
        }

        public Builder expirationTime(TimestampSeconds.Builder builder) {
            this.expirationTime = builder.build();
            return this;
        }
    }
}

