/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.transaction;

import com.hedera.hapi.node.transaction.ExchangeRate;
import com.hedera.hapi.node.transaction.codec.ExchangeRateSetJsonCodec;
import com.hedera.hapi.node.transaction.codec.ExchangeRateSetProtoCodec;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.JsonCodec;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Objects;
import java.util.function.Consumer;

public record ExchangeRateSet(@Nullable ExchangeRate currentRate, @Nullable ExchangeRate nextRate) {
    public static final Codec<ExchangeRateSet> PROTOBUF = new ExchangeRateSetProtoCodec();
    public static final JsonCodec<ExchangeRateSet> JSON = new ExchangeRateSetJsonCodec();
    public static final ExchangeRateSet DEFAULT = ExchangeRateSet.newBuilder().build();

    @Override
    public int hashCode() {
        int result = 1;
        if (this.currentRate != null && !this.currentRate.equals(ExchangeRateSet.DEFAULT.currentRate)) {
            result = 31 * result + this.currentRate.hashCode();
        }
        if (this.nextRate != null && !this.nextRate.equals(ExchangeRateSet.DEFAULT.nextRate)) {
            result = 31 * result + this.nextRate.hashCode();
        }
        long hashCode = result;
        hashCode += hashCode << 30;
        hashCode ^= hashCode >>> 27;
        hashCode += hashCode << 16;
        hashCode ^= hashCode >>> 20;
        hashCode += hashCode << 5;
        hashCode ^= hashCode >>> 18;
        hashCode += hashCode << 10;
        hashCode ^= hashCode >>> 24;
        hashCode += hashCode << 30;
        return (int)hashCode;
    }

    @Override
    public boolean equals(Object that) {
        if (that == null || this.getClass() != that.getClass()) {
            return false;
        }
        ExchangeRateSet thatObj = (ExchangeRateSet)that;
        if (this.currentRate == null && thatObj.currentRate != null) {
            return false;
        }
        if (this.currentRate != null && !this.currentRate.equals(thatObj.currentRate)) {
            return false;
        }
        if (this.nextRate == null && thatObj.nextRate != null) {
            return false;
        }
        return this.nextRate == null || this.nextRate.equals(thatObj.nextRate);
    }

    public boolean hasCurrentRate() {
        return this.currentRate != null;
    }

    public ExchangeRate currentRateOrElse(@NonNull ExchangeRate defaultValue) {
        return this.hasCurrentRate() ? this.currentRate : defaultValue;
    }

    @NonNull
    public ExchangeRate currentRateOrThrow() {
        return Objects.requireNonNull(this.currentRate, "Field currentRate is null");
    }

    public void ifCurrentRate(@NonNull Consumer<ExchangeRate> ifPresent) {
        if (this.hasCurrentRate()) {
            ifPresent.accept(this.currentRate);
        }
    }

    public boolean hasNextRate() {
        return this.nextRate != null;
    }

    public ExchangeRate nextRateOrElse(@NonNull ExchangeRate defaultValue) {
        return this.hasNextRate() ? this.nextRate : defaultValue;
    }

    @NonNull
    public ExchangeRate nextRateOrThrow() {
        return Objects.requireNonNull(this.nextRate, "Field nextRate is null");
    }

    public void ifNextRate(@NonNull Consumer<ExchangeRate> ifPresent) {
        if (this.hasNextRate()) {
            ifPresent.accept(this.nextRate);
        }
    }

    public Builder copyBuilder() {
        return new Builder(this.currentRate, this.nextRate);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        private ExchangeRate currentRate = null;
        private ExchangeRate nextRate = null;

        public Builder() {
        }

        public Builder(ExchangeRate currentRate, ExchangeRate nextRate) {
            this.currentRate = currentRate;
            this.nextRate = nextRate;
        }

        public ExchangeRateSet build() {
            return new ExchangeRateSet(this.currentRate, this.nextRate);
        }

        public Builder currentRate(ExchangeRate currentRate) {
            this.currentRate = currentRate;
            return this;
        }

        public Builder currentRate(ExchangeRate.Builder builder) {
            this.currentRate = builder.build();
            return this;
        }

        public Builder nextRate(ExchangeRate nextRate) {
            this.nextRate = nextRate;
            return this;
        }

        public Builder nextRate(ExchangeRate.Builder builder) {
            this.nextRate = builder.build();
            return this;
        }
    }
}

