/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.transaction;

import com.hedera.hapi.node.base.TokenID;
import com.hedera.hapi.node.transaction.codec.FixedFeeJsonCodec;
import com.hedera.hapi.node.transaction.codec.FixedFeeProtoCodec;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.JsonCodec;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Objects;
import java.util.function.Consumer;

public record FixedFee(long amount, @Nullable TokenID denominatingTokenId) {
    public static final Codec<FixedFee> PROTOBUF = new FixedFeeProtoCodec();
    public static final JsonCodec<FixedFee> JSON = new FixedFeeJsonCodec();
    public static final FixedFee DEFAULT = FixedFee.newBuilder().build();

    @Override
    public int hashCode() {
        int result = 1;
        if (this.amount != FixedFee.DEFAULT.amount) {
            result = 31 * result + Long.hashCode(this.amount);
        }
        if (this.denominatingTokenId != null && !this.denominatingTokenId.equals(FixedFee.DEFAULT.denominatingTokenId)) {
            result = 31 * result + this.denominatingTokenId.hashCode();
        }
        long hashCode = result;
        hashCode += hashCode << 30;
        hashCode ^= hashCode >>> 27;
        hashCode += hashCode << 16;
        hashCode ^= hashCode >>> 20;
        hashCode += hashCode << 5;
        hashCode ^= hashCode >>> 18;
        hashCode += hashCode << 10;
        hashCode ^= hashCode >>> 24;
        hashCode += hashCode << 30;
        return (int)hashCode;
    }

    @Override
    public boolean equals(Object that) {
        if (that == null || this.getClass() != that.getClass()) {
            return false;
        }
        FixedFee thatObj = (FixedFee)that;
        if (this.amount != thatObj.amount) {
            return false;
        }
        if (this.denominatingTokenId == null && thatObj.denominatingTokenId != null) {
            return false;
        }
        return this.denominatingTokenId == null || this.denominatingTokenId.equals(thatObj.denominatingTokenId);
    }

    public boolean hasDenominatingTokenId() {
        return this.denominatingTokenId != null;
    }

    public TokenID denominatingTokenIdOrElse(@NonNull TokenID defaultValue) {
        return this.hasDenominatingTokenId() ? this.denominatingTokenId : defaultValue;
    }

    @NonNull
    public TokenID denominatingTokenIdOrThrow() {
        return Objects.requireNonNull(this.denominatingTokenId, "Field denominatingTokenId is null");
    }

    public void ifDenominatingTokenId(@NonNull Consumer<TokenID> ifPresent) {
        if (this.hasDenominatingTokenId()) {
            ifPresent.accept(this.denominatingTokenId);
        }
    }

    public Builder copyBuilder() {
        return new Builder(this.amount, this.denominatingTokenId);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        private long amount = 0L;
        private TokenID denominatingTokenId = null;

        public Builder() {
        }

        public Builder(long amount, TokenID denominatingTokenId) {
            this.amount = amount;
            this.denominatingTokenId = denominatingTokenId;
        }

        public FixedFee build() {
            return new FixedFee(this.amount, this.denominatingTokenId);
        }

        public Builder amount(long amount) {
            this.amount = amount;
            return this;
        }

        public Builder denominatingTokenId(TokenID denominatingTokenId) {
            this.denominatingTokenId = denominatingTokenId;
            return this;
        }

        public Builder denominatingTokenId(TokenID.Builder builder) {
            this.denominatingTokenId = builder.build();
            return this;
        }
    }
}

