/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.transaction;

import com.hedera.hapi.node.base.Fraction;
import com.hedera.hapi.node.base.Timestamp;
import com.hedera.hapi.node.transaction.NodeStake;
import com.hedera.hapi.node.transaction.codec.NodeStakeUpdateTransactionBodyJsonCodec;
import com.hedera.hapi.node.transaction.codec.NodeStakeUpdateTransactionBodyProtoCodec;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.JsonCodec;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;

public record NodeStakeUpdateTransactionBody(@Nullable Timestamp endOfStakingPeriod, @Nullable List<NodeStake> nodeStake, long maxStakingRewardRatePerHbar, @Nullable Fraction nodeRewardFeeFraction, long stakingPeriodsStored, long stakingPeriod, @Nullable Fraction stakingRewardFeeFraction, long stakingStartThreshold, long stakingRewardRate, long reservedStakingRewards, long unreservedStakingRewardBalance, long rewardBalanceThreshold, long maxStakeRewarded, long maxTotalReward) {
    public static final Codec<NodeStakeUpdateTransactionBody> PROTOBUF = new NodeStakeUpdateTransactionBodyProtoCodec();
    public static final JsonCodec<NodeStakeUpdateTransactionBody> JSON = new NodeStakeUpdateTransactionBodyJsonCodec();
    public static final NodeStakeUpdateTransactionBody DEFAULT = NodeStakeUpdateTransactionBody.newBuilder().build();

    @Override
    public int hashCode() {
        List<NodeStake> list$nodeStake;
        int result = 1;
        if (this.endOfStakingPeriod != null && !this.endOfStakingPeriod.equals(NodeStakeUpdateTransactionBody.DEFAULT.endOfStakingPeriod)) {
            result = 31 * result + this.endOfStakingPeriod.hashCode();
        }
        if ((list$nodeStake = this.nodeStake) != null) {
            for (NodeStake o : list$nodeStake) {
                if (o != null) {
                    result = 31 * result + ((Object)o).hashCode();
                    continue;
                }
                result = 31 * result;
            }
        }
        if (this.maxStakingRewardRatePerHbar != NodeStakeUpdateTransactionBody.DEFAULT.maxStakingRewardRatePerHbar) {
            result = 31 * result + Long.hashCode(this.maxStakingRewardRatePerHbar);
        }
        if (this.nodeRewardFeeFraction != null && !this.nodeRewardFeeFraction.equals(NodeStakeUpdateTransactionBody.DEFAULT.nodeRewardFeeFraction)) {
            result = 31 * result + this.nodeRewardFeeFraction.hashCode();
        }
        if (this.stakingPeriodsStored != NodeStakeUpdateTransactionBody.DEFAULT.stakingPeriodsStored) {
            result = 31 * result + Long.hashCode(this.stakingPeriodsStored);
        }
        if (this.stakingPeriod != NodeStakeUpdateTransactionBody.DEFAULT.stakingPeriod) {
            result = 31 * result + Long.hashCode(this.stakingPeriod);
        }
        if (this.stakingRewardFeeFraction != null && !this.stakingRewardFeeFraction.equals(NodeStakeUpdateTransactionBody.DEFAULT.stakingRewardFeeFraction)) {
            result = 31 * result + this.stakingRewardFeeFraction.hashCode();
        }
        if (this.stakingStartThreshold != NodeStakeUpdateTransactionBody.DEFAULT.stakingStartThreshold) {
            result = 31 * result + Long.hashCode(this.stakingStartThreshold);
        }
        if (this.stakingRewardRate != NodeStakeUpdateTransactionBody.DEFAULT.stakingRewardRate) {
            result = 31 * result + Long.hashCode(this.stakingRewardRate);
        }
        if (this.reservedStakingRewards != NodeStakeUpdateTransactionBody.DEFAULT.reservedStakingRewards) {
            result = 31 * result + Long.hashCode(this.reservedStakingRewards);
        }
        if (this.unreservedStakingRewardBalance != NodeStakeUpdateTransactionBody.DEFAULT.unreservedStakingRewardBalance) {
            result = 31 * result + Long.hashCode(this.unreservedStakingRewardBalance);
        }
        if (this.rewardBalanceThreshold != NodeStakeUpdateTransactionBody.DEFAULT.rewardBalanceThreshold) {
            result = 31 * result + Long.hashCode(this.rewardBalanceThreshold);
        }
        if (this.maxStakeRewarded != NodeStakeUpdateTransactionBody.DEFAULT.maxStakeRewarded) {
            result = 31 * result + Long.hashCode(this.maxStakeRewarded);
        }
        if (this.maxTotalReward != NodeStakeUpdateTransactionBody.DEFAULT.maxTotalReward) {
            result = 31 * result + Long.hashCode(this.maxTotalReward);
        }
        long hashCode = result;
        hashCode += hashCode << 30;
        hashCode ^= hashCode >>> 27;
        hashCode += hashCode << 16;
        hashCode ^= hashCode >>> 20;
        hashCode += hashCode << 5;
        hashCode ^= hashCode >>> 18;
        hashCode += hashCode << 10;
        hashCode ^= hashCode >>> 24;
        hashCode += hashCode << 30;
        return (int)hashCode;
    }

    @Override
    public boolean equals(Object that) {
        if (that == null || this.getClass() != that.getClass()) {
            return false;
        }
        NodeStakeUpdateTransactionBody thatObj = (NodeStakeUpdateTransactionBody)that;
        if (this.endOfStakingPeriod == null && thatObj.endOfStakingPeriod != null) {
            return false;
        }
        if (this.endOfStakingPeriod != null && !this.endOfStakingPeriod.equals(thatObj.endOfStakingPeriod)) {
            return false;
        }
        if (this.nodeStake == null && thatObj.nodeStake != null) {
            return false;
        }
        if (this.nodeStake != null && !this.nodeStake.equals(thatObj.nodeStake)) {
            return false;
        }
        if (this.maxStakingRewardRatePerHbar != thatObj.maxStakingRewardRatePerHbar) {
            return false;
        }
        if (this.nodeRewardFeeFraction == null && thatObj.nodeRewardFeeFraction != null) {
            return false;
        }
        if (this.nodeRewardFeeFraction != null && !this.nodeRewardFeeFraction.equals(thatObj.nodeRewardFeeFraction)) {
            return false;
        }
        if (this.stakingPeriodsStored != thatObj.stakingPeriodsStored) {
            return false;
        }
        if (this.stakingPeriod != thatObj.stakingPeriod) {
            return false;
        }
        if (this.stakingRewardFeeFraction == null && thatObj.stakingRewardFeeFraction != null) {
            return false;
        }
        if (this.stakingRewardFeeFraction != null && !this.stakingRewardFeeFraction.equals(thatObj.stakingRewardFeeFraction)) {
            return false;
        }
        if (this.stakingStartThreshold != thatObj.stakingStartThreshold) {
            return false;
        }
        if (this.stakingRewardRate != thatObj.stakingRewardRate) {
            return false;
        }
        if (this.reservedStakingRewards != thatObj.reservedStakingRewards) {
            return false;
        }
        if (this.unreservedStakingRewardBalance != thatObj.unreservedStakingRewardBalance) {
            return false;
        }
        if (this.rewardBalanceThreshold != thatObj.rewardBalanceThreshold) {
            return false;
        }
        if (this.maxStakeRewarded != thatObj.maxStakeRewarded) {
            return false;
        }
        return this.maxTotalReward == thatObj.maxTotalReward;
    }

    public boolean hasEndOfStakingPeriod() {
        return this.endOfStakingPeriod != null;
    }

    public Timestamp endOfStakingPeriodOrElse(@NonNull Timestamp defaultValue) {
        return this.hasEndOfStakingPeriod() ? this.endOfStakingPeriod : defaultValue;
    }

    @NonNull
    public Timestamp endOfStakingPeriodOrThrow() {
        return Objects.requireNonNull(this.endOfStakingPeriod, "Field endOfStakingPeriod is null");
    }

    public void ifEndOfStakingPeriod(@NonNull Consumer<Timestamp> ifPresent) {
        if (this.hasEndOfStakingPeriod()) {
            ifPresent.accept(this.endOfStakingPeriod);
        }
    }

    public boolean hasNodeStake() {
        return this.nodeStake != null;
    }

    public List<NodeStake> nodeStakeOrElse(@NonNull List<NodeStake> defaultValue) {
        return this.hasNodeStake() ? this.nodeStake : defaultValue;
    }

    @NonNull
    public List<NodeStake> nodeStakeOrThrow() {
        return Objects.requireNonNull(this.nodeStake, "Field nodeStake is null");
    }

    public void ifNodeStake(@NonNull Consumer<List<NodeStake>> ifPresent) {
        if (this.hasNodeStake()) {
            ifPresent.accept(this.nodeStake);
        }
    }

    public boolean hasNodeRewardFeeFraction() {
        return this.nodeRewardFeeFraction != null;
    }

    public Fraction nodeRewardFeeFractionOrElse(@NonNull Fraction defaultValue) {
        return this.hasNodeRewardFeeFraction() ? this.nodeRewardFeeFraction : defaultValue;
    }

    @NonNull
    public Fraction nodeRewardFeeFractionOrThrow() {
        return Objects.requireNonNull(this.nodeRewardFeeFraction, "Field nodeRewardFeeFraction is null");
    }

    public void ifNodeRewardFeeFraction(@NonNull Consumer<Fraction> ifPresent) {
        if (this.hasNodeRewardFeeFraction()) {
            ifPresent.accept(this.nodeRewardFeeFraction);
        }
    }

    public boolean hasStakingRewardFeeFraction() {
        return this.stakingRewardFeeFraction != null;
    }

    public Fraction stakingRewardFeeFractionOrElse(@NonNull Fraction defaultValue) {
        return this.hasStakingRewardFeeFraction() ? this.stakingRewardFeeFraction : defaultValue;
    }

    @NonNull
    public Fraction stakingRewardFeeFractionOrThrow() {
        return Objects.requireNonNull(this.stakingRewardFeeFraction, "Field stakingRewardFeeFraction is null");
    }

    public void ifStakingRewardFeeFraction(@NonNull Consumer<Fraction> ifPresent) {
        if (this.hasStakingRewardFeeFraction()) {
            ifPresent.accept(this.stakingRewardFeeFraction);
        }
    }

    public Builder copyBuilder() {
        return new Builder(this.endOfStakingPeriod, this.nodeStake, this.maxStakingRewardRatePerHbar, this.nodeRewardFeeFraction, this.stakingPeriodsStored, this.stakingPeriod, this.stakingRewardFeeFraction, this.stakingStartThreshold, this.stakingRewardRate, this.reservedStakingRewards, this.unreservedStakingRewardBalance, this.rewardBalanceThreshold, this.maxStakeRewarded, this.maxTotalReward);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        private Timestamp endOfStakingPeriod = null;
        private List<NodeStake> nodeStake = Collections.emptyList();
        private long maxStakingRewardRatePerHbar = 0L;
        private Fraction nodeRewardFeeFraction = null;
        private long stakingPeriodsStored = 0L;
        private long stakingPeriod = 0L;
        private Fraction stakingRewardFeeFraction = null;
        private long stakingStartThreshold = 0L;
        private long stakingRewardRate = 0L;
        private long reservedStakingRewards = 0L;
        private long unreservedStakingRewardBalance = 0L;
        private long rewardBalanceThreshold = 0L;
        private long maxStakeRewarded = 0L;
        private long maxTotalReward = 0L;

        public Builder() {
        }

        public Builder(Timestamp endOfStakingPeriod, List<NodeStake> nodeStake, long maxStakingRewardRatePerHbar, Fraction nodeRewardFeeFraction, long stakingPeriodsStored, long stakingPeriod, Fraction stakingRewardFeeFraction, long stakingStartThreshold, long stakingRewardRate, long reservedStakingRewards, long unreservedStakingRewardBalance, long rewardBalanceThreshold, long maxStakeRewarded, long maxTotalReward) {
            this.endOfStakingPeriod = endOfStakingPeriod;
            this.nodeStake = nodeStake;
            this.maxStakingRewardRatePerHbar = maxStakingRewardRatePerHbar;
            this.nodeRewardFeeFraction = nodeRewardFeeFraction;
            this.stakingPeriodsStored = stakingPeriodsStored;
            this.stakingPeriod = stakingPeriod;
            this.stakingRewardFeeFraction = stakingRewardFeeFraction;
            this.stakingStartThreshold = stakingStartThreshold;
            this.stakingRewardRate = stakingRewardRate;
            this.reservedStakingRewards = reservedStakingRewards;
            this.unreservedStakingRewardBalance = unreservedStakingRewardBalance;
            this.rewardBalanceThreshold = rewardBalanceThreshold;
            this.maxStakeRewarded = maxStakeRewarded;
            this.maxTotalReward = maxTotalReward;
        }

        public NodeStakeUpdateTransactionBody build() {
            return new NodeStakeUpdateTransactionBody(this.endOfStakingPeriod, this.nodeStake, this.maxStakingRewardRatePerHbar, this.nodeRewardFeeFraction, this.stakingPeriodsStored, this.stakingPeriod, this.stakingRewardFeeFraction, this.stakingStartThreshold, this.stakingRewardRate, this.reservedStakingRewards, this.unreservedStakingRewardBalance, this.rewardBalanceThreshold, this.maxStakeRewarded, this.maxTotalReward);
        }

        public Builder endOfStakingPeriod(Timestamp endOfStakingPeriod) {
            this.endOfStakingPeriod = endOfStakingPeriod;
            return this;
        }

        public Builder endOfStakingPeriod(Timestamp.Builder builder) {
            this.endOfStakingPeriod = builder.build();
            return this;
        }

        public Builder nodeStake(List<NodeStake> nodeStake) {
            this.nodeStake = nodeStake;
            return this;
        }

        public Builder nodeStake(NodeStake ... values) {
            this.nodeStake = List.of(values);
            return this;
        }

        public Builder maxStakingRewardRatePerHbar(long maxStakingRewardRatePerHbar) {
            this.maxStakingRewardRatePerHbar = maxStakingRewardRatePerHbar;
            return this;
        }

        public Builder nodeRewardFeeFraction(Fraction nodeRewardFeeFraction) {
            this.nodeRewardFeeFraction = nodeRewardFeeFraction;
            return this;
        }

        public Builder nodeRewardFeeFraction(Fraction.Builder builder) {
            this.nodeRewardFeeFraction = builder.build();
            return this;
        }

        public Builder stakingPeriodsStored(long stakingPeriodsStored) {
            this.stakingPeriodsStored = stakingPeriodsStored;
            return this;
        }

        public Builder stakingPeriod(long stakingPeriod) {
            this.stakingPeriod = stakingPeriod;
            return this;
        }

        public Builder stakingRewardFeeFraction(Fraction stakingRewardFeeFraction) {
            this.stakingRewardFeeFraction = stakingRewardFeeFraction;
            return this;
        }

        public Builder stakingRewardFeeFraction(Fraction.Builder builder) {
            this.stakingRewardFeeFraction = builder.build();
            return this;
        }

        public Builder stakingStartThreshold(long stakingStartThreshold) {
            this.stakingStartThreshold = stakingStartThreshold;
            return this;
        }

        public Builder stakingRewardRate(long stakingRewardRate) {
            this.stakingRewardRate = stakingRewardRate;
            return this;
        }

        public Builder reservedStakingRewards(long reservedStakingRewards) {
            this.reservedStakingRewards = reservedStakingRewards;
            return this;
        }

        public Builder unreservedStakingRewardBalance(long unreservedStakingRewardBalance) {
            this.unreservedStakingRewardBalance = unreservedStakingRewardBalance;
            return this;
        }

        public Builder rewardBalanceThreshold(long rewardBalanceThreshold) {
            this.rewardBalanceThreshold = rewardBalanceThreshold;
            return this;
        }

        public Builder maxStakeRewarded(long maxStakeRewarded) {
            this.maxStakeRewarded = maxStakeRewarded;
            return this;
        }

        public Builder maxTotalReward(long maxTotalReward) {
            this.maxTotalReward = maxTotalReward;
            return this;
        }
    }
}

