/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.streams;

import com.hedera.hapi.node.base.Timestamp;
import com.hedera.hapi.streams.SingleAccountBalances;
import com.hedera.hapi.streams.codec.AllAccountBalancesJsonCodec;
import com.hedera.hapi.streams.codec.AllAccountBalancesProtoCodec;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.JsonCodec;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;

public record AllAccountBalances(@Nullable Timestamp consensusTimestamp, @Nullable List<SingleAccountBalances> allAccounts) {
    public static final Codec<AllAccountBalances> PROTOBUF = new AllAccountBalancesProtoCodec();
    public static final JsonCodec<AllAccountBalances> JSON = new AllAccountBalancesJsonCodec();
    public static final AllAccountBalances DEFAULT = AllAccountBalances.newBuilder().build();

    @Override
    public int hashCode() {
        List<SingleAccountBalances> list$allAccounts;
        int result = 1;
        if (this.consensusTimestamp != null && !this.consensusTimestamp.equals(AllAccountBalances.DEFAULT.consensusTimestamp)) {
            result = 31 * result + this.consensusTimestamp.hashCode();
        }
        if ((list$allAccounts = this.allAccounts) != null) {
            for (SingleAccountBalances o : list$allAccounts) {
                if (o != null) {
                    result = 31 * result + ((Object)o).hashCode();
                    continue;
                }
                result = 31 * result;
            }
        }
        long hashCode = result;
        hashCode += hashCode << 30;
        hashCode ^= hashCode >>> 27;
        hashCode += hashCode << 16;
        hashCode ^= hashCode >>> 20;
        hashCode += hashCode << 5;
        hashCode ^= hashCode >>> 18;
        hashCode += hashCode << 10;
        hashCode ^= hashCode >>> 24;
        hashCode += hashCode << 30;
        return (int)hashCode;
    }

    @Override
    public boolean equals(Object that) {
        if (that == null || this.getClass() != that.getClass()) {
            return false;
        }
        AllAccountBalances thatObj = (AllAccountBalances)that;
        if (this.consensusTimestamp == null && thatObj.consensusTimestamp != null) {
            return false;
        }
        if (this.consensusTimestamp != null && !this.consensusTimestamp.equals(thatObj.consensusTimestamp)) {
            return false;
        }
        if (this.allAccounts == null && thatObj.allAccounts != null) {
            return false;
        }
        return this.allAccounts == null || this.allAccounts.equals(thatObj.allAccounts);
    }

    public boolean hasConsensusTimestamp() {
        return this.consensusTimestamp != null;
    }

    public Timestamp consensusTimestampOrElse(@NonNull Timestamp defaultValue) {
        return this.hasConsensusTimestamp() ? this.consensusTimestamp : defaultValue;
    }

    @NonNull
    public Timestamp consensusTimestampOrThrow() {
        return Objects.requireNonNull(this.consensusTimestamp, "Field consensusTimestamp is null");
    }

    public void ifConsensusTimestamp(@NonNull Consumer<Timestamp> ifPresent) {
        if (this.hasConsensusTimestamp()) {
            ifPresent.accept(this.consensusTimestamp);
        }
    }

    public boolean hasAllAccounts() {
        return this.allAccounts != null;
    }

    public List<SingleAccountBalances> allAccountsOrElse(@NonNull List<SingleAccountBalances> defaultValue) {
        return this.hasAllAccounts() ? this.allAccounts : defaultValue;
    }

    @NonNull
    public List<SingleAccountBalances> allAccountsOrThrow() {
        return Objects.requireNonNull(this.allAccounts, "Field allAccounts is null");
    }

    public void ifAllAccounts(@NonNull Consumer<List<SingleAccountBalances>> ifPresent) {
        if (this.hasAllAccounts()) {
            ifPresent.accept(this.allAccounts);
        }
    }

    public Builder copyBuilder() {
        return new Builder(this.consensusTimestamp, this.allAccounts);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        private Timestamp consensusTimestamp = null;
        private List<SingleAccountBalances> allAccounts = Collections.emptyList();

        public Builder() {
        }

        public Builder(Timestamp consensusTimestamp, List<SingleAccountBalances> allAccounts) {
            this.consensusTimestamp = consensusTimestamp;
            this.allAccounts = allAccounts;
        }

        public AllAccountBalances build() {
            return new AllAccountBalances(this.consensusTimestamp, this.allAccounts);
        }

        public Builder consensusTimestamp(Timestamp consensusTimestamp) {
            this.consensusTimestamp = consensusTimestamp;
            return this;
        }

        public Builder consensusTimestamp(Timestamp.Builder builder) {
            this.consensusTimestamp = builder.build();
            return this;
        }

        public Builder allAccounts(List<SingleAccountBalances> allAccounts) {
            this.allAccounts = allAccounts;
            return this;
        }

        public Builder allAccounts(SingleAccountBalances ... values) {
            this.allAccounts = List.of(values);
            return this;
        }
    }
}

