/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.streams;

import com.hedera.hapi.node.base.ContractID;
import com.hedera.hapi.streams.StorageChange;
import com.hedera.hapi.streams.codec.ContractStateChangeJsonCodec;
import com.hedera.hapi.streams.codec.ContractStateChangeProtoCodec;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.JsonCodec;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;

public record ContractStateChange(@Nullable ContractID contractId, @Nullable List<StorageChange> storageChanges) {
    public static final Codec<ContractStateChange> PROTOBUF = new ContractStateChangeProtoCodec();
    public static final JsonCodec<ContractStateChange> JSON = new ContractStateChangeJsonCodec();
    public static final ContractStateChange DEFAULT = ContractStateChange.newBuilder().build();

    @Override
    public int hashCode() {
        List<StorageChange> list$storageChanges;
        int result = 1;
        if (this.contractId != null && !this.contractId.equals(ContractStateChange.DEFAULT.contractId)) {
            result = 31 * result + this.contractId.hashCode();
        }
        if ((list$storageChanges = this.storageChanges) != null) {
            for (StorageChange o : list$storageChanges) {
                if (o != null) {
                    result = 31 * result + ((Object)o).hashCode();
                    continue;
                }
                result = 31 * result;
            }
        }
        long hashCode = result;
        hashCode += hashCode << 30;
        hashCode ^= hashCode >>> 27;
        hashCode += hashCode << 16;
        hashCode ^= hashCode >>> 20;
        hashCode += hashCode << 5;
        hashCode ^= hashCode >>> 18;
        hashCode += hashCode << 10;
        hashCode ^= hashCode >>> 24;
        hashCode += hashCode << 30;
        return (int)hashCode;
    }

    @Override
    public boolean equals(Object that) {
        if (that == null || this.getClass() != that.getClass()) {
            return false;
        }
        ContractStateChange thatObj = (ContractStateChange)that;
        if (this.contractId == null && thatObj.contractId != null) {
            return false;
        }
        if (this.contractId != null && !this.contractId.equals(thatObj.contractId)) {
            return false;
        }
        if (this.storageChanges == null && thatObj.storageChanges != null) {
            return false;
        }
        return this.storageChanges == null || this.storageChanges.equals(thatObj.storageChanges);
    }

    public boolean hasContractId() {
        return this.contractId != null;
    }

    public ContractID contractIdOrElse(@NonNull ContractID defaultValue) {
        return this.hasContractId() ? this.contractId : defaultValue;
    }

    @NonNull
    public ContractID contractIdOrThrow() {
        return Objects.requireNonNull(this.contractId, "Field contractId is null");
    }

    public void ifContractId(@NonNull Consumer<ContractID> ifPresent) {
        if (this.hasContractId()) {
            ifPresent.accept(this.contractId);
        }
    }

    public boolean hasStorageChanges() {
        return this.storageChanges != null;
    }

    public List<StorageChange> storageChangesOrElse(@NonNull List<StorageChange> defaultValue) {
        return this.hasStorageChanges() ? this.storageChanges : defaultValue;
    }

    @NonNull
    public List<StorageChange> storageChangesOrThrow() {
        return Objects.requireNonNull(this.storageChanges, "Field storageChanges is null");
    }

    public void ifStorageChanges(@NonNull Consumer<List<StorageChange>> ifPresent) {
        if (this.hasStorageChanges()) {
            ifPresent.accept(this.storageChanges);
        }
    }

    public Builder copyBuilder() {
        return new Builder(this.contractId, this.storageChanges);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        private ContractID contractId = null;
        private List<StorageChange> storageChanges = Collections.emptyList();

        public Builder() {
        }

        public Builder(ContractID contractId, List<StorageChange> storageChanges) {
            this.contractId = contractId;
            this.storageChanges = storageChanges;
        }

        public ContractStateChange build() {
            return new ContractStateChange(this.contractId, this.storageChanges);
        }

        public Builder contractId(ContractID contractId) {
            this.contractId = contractId;
            return this;
        }

        public Builder contractId(ContractID.Builder builder) {
            this.contractId = builder.build();
            return this;
        }

        public Builder storageChanges(List<StorageChange> storageChanges) {
            this.storageChanges = storageChanges;
            return this;
        }

        public Builder storageChanges(StorageChange ... values) {
            this.storageChanges = List.of(values);
            return this;
        }
    }
}

