/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.streams;

import com.hedera.hapi.streams.HashAlgorithm;
import com.hedera.hapi.streams.codec.HashObjectJsonCodec;
import com.hedera.hapi.streams.codec.HashObjectProtoCodec;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.JsonCodec;
import com.hedera.pbj.runtime.io.buffer.Bytes;

public record HashObject(HashAlgorithm algorithm, int length, Bytes hash) {
    public static final Codec<HashObject> PROTOBUF = new HashObjectProtoCodec();
    public static final JsonCodec<HashObject> JSON = new HashObjectJsonCodec();
    public static final HashObject DEFAULT = HashObject.newBuilder().build();

    @Override
    public int hashCode() {
        int result = 1;
        if (this.algorithm != null && !this.algorithm.equals((Object)HashObject.DEFAULT.algorithm)) {
            result = 31 * result + this.algorithm.hashCode();
        }
        if (this.length != HashObject.DEFAULT.length) {
            result = 31 * result + Integer.hashCode(this.length);
        }
        if (this.hash != null && !this.hash.equals((Object)HashObject.DEFAULT.hash)) {
            result = 31 * result + this.hash.hashCode();
        }
        long hashCode = result;
        hashCode += hashCode << 30;
        hashCode ^= hashCode >>> 27;
        hashCode += hashCode << 16;
        hashCode ^= hashCode >>> 20;
        hashCode += hashCode << 5;
        hashCode ^= hashCode >>> 18;
        hashCode += hashCode << 10;
        hashCode ^= hashCode >>> 24;
        hashCode += hashCode << 30;
        return (int)hashCode;
    }

    @Override
    public boolean equals(Object that) {
        if (that == null || this.getClass() != that.getClass()) {
            return false;
        }
        HashObject thatObj = (HashObject)that;
        if (this.algorithm == null && thatObj.algorithm != null) {
            return false;
        }
        if (this.algorithm != null && !this.algorithm.equals((Object)thatObj.algorithm)) {
            return false;
        }
        if (this.length != thatObj.length) {
            return false;
        }
        if (this.hash == null && thatObj.hash != null) {
            return false;
        }
        return this.hash == null || this.hash.equals((Object)thatObj.hash);
    }

    public Builder copyBuilder() {
        return new Builder(this.algorithm, this.length, this.hash);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        private HashAlgorithm algorithm = HashAlgorithm.values()[0];
        private int length = 0;
        private Bytes hash = Bytes.EMPTY;

        public Builder() {
        }

        public Builder(HashAlgorithm algorithm, int length, Bytes hash) {
            this.algorithm = algorithm;
            this.length = length;
            this.hash = hash;
        }

        public HashObject build() {
            return new HashObject(this.algorithm, this.length, this.hash);
        }

        public Builder algorithm(HashAlgorithm algorithm) {
            this.algorithm = algorithm;
            return this;
        }

        public Builder length(int length) {
            this.length = length;
            return this;
        }

        public Builder hash(Bytes hash) {
            this.hash = hash;
            return this;
        }
    }
}

