/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.streams;

import com.hedera.hapi.node.base.SemanticVersion;
import com.hedera.hapi.streams.HashObject;
import com.hedera.hapi.streams.RecordStreamItem;
import com.hedera.hapi.streams.SidecarMetadata;
import com.hedera.hapi.streams.codec.RecordStreamFileJsonCodec;
import com.hedera.hapi.streams.codec.RecordStreamFileProtoCodec;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.JsonCodec;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;

public record RecordStreamFile(@Nullable SemanticVersion hapiProtoVersion, @Nullable HashObject startObjectRunningHash, @Nullable List<RecordStreamItem> recordStreamItems, @Nullable HashObject endObjectRunningHash, long blockNumber, @Nullable List<SidecarMetadata> sidecars) {
    public static final Codec<RecordStreamFile> PROTOBUF = new RecordStreamFileProtoCodec();
    public static final JsonCodec<RecordStreamFile> JSON = new RecordStreamFileJsonCodec();
    public static final RecordStreamFile DEFAULT = RecordStreamFile.newBuilder().build();

    @Override
    public int hashCode() {
        List<SidecarMetadata> list$sidecars;
        List<RecordStreamItem> list$recordStreamItems;
        int result = 1;
        if (this.hapiProtoVersion != null && !this.hapiProtoVersion.equals(RecordStreamFile.DEFAULT.hapiProtoVersion)) {
            result = 31 * result + this.hapiProtoVersion.hashCode();
        }
        if (this.startObjectRunningHash != null && !this.startObjectRunningHash.equals(RecordStreamFile.DEFAULT.startObjectRunningHash)) {
            result = 31 * result + this.startObjectRunningHash.hashCode();
        }
        if ((list$recordStreamItems = this.recordStreamItems) != null) {
            for (RecordStreamItem recordStreamItem : list$recordStreamItems) {
                if (recordStreamItem != null) {
                    result = 31 * result + ((Object)recordStreamItem).hashCode();
                    continue;
                }
                result = 31 * result;
            }
        }
        if (this.endObjectRunningHash != null && !this.endObjectRunningHash.equals(RecordStreamFile.DEFAULT.endObjectRunningHash)) {
            result = 31 * result + this.endObjectRunningHash.hashCode();
        }
        if (this.blockNumber != RecordStreamFile.DEFAULT.blockNumber) {
            result = 31 * result + Long.hashCode(this.blockNumber);
        }
        if ((list$sidecars = this.sidecars) != null) {
            for (SidecarMetadata sidecarMetadata : list$sidecars) {
                if (sidecarMetadata != null) {
                    result = 31 * result + ((Object)sidecarMetadata).hashCode();
                    continue;
                }
                result = 31 * result;
            }
        }
        long l = result;
        l += l << 30;
        l ^= l >>> 27;
        l += l << 16;
        l ^= l >>> 20;
        l += l << 5;
        l ^= l >>> 18;
        l += l << 10;
        l ^= l >>> 24;
        l += l << 30;
        return (int)l;
    }

    @Override
    public boolean equals(Object that) {
        if (that == null || this.getClass() != that.getClass()) {
            return false;
        }
        RecordStreamFile thatObj = (RecordStreamFile)that;
        if (this.hapiProtoVersion == null && thatObj.hapiProtoVersion != null) {
            return false;
        }
        if (this.hapiProtoVersion != null && !this.hapiProtoVersion.equals(thatObj.hapiProtoVersion)) {
            return false;
        }
        if (this.startObjectRunningHash == null && thatObj.startObjectRunningHash != null) {
            return false;
        }
        if (this.startObjectRunningHash != null && !this.startObjectRunningHash.equals(thatObj.startObjectRunningHash)) {
            return false;
        }
        if (this.recordStreamItems == null && thatObj.recordStreamItems != null) {
            return false;
        }
        if (this.recordStreamItems != null && !this.recordStreamItems.equals(thatObj.recordStreamItems)) {
            return false;
        }
        if (this.endObjectRunningHash == null && thatObj.endObjectRunningHash != null) {
            return false;
        }
        if (this.endObjectRunningHash != null && !this.endObjectRunningHash.equals(thatObj.endObjectRunningHash)) {
            return false;
        }
        if (this.blockNumber != thatObj.blockNumber) {
            return false;
        }
        if (this.sidecars == null && thatObj.sidecars != null) {
            return false;
        }
        return this.sidecars == null || this.sidecars.equals(thatObj.sidecars);
    }

    public boolean hasHapiProtoVersion() {
        return this.hapiProtoVersion != null;
    }

    public SemanticVersion hapiProtoVersionOrElse(@NonNull SemanticVersion defaultValue) {
        return this.hasHapiProtoVersion() ? this.hapiProtoVersion : defaultValue;
    }

    @NonNull
    public SemanticVersion hapiProtoVersionOrThrow() {
        return Objects.requireNonNull(this.hapiProtoVersion, "Field hapiProtoVersion is null");
    }

    public void ifHapiProtoVersion(@NonNull Consumer<SemanticVersion> ifPresent) {
        if (this.hasHapiProtoVersion()) {
            ifPresent.accept(this.hapiProtoVersion);
        }
    }

    public boolean hasStartObjectRunningHash() {
        return this.startObjectRunningHash != null;
    }

    public HashObject startObjectRunningHashOrElse(@NonNull HashObject defaultValue) {
        return this.hasStartObjectRunningHash() ? this.startObjectRunningHash : defaultValue;
    }

    @NonNull
    public HashObject startObjectRunningHashOrThrow() {
        return Objects.requireNonNull(this.startObjectRunningHash, "Field startObjectRunningHash is null");
    }

    public void ifStartObjectRunningHash(@NonNull Consumer<HashObject> ifPresent) {
        if (this.hasStartObjectRunningHash()) {
            ifPresent.accept(this.startObjectRunningHash);
        }
    }

    public boolean hasRecordStreamItems() {
        return this.recordStreamItems != null;
    }

    public List<RecordStreamItem> recordStreamItemsOrElse(@NonNull List<RecordStreamItem> defaultValue) {
        return this.hasRecordStreamItems() ? this.recordStreamItems : defaultValue;
    }

    @NonNull
    public List<RecordStreamItem> recordStreamItemsOrThrow() {
        return Objects.requireNonNull(this.recordStreamItems, "Field recordStreamItems is null");
    }

    public void ifRecordStreamItems(@NonNull Consumer<List<RecordStreamItem>> ifPresent) {
        if (this.hasRecordStreamItems()) {
            ifPresent.accept(this.recordStreamItems);
        }
    }

    public boolean hasEndObjectRunningHash() {
        return this.endObjectRunningHash != null;
    }

    public HashObject endObjectRunningHashOrElse(@NonNull HashObject defaultValue) {
        return this.hasEndObjectRunningHash() ? this.endObjectRunningHash : defaultValue;
    }

    @NonNull
    public HashObject endObjectRunningHashOrThrow() {
        return Objects.requireNonNull(this.endObjectRunningHash, "Field endObjectRunningHash is null");
    }

    public void ifEndObjectRunningHash(@NonNull Consumer<HashObject> ifPresent) {
        if (this.hasEndObjectRunningHash()) {
            ifPresent.accept(this.endObjectRunningHash);
        }
    }

    public boolean hasSidecars() {
        return this.sidecars != null;
    }

    public List<SidecarMetadata> sidecarsOrElse(@NonNull List<SidecarMetadata> defaultValue) {
        return this.hasSidecars() ? this.sidecars : defaultValue;
    }

    @NonNull
    public List<SidecarMetadata> sidecarsOrThrow() {
        return Objects.requireNonNull(this.sidecars, "Field sidecars is null");
    }

    public void ifSidecars(@NonNull Consumer<List<SidecarMetadata>> ifPresent) {
        if (this.hasSidecars()) {
            ifPresent.accept(this.sidecars);
        }
    }

    public Builder copyBuilder() {
        return new Builder(this.hapiProtoVersion, this.startObjectRunningHash, this.recordStreamItems, this.endObjectRunningHash, this.blockNumber, this.sidecars);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        private SemanticVersion hapiProtoVersion = null;
        private HashObject startObjectRunningHash = null;
        private List<RecordStreamItem> recordStreamItems = Collections.emptyList();
        private HashObject endObjectRunningHash = null;
        private long blockNumber = 0L;
        private List<SidecarMetadata> sidecars = Collections.emptyList();

        public Builder() {
        }

        public Builder(SemanticVersion hapiProtoVersion, HashObject startObjectRunningHash, List<RecordStreamItem> recordStreamItems, HashObject endObjectRunningHash, long blockNumber, List<SidecarMetadata> sidecars) {
            this.hapiProtoVersion = hapiProtoVersion;
            this.startObjectRunningHash = startObjectRunningHash;
            this.recordStreamItems = recordStreamItems;
            this.endObjectRunningHash = endObjectRunningHash;
            this.blockNumber = blockNumber;
            this.sidecars = sidecars;
        }

        public RecordStreamFile build() {
            return new RecordStreamFile(this.hapiProtoVersion, this.startObjectRunningHash, this.recordStreamItems, this.endObjectRunningHash, this.blockNumber, this.sidecars);
        }

        public Builder hapiProtoVersion(SemanticVersion hapiProtoVersion) {
            this.hapiProtoVersion = hapiProtoVersion;
            return this;
        }

        public Builder hapiProtoVersion(SemanticVersion.Builder builder) {
            this.hapiProtoVersion = builder.build();
            return this;
        }

        public Builder startObjectRunningHash(HashObject startObjectRunningHash) {
            this.startObjectRunningHash = startObjectRunningHash;
            return this;
        }

        public Builder startObjectRunningHash(HashObject.Builder builder) {
            this.startObjectRunningHash = builder.build();
            return this;
        }

        public Builder recordStreamItems(List<RecordStreamItem> recordStreamItems) {
            this.recordStreamItems = recordStreamItems;
            return this;
        }

        public Builder recordStreamItems(RecordStreamItem ... values) {
            this.recordStreamItems = List.of(values);
            return this;
        }

        public Builder endObjectRunningHash(HashObject endObjectRunningHash) {
            this.endObjectRunningHash = endObjectRunningHash;
            return this;
        }

        public Builder endObjectRunningHash(HashObject.Builder builder) {
            this.endObjectRunningHash = builder.build();
            return this;
        }

        public Builder blockNumber(long blockNumber) {
            this.blockNumber = blockNumber;
            return this;
        }

        public Builder sidecars(List<SidecarMetadata> sidecars) {
            this.sidecars = sidecars;
            return this;
        }

        public Builder sidecars(SidecarMetadata ... values) {
            this.sidecars = List.of(values);
            return this;
        }
    }
}

