/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.streams;

import com.hedera.hapi.streams.SignatureObject;
import com.hedera.hapi.streams.codec.SignatureFileJsonCodec;
import com.hedera.hapi.streams.codec.SignatureFileProtoCodec;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.JsonCodec;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Objects;
import java.util.function.Consumer;

public record SignatureFile(@Nullable SignatureObject fileSignature, @Nullable SignatureObject metadataSignature) {
    public static final Codec<SignatureFile> PROTOBUF = new SignatureFileProtoCodec();
    public static final JsonCodec<SignatureFile> JSON = new SignatureFileJsonCodec();
    public static final SignatureFile DEFAULT = SignatureFile.newBuilder().build();

    @Override
    public int hashCode() {
        int result = 1;
        if (this.fileSignature != null && !this.fileSignature.equals(SignatureFile.DEFAULT.fileSignature)) {
            result = 31 * result + this.fileSignature.hashCode();
        }
        if (this.metadataSignature != null && !this.metadataSignature.equals(SignatureFile.DEFAULT.metadataSignature)) {
            result = 31 * result + this.metadataSignature.hashCode();
        }
        long hashCode = result;
        hashCode += hashCode << 30;
        hashCode ^= hashCode >>> 27;
        hashCode += hashCode << 16;
        hashCode ^= hashCode >>> 20;
        hashCode += hashCode << 5;
        hashCode ^= hashCode >>> 18;
        hashCode += hashCode << 10;
        hashCode ^= hashCode >>> 24;
        hashCode += hashCode << 30;
        return (int)hashCode;
    }

    @Override
    public boolean equals(Object that) {
        if (that == null || this.getClass() != that.getClass()) {
            return false;
        }
        SignatureFile thatObj = (SignatureFile)that;
        if (this.fileSignature == null && thatObj.fileSignature != null) {
            return false;
        }
        if (this.fileSignature != null && !this.fileSignature.equals(thatObj.fileSignature)) {
            return false;
        }
        if (this.metadataSignature == null && thatObj.metadataSignature != null) {
            return false;
        }
        return this.metadataSignature == null || this.metadataSignature.equals(thatObj.metadataSignature);
    }

    public boolean hasFileSignature() {
        return this.fileSignature != null;
    }

    public SignatureObject fileSignatureOrElse(@NonNull SignatureObject defaultValue) {
        return this.hasFileSignature() ? this.fileSignature : defaultValue;
    }

    @NonNull
    public SignatureObject fileSignatureOrThrow() {
        return Objects.requireNonNull(this.fileSignature, "Field fileSignature is null");
    }

    public void ifFileSignature(@NonNull Consumer<SignatureObject> ifPresent) {
        if (this.hasFileSignature()) {
            ifPresent.accept(this.fileSignature);
        }
    }

    public boolean hasMetadataSignature() {
        return this.metadataSignature != null;
    }

    public SignatureObject metadataSignatureOrElse(@NonNull SignatureObject defaultValue) {
        return this.hasMetadataSignature() ? this.metadataSignature : defaultValue;
    }

    @NonNull
    public SignatureObject metadataSignatureOrThrow() {
        return Objects.requireNonNull(this.metadataSignature, "Field metadataSignature is null");
    }

    public void ifMetadataSignature(@NonNull Consumer<SignatureObject> ifPresent) {
        if (this.hasMetadataSignature()) {
            ifPresent.accept(this.metadataSignature);
        }
    }

    public Builder copyBuilder() {
        return new Builder(this.fileSignature, this.metadataSignature);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        private SignatureObject fileSignature = null;
        private SignatureObject metadataSignature = null;

        public Builder() {
        }

        public Builder(SignatureObject fileSignature, SignatureObject metadataSignature) {
            this.fileSignature = fileSignature;
            this.metadataSignature = metadataSignature;
        }

        public SignatureFile build() {
            return new SignatureFile(this.fileSignature, this.metadataSignature);
        }

        public Builder fileSignature(SignatureObject fileSignature) {
            this.fileSignature = fileSignature;
            return this;
        }

        public Builder fileSignature(SignatureObject.Builder builder) {
            this.fileSignature = builder.build();
            return this;
        }

        public Builder metadataSignature(SignatureObject metadataSignature) {
            this.metadataSignature = metadataSignature;
            return this;
        }

        public Builder metadataSignature(SignatureObject.Builder builder) {
            this.metadataSignature = builder.build();
            return this;
        }
    }
}

