/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.streams;

import com.hedera.hapi.streams.HashObject;
import com.hedera.hapi.streams.SignatureType;
import com.hedera.hapi.streams.codec.SignatureObjectJsonCodec;
import com.hedera.hapi.streams.codec.SignatureObjectProtoCodec;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.JsonCodec;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Objects;
import java.util.function.Consumer;

public record SignatureObject(SignatureType type, int length, int checksum, Bytes signature, @Nullable HashObject hashObject) {
    public static final Codec<SignatureObject> PROTOBUF = new SignatureObjectProtoCodec();
    public static final JsonCodec<SignatureObject> JSON = new SignatureObjectJsonCodec();
    public static final SignatureObject DEFAULT = SignatureObject.newBuilder().build();

    @Override
    public int hashCode() {
        int result = 1;
        if (this.type != null && !this.type.equals((Object)SignatureObject.DEFAULT.type)) {
            result = 31 * result + this.type.hashCode();
        }
        if (this.length != SignatureObject.DEFAULT.length) {
            result = 31 * result + Integer.hashCode(this.length);
        }
        if (this.checksum != SignatureObject.DEFAULT.checksum) {
            result = 31 * result + Integer.hashCode(this.checksum);
        }
        if (this.signature != null && !this.signature.equals((Object)SignatureObject.DEFAULT.signature)) {
            result = 31 * result + this.signature.hashCode();
        }
        if (this.hashObject != null && !this.hashObject.equals(SignatureObject.DEFAULT.hashObject)) {
            result = 31 * result + this.hashObject.hashCode();
        }
        long hashCode = result;
        hashCode += hashCode << 30;
        hashCode ^= hashCode >>> 27;
        hashCode += hashCode << 16;
        hashCode ^= hashCode >>> 20;
        hashCode += hashCode << 5;
        hashCode ^= hashCode >>> 18;
        hashCode += hashCode << 10;
        hashCode ^= hashCode >>> 24;
        hashCode += hashCode << 30;
        return (int)hashCode;
    }

    @Override
    public boolean equals(Object that) {
        if (that == null || this.getClass() != that.getClass()) {
            return false;
        }
        SignatureObject thatObj = (SignatureObject)that;
        if (this.type == null && thatObj.type != null) {
            return false;
        }
        if (this.type != null && !this.type.equals((Object)thatObj.type)) {
            return false;
        }
        if (this.length != thatObj.length) {
            return false;
        }
        if (this.checksum != thatObj.checksum) {
            return false;
        }
        if (this.signature == null && thatObj.signature != null) {
            return false;
        }
        if (this.signature != null && !this.signature.equals((Object)thatObj.signature)) {
            return false;
        }
        if (this.hashObject == null && thatObj.hashObject != null) {
            return false;
        }
        return this.hashObject == null || this.hashObject.equals(thatObj.hashObject);
    }

    public boolean hasHashObject() {
        return this.hashObject != null;
    }

    public HashObject hashObjectOrElse(@NonNull HashObject defaultValue) {
        return this.hasHashObject() ? this.hashObject : defaultValue;
    }

    @NonNull
    public HashObject hashObjectOrThrow() {
        return Objects.requireNonNull(this.hashObject, "Field hashObject is null");
    }

    public void ifHashObject(@NonNull Consumer<HashObject> ifPresent) {
        if (this.hasHashObject()) {
            ifPresent.accept(this.hashObject);
        }
    }

    public Builder copyBuilder() {
        return new Builder(this.type, this.length, this.checksum, this.signature, this.hashObject);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        private SignatureType type = SignatureType.values()[0];
        private int length = 0;
        private int checksum = 0;
        private Bytes signature = Bytes.EMPTY;
        private HashObject hashObject = null;

        public Builder() {
        }

        public Builder(SignatureType type, int length, int checksum, Bytes signature, HashObject hashObject) {
            this.type = type;
            this.length = length;
            this.checksum = checksum;
            this.signature = signature;
            this.hashObject = hashObject;
        }

        public SignatureObject build() {
            return new SignatureObject(this.type, this.length, this.checksum, this.signature, this.hashObject);
        }

        public Builder type(SignatureType type) {
            this.type = type;
            return this;
        }

        public Builder length(int length) {
            this.length = length;
            return this;
        }

        public Builder checksum(int checksum) {
            this.checksum = checksum;
            return this;
        }

        public Builder signature(Bytes signature) {
            this.signature = signature;
            return this;
        }

        public Builder hashObject(HashObject hashObject) {
            this.hashObject = hashObject;
            return this;
        }

        public Builder hashObject(HashObject.Builder builder) {
            this.hashObject = builder.build();
            return this;
        }
    }
}

