/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.streams;

import com.hedera.hapi.streams.codec.StorageChangeJsonCodec;
import com.hedera.hapi.streams.codec.StorageChangeProtoCodec;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.JsonCodec;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Objects;
import java.util.function.Consumer;

public record StorageChange(Bytes slot, Bytes valueRead, @Nullable Bytes valueWritten) {
    public static final Codec<StorageChange> PROTOBUF = new StorageChangeProtoCodec();
    public static final JsonCodec<StorageChange> JSON = new StorageChangeJsonCodec();
    public static final StorageChange DEFAULT = StorageChange.newBuilder().build();

    @Override
    public int hashCode() {
        int result = 1;
        if (this.slot != null && !this.slot.equals((Object)StorageChange.DEFAULT.slot)) {
            result = 31 * result + this.slot.hashCode();
        }
        if (this.valueRead != null && !this.valueRead.equals((Object)StorageChange.DEFAULT.valueRead)) {
            result = 31 * result + this.valueRead.hashCode();
        }
        if (this.valueWritten != null && !this.valueWritten.equals((Object)StorageChange.DEFAULT.valueWritten)) {
            result = 31 * result + (this.valueWritten == null ? 0 : this.valueWritten.hashCode());
        }
        long hashCode = result;
        hashCode += hashCode << 30;
        hashCode ^= hashCode >>> 27;
        hashCode += hashCode << 16;
        hashCode ^= hashCode >>> 20;
        hashCode += hashCode << 5;
        hashCode ^= hashCode >>> 18;
        hashCode += hashCode << 10;
        hashCode ^= hashCode >>> 24;
        hashCode += hashCode << 30;
        return (int)hashCode;
    }

    @Override
    public boolean equals(Object that) {
        if (that == null || this.getClass() != that.getClass()) {
            return false;
        }
        StorageChange thatObj = (StorageChange)that;
        if (this.slot == null && thatObj.slot != null) {
            return false;
        }
        if (this.slot != null && !this.slot.equals((Object)thatObj.slot)) {
            return false;
        }
        if (this.valueRead == null && thatObj.valueRead != null) {
            return false;
        }
        if (this.valueRead != null && !this.valueRead.equals((Object)thatObj.valueRead)) {
            return false;
        }
        if (this.valueWritten == null && thatObj.valueWritten != null) {
            return false;
        }
        return this.valueWritten == null || this.valueWritten.equals((Object)thatObj.valueWritten);
    }

    public boolean hasValueWritten() {
        return this.valueWritten != null;
    }

    public Bytes valueWrittenOrElse(@NonNull Bytes defaultValue) {
        return this.hasValueWritten() ? this.valueWritten : defaultValue;
    }

    @NonNull
    public Bytes valueWrittenOrThrow() {
        return Objects.requireNonNull(this.valueWritten, "Field valueWritten is null");
    }

    public void ifValueWritten(@NonNull Consumer<Bytes> ifPresent) {
        if (this.hasValueWritten()) {
            ifPresent.accept(this.valueWritten);
        }
    }

    public Builder copyBuilder() {
        return new Builder(this.slot, this.valueRead, this.valueWritten);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        private Bytes slot = Bytes.EMPTY;
        private Bytes valueRead = Bytes.EMPTY;
        private Bytes valueWritten = null;

        public Builder() {
        }

        public Builder(Bytes slot, Bytes valueRead, Bytes valueWritten) {
            this.slot = slot;
            this.valueRead = valueRead;
            this.valueWritten = valueWritten;
        }

        public StorageChange build() {
            return new StorageChange(this.slot, this.valueRead, this.valueWritten);
        }

        public Builder slot(Bytes slot) {
            this.slot = slot;
            return this;
        }

        public Builder valueRead(Bytes valueRead) {
            this.valueRead = valueRead;
            return this;
        }

        public Builder valueWritten(Bytes valueWritten) {
            this.valueWritten = valueWritten;
            return this;
        }
    }
}

