/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.streams.codec;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.ContractID;
import com.hedera.hapi.streams.CallOperationType;
import com.hedera.hapi.streams.ContractAction;
import com.hedera.hapi.streams.ContractActionType;
import com.hedera.hapi.streams.schema.ContractActionSchema;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.EnumWithProtoMetadata;
import com.hedera.pbj.runtime.FieldDefinition;
import com.hedera.pbj.runtime.OneOf;
import com.hedera.pbj.runtime.ProtoConstants;
import com.hedera.pbj.runtime.ProtoParserTools;
import com.hedera.pbj.runtime.ProtoWriterTools;
import com.hedera.pbj.runtime.UnknownFieldException;
import com.hedera.pbj.runtime.io.ReadableSequentialData;
import com.hedera.pbj.runtime.io.WritableSequentialData;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.hedera.pbj.runtime.io.buffer.RandomAccessData;
import com.hedera.pbj.runtime.io.stream.EOFException;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;

public final class ContractActionProtoCodec
implements Codec<ContractAction> {
    public static final OneOf<ContractAction.CallerOneOfType> CALLER_UNSET = new OneOf((Object)ContractAction.CallerOneOfType.UNSET, null);
    public static final OneOf<ContractAction.RecipientOneOfType> RECIPIENT_UNSET = new OneOf((Object)ContractAction.RecipientOneOfType.UNSET, null);
    public static final OneOf<ContractAction.ResultDataOneOfType> RESULT_DATA_UNSET = new OneOf((Object)ContractAction.ResultDataOneOfType.UNSET, null);

    @NonNull
    public ContractAction parse(@NonNull ReadableSequentialData input) throws IOException {
        return this.parseInternal(input, false);
    }

    @NonNull
    public ContractAction parseStrict(@NonNull ReadableSequentialData input) throws IOException {
        return this.parseInternal(input, true);
    }

    public void write(@NonNull ContractAction data, @NonNull WritableSequentialData out) throws IOException {
        ProtoWriterTools.writeEnum((WritableSequentialData)out, (FieldDefinition)ContractActionSchema.CALL_TYPE, (EnumWithProtoMetadata)data.callType());
        if (data.caller().kind() == ContractAction.CallerOneOfType.CALLING_ACCOUNT) {
            ProtoWriterTools.writeMessage((WritableSequentialData)out, (FieldDefinition)ContractActionSchema.CALLING_ACCOUNT, (Object)((AccountID)data.caller().as()), (arg_0, arg_1) -> AccountID.PROTOBUF.write(arg_0, arg_1), arg_0 -> AccountID.PROTOBUF.measureRecord(arg_0));
        }
        if (data.caller().kind() == ContractAction.CallerOneOfType.CALLING_CONTRACT) {
            ProtoWriterTools.writeMessage((WritableSequentialData)out, (FieldDefinition)ContractActionSchema.CALLING_CONTRACT, (Object)((ContractID)data.caller().as()), (arg_0, arg_1) -> ContractID.PROTOBUF.write(arg_0, arg_1), arg_0 -> ContractID.PROTOBUF.measureRecord(arg_0));
        }
        ProtoWriterTools.writeLong((WritableSequentialData)out, (FieldDefinition)ContractActionSchema.GAS, (long)data.gas());
        ProtoWriterTools.writeBytes((WritableSequentialData)out, (FieldDefinition)ContractActionSchema.INPUT, (RandomAccessData)data.input());
        if (data.recipient().kind() == ContractAction.RecipientOneOfType.RECIPIENT_ACCOUNT) {
            ProtoWriterTools.writeMessage((WritableSequentialData)out, (FieldDefinition)ContractActionSchema.RECIPIENT_ACCOUNT, (Object)((AccountID)data.recipient().as()), (arg_0, arg_1) -> AccountID.PROTOBUF.write(arg_0, arg_1), arg_0 -> AccountID.PROTOBUF.measureRecord(arg_0));
        }
        if (data.recipient().kind() == ContractAction.RecipientOneOfType.RECIPIENT_CONTRACT) {
            ProtoWriterTools.writeMessage((WritableSequentialData)out, (FieldDefinition)ContractActionSchema.RECIPIENT_CONTRACT, (Object)((ContractID)data.recipient().as()), (arg_0, arg_1) -> ContractID.PROTOBUF.write(arg_0, arg_1), arg_0 -> ContractID.PROTOBUF.measureRecord(arg_0));
        }
        if (data.recipient().kind() == ContractAction.RecipientOneOfType.TARGETED_ADDRESS) {
            ProtoWriterTools.writeBytes((WritableSequentialData)out, (FieldDefinition)ContractActionSchema.TARGETED_ADDRESS, (RandomAccessData)((RandomAccessData)data.recipient().as()));
        }
        ProtoWriterTools.writeLong((WritableSequentialData)out, (FieldDefinition)ContractActionSchema.VALUE, (long)data.value());
        ProtoWriterTools.writeLong((WritableSequentialData)out, (FieldDefinition)ContractActionSchema.GAS_USED, (long)data.gasUsed());
        if (data.resultData().kind() == ContractAction.ResultDataOneOfType.OUTPUT) {
            ProtoWriterTools.writeBytes((WritableSequentialData)out, (FieldDefinition)ContractActionSchema.OUTPUT, (RandomAccessData)((RandomAccessData)data.resultData().as()));
        }
        if (data.resultData().kind() == ContractAction.ResultDataOneOfType.REVERT_REASON) {
            ProtoWriterTools.writeBytes((WritableSequentialData)out, (FieldDefinition)ContractActionSchema.REVERT_REASON, (RandomAccessData)((RandomAccessData)data.resultData().as()));
        }
        if (data.resultData().kind() == ContractAction.ResultDataOneOfType.ERROR) {
            ProtoWriterTools.writeBytes((WritableSequentialData)out, (FieldDefinition)ContractActionSchema.ERROR, (RandomAccessData)((RandomAccessData)data.resultData().as()));
        }
        ProtoWriterTools.writeInteger((WritableSequentialData)out, (FieldDefinition)ContractActionSchema.CALL_DEPTH, (int)data.callDepth());
        ProtoWriterTools.writeEnum((WritableSequentialData)out, (FieldDefinition)ContractActionSchema.CALL_OPERATION_TYPE, (EnumWithProtoMetadata)data.callOperationType());
    }

    public int measure(@NonNull ReadableSequentialData input) throws IOException {
        long start = input.position();
        this.parse(input);
        long end = input.position();
        return (int)(end - start);
    }

    public int measureRecord(ContractAction data) {
        int size = 0;
        size += ProtoWriterTools.sizeOfEnum((FieldDefinition)ContractActionSchema.CALL_TYPE, (EnumWithProtoMetadata)data.callType());
        if (data.caller().kind() == ContractAction.CallerOneOfType.CALLING_ACCOUNT) {
            size += ProtoWriterTools.sizeOfMessage((FieldDefinition)ContractActionSchema.CALLING_ACCOUNT, (Object)((AccountID)data.caller().as()), arg_0 -> AccountID.PROTOBUF.measureRecord(arg_0));
        }
        if (data.caller().kind() == ContractAction.CallerOneOfType.CALLING_CONTRACT) {
            size += ProtoWriterTools.sizeOfMessage((FieldDefinition)ContractActionSchema.CALLING_CONTRACT, (Object)((ContractID)data.caller().as()), arg_0 -> ContractID.PROTOBUF.measureRecord(arg_0));
        }
        size += ProtoWriterTools.sizeOfLong((FieldDefinition)ContractActionSchema.GAS, (long)data.gas());
        size += ProtoWriterTools.sizeOfBytes((FieldDefinition)ContractActionSchema.INPUT, (RandomAccessData)data.input());
        if (data.recipient().kind() == ContractAction.RecipientOneOfType.RECIPIENT_ACCOUNT) {
            size += ProtoWriterTools.sizeOfMessage((FieldDefinition)ContractActionSchema.RECIPIENT_ACCOUNT, (Object)((AccountID)data.recipient().as()), arg_0 -> AccountID.PROTOBUF.measureRecord(arg_0));
        }
        if (data.recipient().kind() == ContractAction.RecipientOneOfType.RECIPIENT_CONTRACT) {
            size += ProtoWriterTools.sizeOfMessage((FieldDefinition)ContractActionSchema.RECIPIENT_CONTRACT, (Object)((ContractID)data.recipient().as()), arg_0 -> ContractID.PROTOBUF.measureRecord(arg_0));
        }
        if (data.recipient().kind() == ContractAction.RecipientOneOfType.TARGETED_ADDRESS) {
            size += ProtoWriterTools.sizeOfBytes((FieldDefinition)ContractActionSchema.TARGETED_ADDRESS, (RandomAccessData)((RandomAccessData)data.recipient().as()));
        }
        size += ProtoWriterTools.sizeOfLong((FieldDefinition)ContractActionSchema.VALUE, (long)data.value());
        size += ProtoWriterTools.sizeOfLong((FieldDefinition)ContractActionSchema.GAS_USED, (long)data.gasUsed());
        if (data.resultData().kind() == ContractAction.ResultDataOneOfType.OUTPUT) {
            size += ProtoWriterTools.sizeOfBytes((FieldDefinition)ContractActionSchema.OUTPUT, (RandomAccessData)((RandomAccessData)data.resultData().as()));
        }
        if (data.resultData().kind() == ContractAction.ResultDataOneOfType.REVERT_REASON) {
            size += ProtoWriterTools.sizeOfBytes((FieldDefinition)ContractActionSchema.REVERT_REASON, (RandomAccessData)((RandomAccessData)data.resultData().as()));
        }
        if (data.resultData().kind() == ContractAction.ResultDataOneOfType.ERROR) {
            size += ProtoWriterTools.sizeOfBytes((FieldDefinition)ContractActionSchema.ERROR, (RandomAccessData)((RandomAccessData)data.resultData().as()));
        }
        size += ProtoWriterTools.sizeOfInteger((FieldDefinition)ContractActionSchema.CALL_DEPTH, (int)data.callDepth());
        return size += ProtoWriterTools.sizeOfEnum((FieldDefinition)ContractActionSchema.CALL_OPERATION_TYPE, (EnumWithProtoMetadata)data.callOperationType());
    }

    public boolean fastEquals(@NonNull ContractAction item, @NonNull ReadableSequentialData input) throws IOException {
        return item.equals(this.parse(input));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NonNull
    private ContractAction parseInternal(@NonNull ReadableSequentialData input, boolean strictMode) throws IOException {
        temp_call_type = ContractActionType.values()[0];
        temp_caller = ContractActionProtoCodec.CALLER_UNSET;
        temp_gas = 0L;
        temp_input = Bytes.EMPTY;
        temp_recipient = ContractActionProtoCodec.RECIPIENT_UNSET;
        temp_value = 0L;
        temp_gas_used = 0L;
        temp_result_data = ContractActionProtoCodec.RESULT_DATA_UNSET;
        temp_call_depth = 0;
        temp_call_operation_type = CallOperationType.values()[0];
        try {
            block31: while (input.hasRemaining() != false) {
                tag = input.readVarInt(false);
                field = tag >>> 3;
                f = ContractActionSchema.getField(field);
                switch (tag) {
                    case 8: {
                        temp_call_type = value = ContractActionType.fromProtobufOrdinal(ProtoParserTools.readEnum((ReadableSequentialData)input));
                        continue block31;
                    }
                    case 18: {
                        messageLength = input.readVarInt(false);
                        if (messageLength != 0) ** GOTO lbl25
                        value /* !! */  = AccountID.DEFAULT;
                        ** GOTO lbl38
lbl25:
                        // 1 sources

                        limitBefore = input.limit();
                        startPos = input.position();
                        try {
                            if (startPos + (long)messageLength > limitBefore) {
                                throw new BufferUnderflowException();
                            }
                            input.limit(startPos + (long)messageLength);
                            v0 = value /* !! */  = strictMode != false ? (AccountID)AccountID.PROTOBUF.parseStrict(input) : (AccountID)AccountID.PROTOBUF.parse(input);
                            if (startPos + (long)messageLength != input.position()) {
                                throw new BufferOverflowException();
                            }
                        }
                        finally {
                            input.limit(limitBefore);
                        }
lbl38:
                        // 2 sources

                        temp_caller = new OneOf((Object)ContractAction.CallerOneOfType.CALLING_ACCOUNT, (Object)value /* !! */ );
                        continue block31;
                    }
                    case 26: {
                        messageLength = input.readVarInt(false);
                        if (messageLength != 0) ** GOTO lbl45
                        value /* !! */  = ContractID.DEFAULT;
                        ** GOTO lbl58
lbl45:
                        // 1 sources

                        limitBefore = input.limit();
                        startPos = input.position();
                        try {
                            if (startPos + (long)messageLength > limitBefore) {
                                throw new BufferUnderflowException();
                            }
                            input.limit(startPos + (long)messageLength);
                            v1 /* !! */  = value /* !! */  = strictMode != false ? (ContractID)ContractID.PROTOBUF.parseStrict(input) : (ContractID)ContractID.PROTOBUF.parse(input);
                            if (startPos + (long)messageLength != input.position()) {
                                throw new BufferOverflowException();
                            }
                        }
                        finally {
                            input.limit(limitBefore);
                        }
lbl58:
                        // 2 sources

                        temp_caller = new OneOf((Object)ContractAction.CallerOneOfType.CALLING_CONTRACT, (Object)value /* !! */ );
                        continue block31;
                    }
                    case 32: {
                        temp_gas = value = ProtoParserTools.readInt64((ReadableSequentialData)input);
                        continue block31;
                    }
                    case 42: {
                        temp_input = value = ProtoParserTools.readBytes((ReadableSequentialData)input);
                        continue block31;
                    }
                    case 50: {
                        messageLength = input.readVarInt(false);
                        if (messageLength != 0) ** GOTO lbl71
                        value /* !! */  = AccountID.DEFAULT;
                        ** GOTO lbl84
lbl71:
                        // 1 sources

                        limitBefore = input.limit();
                        startPos = input.position();
                        try {
                            if (startPos + (long)messageLength > limitBefore) {
                                throw new BufferUnderflowException();
                            }
                            input.limit(startPos + (long)messageLength);
                            v2 = value /* !! */  = strictMode != false ? (AccountID)AccountID.PROTOBUF.parseStrict(input) : (AccountID)AccountID.PROTOBUF.parse(input);
                            if (startPos + (long)messageLength != input.position()) {
                                throw new BufferOverflowException();
                            }
                        }
                        finally {
                            input.limit(limitBefore);
                        }
lbl84:
                        // 2 sources

                        temp_recipient = new OneOf((Object)ContractAction.RecipientOneOfType.RECIPIENT_ACCOUNT, (Object)value /* !! */ );
                        continue block31;
                    }
                    case 58: {
                        messageLength = input.readVarInt(false);
                        if (messageLength != 0) ** GOTO lbl91
                        value /* !! */  = ContractID.DEFAULT;
                        ** GOTO lbl104
lbl91:
                        // 1 sources

                        limitBefore = input.limit();
                        startPos = input.position();
                        try {
                            if (startPos + (long)messageLength > limitBefore) {
                                throw new BufferUnderflowException();
                            }
                            input.limit(startPos + (long)messageLength);
                            v3 /* !! */  = value /* !! */  = strictMode != false ? (ContractID)ContractID.PROTOBUF.parseStrict(input) : (ContractID)ContractID.PROTOBUF.parse(input);
                            if (startPos + (long)messageLength != input.position()) {
                                throw new BufferOverflowException();
                            }
                        }
                        finally {
                            input.limit(limitBefore);
                        }
lbl104:
                        // 2 sources

                        temp_recipient = new OneOf((Object)ContractAction.RecipientOneOfType.RECIPIENT_CONTRACT, (Object)value /* !! */ );
                        continue block31;
                    }
                    case 66: {
                        value = ProtoParserTools.readBytes((ReadableSequentialData)input);
                        temp_recipient = new OneOf((Object)ContractAction.RecipientOneOfType.TARGETED_ADDRESS, (Object)value);
                        continue block31;
                    }
                    case 72: {
                        temp_value = value = ProtoParserTools.readInt64((ReadableSequentialData)input);
                        continue block31;
                    }
                    case 80: {
                        temp_gas_used = value = ProtoParserTools.readInt64((ReadableSequentialData)input);
                        continue block31;
                    }
                    case 90: {
                        value = ProtoParserTools.readBytes((ReadableSequentialData)input);
                        temp_result_data = new OneOf((Object)ContractAction.ResultDataOneOfType.OUTPUT, (Object)value);
                        continue block31;
                    }
                    case 98: {
                        value = ProtoParserTools.readBytes((ReadableSequentialData)input);
                        temp_result_data = new OneOf((Object)ContractAction.ResultDataOneOfType.REVERT_REASON, (Object)value);
                        continue block31;
                    }
                    case 106: {
                        value = ProtoParserTools.readBytes((ReadableSequentialData)input);
                        temp_result_data = new OneOf((Object)ContractAction.ResultDataOneOfType.ERROR, (Object)value);
                        continue block31;
                    }
                    case 112: {
                        temp_call_depth = value = ProtoParserTools.readInt32((ReadableSequentialData)input);
                        continue block31;
                    }
                    case 120: {
                        temp_call_operation_type = value = CallOperationType.fromProtobufOrdinal(ProtoParserTools.readEnum((ReadableSequentialData)input));
                        continue block31;
                    }
                }
                wireType = tag & 7;
                if (field == 0) {
                    throw new IOException("Bad protobuf encoding. We read a field value of " + field);
                }
                if (wireType > 5) {
                    throw new IOException("Cannot understand wire_type of " + wireType);
                }
                if (f != null) throw new IOException("Bad tag [" + tag + "], field [" + field + "] wireType [" + wireType + "]");
                if (strictMode) {
                    throw new UnknownFieldException(field);
                }
                ProtoParserTools.skipField((ReadableSequentialData)input, (ProtoConstants)ProtoConstants.get((int)wireType));
            }
            return new ContractAction(temp_call_type, temp_caller, temp_gas, temp_input, temp_recipient, temp_value, temp_gas_used, temp_result_data, temp_call_depth, temp_call_operation_type);
        }
        catch (EOFException var16_14) {
            // empty catch block
        }
        return new ContractAction(temp_call_type, temp_caller, temp_gas, temp_input, temp_recipient, temp_value, temp_gas_used, temp_result_data, temp_call_depth, temp_call_operation_type);
    }
}

