/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.streams.codec;

import com.hedera.hapi.streams.HashAlgorithm;
import com.hedera.hapi.streams.HashObject;
import com.hedera.pbj.runtime.JsonCodec;
import com.hedera.pbj.runtime.JsonTools;
import com.hedera.pbj.runtime.UnknownFieldException;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.hedera.pbj.runtime.jsonparser.JSONParser;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.io.IOException;
import java.util.ArrayList;

public final class HashObjectJsonCodec
implements JsonCodec<HashObject> {
    @NonNull
    public HashObject parse(@Nullable JSONParser.ObjContext root, boolean strictMode) throws IOException {
        HashAlgorithm temp_algorithm = HashAlgorithm.values()[0];
        int temp_length = 0;
        Bytes temp_hash = Bytes.EMPTY;
        block10: for (JSONParser.PairContext kvPair : root.pair()) {
            switch (kvPair.STRING().getText()) {
                case "algorithm": {
                    temp_algorithm = HashAlgorithm.fromString(kvPair.value().STRING().getText());
                    continue block10;
                }
                case "length": {
                    temp_length = JsonTools.parseInteger((JSONParser.ValueContext)kvPair.value());
                    continue block10;
                }
                case "hash": {
                    temp_hash = Bytes.fromBase64((String)kvPair.value().STRING().getText());
                    continue block10;
                }
            }
            if (!strictMode) continue;
            throw new UnknownFieldException(kvPair.STRING().getText());
        }
        return new HashObject(temp_algorithm, temp_length, temp_hash);
    }

    public String toJSON(@NonNull HashObject data, String indent, boolean inline) {
        StringBuilder sb = new StringBuilder();
        sb.append((String)(inline ? "{\n" : indent + "{\n"));
        String childIndent = indent + "  ";
        ArrayList<String> fieldLines = new ArrayList<String>();
        if (data.algorithm() != HashAlgorithm.values()[0]) {
            fieldLines.add(JsonTools.field((String)"algorithm", (String)data.algorithm().protoName()));
        }
        if (data.length() != 0) {
            fieldLines.add(JsonTools.field((String)"length", (int)data.length()));
        }
        if (data.hash() != Bytes.EMPTY && data.hash() != null && data.hash().length() > 0L) {
            fieldLines.add(JsonTools.field((String)"hash", (Bytes)data.hash()));
        }
        if (!fieldLines.isEmpty()) {
            sb.append(childIndent);
            sb.append(String.join((CharSequence)(",\n" + childIndent), fieldLines));
            sb.append("\n");
        }
        sb.append(indent + "}");
        return sb.toString();
    }
}

