/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.base;

import com.hedera.hapi.node.base.codec.SignaturePairJsonCodec;
import com.hedera.hapi.node.base.codec.SignaturePairProtoCodec;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.EnumWithProtoMetadata;
import com.hedera.pbj.runtime.JsonCodec;
import com.hedera.pbj.runtime.OneOf;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Objects;

public record SignaturePair(Bytes pubKeyPrefix, OneOf<SignatureOneOfType> signature) {
    public static final Codec<SignaturePair> PROTOBUF = new SignaturePairProtoCodec();
    public static final JsonCodec<SignaturePair> JSON = new SignaturePairJsonCodec();
    public static final SignaturePair DEFAULT = SignaturePair.newBuilder().build();

    public SignaturePair {
        if (signature == null) {
            throw new NullPointerException("Parameter 'signature' must be supplied and can not be null");
        }
    }

    @Override
    public int hashCode() {
        int result = 1;
        if (this.pubKeyPrefix != null && !this.pubKeyPrefix.equals((Object)SignaturePair.DEFAULT.pubKeyPrefix)) {
            result = 31 * result + this.pubKeyPrefix.hashCode();
        }
        if (this.signature != null && !this.signature.equals(SignaturePair.DEFAULT.signature)) {
            result = 31 * result + this.signature.hashCode();
        }
        long hashCode = result;
        hashCode += hashCode << 30;
        hashCode ^= hashCode >>> 27;
        hashCode += hashCode << 16;
        hashCode ^= hashCode >>> 20;
        hashCode += hashCode << 5;
        hashCode ^= hashCode >>> 18;
        hashCode += hashCode << 10;
        hashCode ^= hashCode >>> 24;
        hashCode += hashCode << 30;
        return (int)hashCode;
    }

    @Override
    public boolean equals(Object that) {
        if (that == null || this.getClass() != that.getClass()) {
            return false;
        }
        SignaturePair thatObj = (SignaturePair)that;
        if (this.pubKeyPrefix == null && thatObj.pubKeyPrefix != null) {
            return false;
        }
        if (this.pubKeyPrefix != null && !this.pubKeyPrefix.equals((Object)thatObj.pubKeyPrefix)) {
            return false;
        }
        if (this.signature == null && thatObj.signature != null) {
            return false;
        }
        return this.signature == null || this.signature.equals(thatObj.signature);
    }

    @Nullable
    public Bytes contract() {
        return this.signature.kind() == SignatureOneOfType.CONTRACT ? (Bytes)this.signature.value() : null;
    }

    public boolean hasContract() {
        return this.signature.kind() == SignatureOneOfType.CONTRACT;
    }

    public Bytes contractOrElse(@NonNull Bytes defaultValue) {
        return this.hasContract() ? this.contract() : defaultValue;
    }

    @NonNull
    public Bytes contractOrThrow() {
        return Objects.requireNonNull(this.contract(), "Field contract is null");
    }

    @Nullable
    public Bytes ed25519() {
        return this.signature.kind() == SignatureOneOfType.ED25519 ? (Bytes)this.signature.value() : null;
    }

    public boolean hasEd25519() {
        return this.signature.kind() == SignatureOneOfType.ED25519;
    }

    public Bytes ed25519OrElse(@NonNull Bytes defaultValue) {
        return this.hasEd25519() ? this.ed25519() : defaultValue;
    }

    @NonNull
    public Bytes ed25519OrThrow() {
        return Objects.requireNonNull(this.ed25519(), "Field ed25519 is null");
    }

    @Nullable
    public Bytes rsa3072() {
        return this.signature.kind() == SignatureOneOfType.RSA_3072 ? (Bytes)this.signature.value() : null;
    }

    public boolean hasRsa3072() {
        return this.signature.kind() == SignatureOneOfType.RSA_3072;
    }

    public Bytes rsa3072OrElse(@NonNull Bytes defaultValue) {
        return this.hasRsa3072() ? this.rsa3072() : defaultValue;
    }

    @NonNull
    public Bytes rsa3072OrThrow() {
        return Objects.requireNonNull(this.rsa3072(), "Field rsa3072 is null");
    }

    @Nullable
    public Bytes ecdsa384() {
        return this.signature.kind() == SignatureOneOfType.ECDSA_384 ? (Bytes)this.signature.value() : null;
    }

    public boolean hasEcdsa384() {
        return this.signature.kind() == SignatureOneOfType.ECDSA_384;
    }

    public Bytes ecdsa384OrElse(@NonNull Bytes defaultValue) {
        return this.hasEcdsa384() ? this.ecdsa384() : defaultValue;
    }

    @NonNull
    public Bytes ecdsa384OrThrow() {
        return Objects.requireNonNull(this.ecdsa384(), "Field ecdsa384 is null");
    }

    @Nullable
    public Bytes ecdsaSecp256k1() {
        return this.signature.kind() == SignatureOneOfType.ECDSA_SECP256K1 ? (Bytes)this.signature.value() : null;
    }

    public boolean hasEcdsaSecp256k1() {
        return this.signature.kind() == SignatureOneOfType.ECDSA_SECP256K1;
    }

    public Bytes ecdsaSecp256k1OrElse(@NonNull Bytes defaultValue) {
        return this.hasEcdsaSecp256k1() ? this.ecdsaSecp256k1() : defaultValue;
    }

    @NonNull
    public Bytes ecdsaSecp256k1OrThrow() {
        return Objects.requireNonNull(this.ecdsaSecp256k1(), "Field ecdsaSecp256k1 is null");
    }

    public Builder copyBuilder() {
        return new Builder(this.pubKeyPrefix, this.signature);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static enum SignatureOneOfType implements EnumWithProtoMetadata
    {
        UNSET(-1, "UNSET"),
        CONTRACT(2, "contract"),
        ED25519(3, "ed25519"),
        RSA_3072(4, "RSA_3072"),
        ECDSA_384(5, "ECDSA_384"),
        ECDSA_SECP256K1(6, "ECDSA_secp256k1");

        private final int protoOrdinal;
        private final String protoName;

        private SignatureOneOfType(int protoOrdinal, String protoName) {
            this.protoOrdinal = protoOrdinal;
            this.protoName = protoName;
        }

        public int protoOrdinal() {
            return this.protoOrdinal;
        }

        public String protoName() {
            return this.protoName;
        }

        public static SignatureOneOfType fromProtobufOrdinal(int ordinal) {
            return switch (ordinal) {
                case 2 -> CONTRACT;
                case 3 -> ED25519;
                case 4 -> RSA_3072;
                case 5 -> ECDSA_384;
                case 6 -> ECDSA_SECP256K1;
                default -> throw new IllegalArgumentException("Unknown protobuf ordinal " + ordinal);
            };
        }

        public static SignatureOneOfType fromString(String name) {
            return switch (name) {
                case "contract", "CONTRACT" -> CONTRACT;
                case "ed25519", "ED25519" -> ED25519;
                case "RSA_3072" -> RSA_3072;
                case "ECDSA_384" -> ECDSA_384;
                case "ECDSA_secp256k1", "ECDSA_SECP256K1" -> ECDSA_SECP256K1;
                default -> throw new IllegalArgumentException("Unknown token kyc status " + name);
            };
        }
    }

    public static final class Builder {
        private Bytes pubKeyPrefix = Bytes.EMPTY;
        private OneOf<SignatureOneOfType> signature = SignaturePairProtoCodec.SIGNATURE_UNSET;

        public Builder() {
        }

        public Builder(Bytes pubKeyPrefix, OneOf<SignatureOneOfType> signature) {
            this.pubKeyPrefix = pubKeyPrefix;
            this.signature = signature;
        }

        public SignaturePair build() {
            return new SignaturePair(this.pubKeyPrefix, this.signature);
        }

        public Builder pubKeyPrefix(Bytes pubKeyPrefix) {
            this.pubKeyPrefix = pubKeyPrefix;
            return this;
        }

        public Builder contract(Bytes contract) {
            this.signature = new OneOf((Object)SignatureOneOfType.CONTRACT, (Object)contract);
            return this;
        }

        public Builder ed25519(Bytes ed25519) {
            this.signature = new OneOf((Object)SignatureOneOfType.ED25519, (Object)ed25519);
            return this;
        }

        public Builder rsa3072(Bytes rsa3072) {
            this.signature = new OneOf((Object)SignatureOneOfType.RSA_3072, (Object)rsa3072);
            return this;
        }

        public Builder ecdsa384(Bytes ecdsa384) {
            this.signature = new OneOf((Object)SignatureOneOfType.ECDSA_384, (Object)ecdsa384);
            return this;
        }

        public Builder ecdsaSecp256k1(Bytes ecdsaSecp256k1) {
            this.signature = new OneOf((Object)SignatureOneOfType.ECDSA_SECP256K1, (Object)ecdsaSecp256k1);
            return this;
        }
    }
}

