/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.base.codec;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.schema.AccountIDSchema;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.FieldDefinition;
import com.hedera.pbj.runtime.OneOf;
import com.hedera.pbj.runtime.ProtoConstants;
import com.hedera.pbj.runtime.ProtoParserTools;
import com.hedera.pbj.runtime.ProtoWriterTools;
import com.hedera.pbj.runtime.UnknownFieldException;
import com.hedera.pbj.runtime.io.ReadableSequentialData;
import com.hedera.pbj.runtime.io.WritableSequentialData;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.hedera.pbj.runtime.io.buffer.RandomAccessData;
import com.hedera.pbj.runtime.io.stream.EOFException;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;

public final class AccountIDProtoCodec
implements Codec<AccountID> {
    public static final OneOf<AccountID.AccountOneOfType> ACCOUNT_UNSET = new OneOf((Object)AccountID.AccountOneOfType.UNSET, null);

    @NonNull
    public AccountID parse(@NonNull ReadableSequentialData input) throws IOException {
        return this.parseInternal(input, false);
    }

    @NonNull
    public AccountID parseStrict(@NonNull ReadableSequentialData input) throws IOException {
        return this.parseInternal(input, true);
    }

    public void write(@NonNull AccountID data, @NonNull WritableSequentialData out) throws IOException {
        ProtoWriterTools.writeLong((WritableSequentialData)out, (FieldDefinition)AccountIDSchema.SHARD_NUM, (long)data.shardNum());
        ProtoWriterTools.writeLong((WritableSequentialData)out, (FieldDefinition)AccountIDSchema.REALM_NUM, (long)data.realmNum());
        if (data.account().kind() == AccountID.AccountOneOfType.ACCOUNT_NUM) {
            ProtoWriterTools.writeLong((WritableSequentialData)out, (FieldDefinition)AccountIDSchema.ACCOUNT_NUM, (long)((Long)data.account().as()));
        }
        if (data.account().kind() == AccountID.AccountOneOfType.ALIAS) {
            ProtoWriterTools.writeBytes((WritableSequentialData)out, (FieldDefinition)AccountIDSchema.ALIAS, (RandomAccessData)((RandomAccessData)data.account().as()));
        }
    }

    public int measure(@NonNull ReadableSequentialData input) throws IOException {
        long start = input.position();
        this.parse(input);
        long end = input.position();
        return (int)(end - start);
    }

    public int measureRecord(AccountID data) {
        int size = 0;
        size += ProtoWriterTools.sizeOfLong((FieldDefinition)AccountIDSchema.SHARD_NUM, (long)data.shardNum());
        size += ProtoWriterTools.sizeOfLong((FieldDefinition)AccountIDSchema.REALM_NUM, (long)data.realmNum());
        if (data.account().kind() == AccountID.AccountOneOfType.ACCOUNT_NUM) {
            size += ProtoWriterTools.sizeOfLong((FieldDefinition)AccountIDSchema.ACCOUNT_NUM, (long)((Long)data.account().as()));
        }
        if (data.account().kind() == AccountID.AccountOneOfType.ALIAS) {
            size += ProtoWriterTools.sizeOfBytes((FieldDefinition)AccountIDSchema.ALIAS, (RandomAccessData)((RandomAccessData)data.account().as()));
        }
        return size;
    }

    public boolean fastEquals(@NonNull AccountID item, @NonNull ReadableSequentialData input) throws IOException {
        return item.equals(this.parse(input));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NonNull
    private AccountID parseInternal(@NonNull ReadableSequentialData input, boolean strictMode) throws IOException {
        long temp_shardNum = 0L;
        long temp_realmNum = 0L;
        OneOf temp_account = ACCOUNT_UNSET;
        try {
            block8: while (input.hasRemaining()) {
                int tag = input.readVarInt(false);
                int field = tag >>> 3;
                FieldDefinition f = AccountIDSchema.getField(field);
                switch (tag) {
                    case 8: {
                        long value;
                        temp_shardNum = value = ProtoParserTools.readInt64((ReadableSequentialData)input);
                        continue block8;
                    }
                    case 16: {
                        long value;
                        temp_realmNum = value = ProtoParserTools.readInt64((ReadableSequentialData)input);
                        continue block8;
                    }
                    case 24: {
                        long value = ProtoParserTools.readInt64((ReadableSequentialData)input);
                        temp_account = new OneOf((Object)AccountID.AccountOneOfType.ACCOUNT_NUM, (Object)value);
                        continue block8;
                    }
                    case 34: {
                        Bytes value = ProtoParserTools.readBytes((ReadableSequentialData)input);
                        temp_account = new OneOf((Object)AccountID.AccountOneOfType.ALIAS, (Object)value);
                        continue block8;
                    }
                }
                int wireType = tag & 7;
                if (field == 0) {
                    throw new IOException("Bad protobuf encoding. We read a field value of " + field);
                }
                if (wireType > 5) {
                    throw new IOException("Cannot understand wire_type of " + wireType);
                }
                if (f != null) throw new IOException("Bad tag [" + tag + "], field [" + field + "] wireType [" + wireType + "]");
                if (strictMode) {
                    throw new UnknownFieldException(field);
                }
                ProtoParserTools.skipField((ReadableSequentialData)input, (ProtoConstants)ProtoConstants.get((int)wireType));
            }
            return new AccountID(temp_shardNum, temp_realmNum, temp_account);
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        return new AccountID(temp_shardNum, temp_realmNum, temp_account);
    }
}

