/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.base.codec;

import com.hedera.hapi.node.base.Fraction;
import com.hedera.hapi.node.base.schema.FractionSchema;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.FieldDefinition;
import com.hedera.pbj.runtime.ProtoConstants;
import com.hedera.pbj.runtime.ProtoParserTools;
import com.hedera.pbj.runtime.ProtoWriterTools;
import com.hedera.pbj.runtime.UnknownFieldException;
import com.hedera.pbj.runtime.io.ReadableSequentialData;
import com.hedera.pbj.runtime.io.WritableSequentialData;
import com.hedera.pbj.runtime.io.stream.EOFException;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;

public final class FractionProtoCodec
implements Codec<Fraction> {
    @NonNull
    public Fraction parse(@NonNull ReadableSequentialData input) throws IOException {
        return this.parseInternal(input, false);
    }

    @NonNull
    public Fraction parseStrict(@NonNull ReadableSequentialData input) throws IOException {
        return this.parseInternal(input, true);
    }

    public void write(@NonNull Fraction data, @NonNull WritableSequentialData out) throws IOException {
        ProtoWriterTools.writeLong((WritableSequentialData)out, (FieldDefinition)FractionSchema.NUMERATOR, (long)data.numerator());
        ProtoWriterTools.writeLong((WritableSequentialData)out, (FieldDefinition)FractionSchema.DENOMINATOR, (long)data.denominator());
    }

    public int measure(@NonNull ReadableSequentialData input) throws IOException {
        long start = input.position();
        this.parse(input);
        long end = input.position();
        return (int)(end - start);
    }

    public int measureRecord(Fraction data) {
        int size = 0;
        size += ProtoWriterTools.sizeOfLong((FieldDefinition)FractionSchema.NUMERATOR, (long)data.numerator());
        return size += ProtoWriterTools.sizeOfLong((FieldDefinition)FractionSchema.DENOMINATOR, (long)data.denominator());
    }

    public boolean fastEquals(@NonNull Fraction item, @NonNull ReadableSequentialData input) throws IOException {
        return item.equals(this.parse(input));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NonNull
    private Fraction parseInternal(@NonNull ReadableSequentialData input, boolean strictMode) throws IOException {
        long temp_numerator = 0L;
        long temp_denominator = 0L;
        try {
            block6: while (input.hasRemaining()) {
                int tag = input.readVarInt(false);
                int field = tag >>> 3;
                FieldDefinition f = FractionSchema.getField(field);
                switch (tag) {
                    case 8: {
                        long value;
                        temp_numerator = value = ProtoParserTools.readInt64((ReadableSequentialData)input);
                        continue block6;
                    }
                    case 16: {
                        long value;
                        temp_denominator = value = ProtoParserTools.readInt64((ReadableSequentialData)input);
                        continue block6;
                    }
                }
                int wireType = tag & 7;
                if (field == 0) {
                    throw new IOException("Bad protobuf encoding. We read a field value of " + field);
                }
                if (wireType > 5) {
                    throw new IOException("Cannot understand wire_type of " + wireType);
                }
                if (f != null) throw new IOException("Bad tag [" + tag + "], field [" + field + "] wireType [" + wireType + "]");
                if (strictMode) {
                    throw new UnknownFieldException(field);
                }
                ProtoParserTools.skipField((ReadableSequentialData)input, (ProtoConstants)ProtoConstants.get((int)wireType));
            }
            return new Fraction(temp_numerator, temp_denominator);
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        return new Fraction(temp_numerator, temp_denominator);
    }
}

