/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.base.codec;

import com.hedera.hapi.node.base.KeyList;
import com.hedera.hapi.node.base.ThresholdKey;
import com.hedera.hapi.node.base.schema.ThresholdKeySchema;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.FieldDefinition;
import com.hedera.pbj.runtime.ProtoConstants;
import com.hedera.pbj.runtime.ProtoParserTools;
import com.hedera.pbj.runtime.ProtoWriterTools;
import com.hedera.pbj.runtime.UnknownFieldException;
import com.hedera.pbj.runtime.io.ReadableSequentialData;
import com.hedera.pbj.runtime.io.WritableSequentialData;
import com.hedera.pbj.runtime.io.stream.EOFException;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;

public final class ThresholdKeyProtoCodec
implements Codec<ThresholdKey> {
    @NonNull
    public ThresholdKey parse(@NonNull ReadableSequentialData input) throws IOException {
        return this.parseInternal(input, false);
    }

    @NonNull
    public ThresholdKey parseStrict(@NonNull ReadableSequentialData input) throws IOException {
        return this.parseInternal(input, true);
    }

    public void write(@NonNull ThresholdKey data, @NonNull WritableSequentialData out) throws IOException {
        ProtoWriterTools.writeInteger((WritableSequentialData)out, (FieldDefinition)ThresholdKeySchema.THRESHOLD, (int)data.threshold());
        ProtoWriterTools.writeMessage((WritableSequentialData)out, (FieldDefinition)ThresholdKeySchema.KEYS, (Object)data.keys(), (arg_0, arg_1) -> KeyList.PROTOBUF.write(arg_0, arg_1), arg_0 -> KeyList.PROTOBUF.measureRecord(arg_0));
    }

    public int measure(@NonNull ReadableSequentialData input) throws IOException {
        long start = input.position();
        this.parse(input);
        long end = input.position();
        return (int)(end - start);
    }

    public int measureRecord(ThresholdKey data) {
        int size = 0;
        size += ProtoWriterTools.sizeOfInteger((FieldDefinition)ThresholdKeySchema.THRESHOLD, (int)data.threshold());
        return size += ProtoWriterTools.sizeOfMessage((FieldDefinition)ThresholdKeySchema.KEYS, (Object)data.keys(), arg_0 -> KeyList.PROTOBUF.measureRecord(arg_0));
    }

    public boolean fastEquals(@NonNull ThresholdKey item, @NonNull ReadableSequentialData input) throws IOException {
        return item.equals(this.parse(input));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NonNull
    private ThresholdKey parseInternal(@NonNull ReadableSequentialData input, boolean strictMode) throws IOException {
        temp_threshold = 0;
        temp_keys = null;
        try {
            block9: while (input.hasRemaining() != false) {
                tag = input.readVarInt(false);
                field = tag >>> 3;
                f = ThresholdKeySchema.getField(field);
                switch (tag) {
                    case 8: {
                        temp_threshold = value = ProtoParserTools.readUint32((ReadableSequentialData)input);
                        continue block9;
                    }
                    case 18: {
                        messageLength = input.readVarInt(false);
                        if (messageLength != 0) ** GOTO lbl17
                        value = KeyList.DEFAULT;
                        ** GOTO lbl30
lbl17:
                        // 1 sources

                        limitBefore = input.limit();
                        startPos = input.position();
                        try {
                            if (startPos + (long)messageLength > limitBefore) {
                                throw new BufferUnderflowException();
                            }
                            input.limit(startPos + (long)messageLength);
                            v0 = value = strictMode != false ? (KeyList)KeyList.PROTOBUF.parseStrict(input) : (KeyList)KeyList.PROTOBUF.parse(input);
                            if (startPos + (long)messageLength != input.position()) {
                                throw new BufferOverflowException();
                            }
                        }
                        finally {
                            input.limit(limitBefore);
                        }
lbl30:
                        // 2 sources

                        temp_keys = value;
                        continue block9;
                    }
                }
                wireType = tag & 7;
                if (field == 0) {
                    throw new IOException("Bad protobuf encoding. We read a field value of " + field);
                }
                if (wireType > 5) {
                    throw new IOException("Cannot understand wire_type of " + wireType);
                }
                if (f != null) throw new IOException("Bad tag [" + tag + "], field [" + field + "] wireType [" + wireType + "]");
                if (strictMode) {
                    throw new UnknownFieldException(field);
                }
                ProtoParserTools.skipField((ReadableSequentialData)input, (ProtoConstants)ProtoConstants.get((int)wireType));
            }
            return new ThresholdKey(temp_threshold, temp_keys);
        }
        catch (EOFException var5_6) {
            // empty catch block
        }
        return new ThresholdKey(temp_threshold, temp_keys);
    }
}

