/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.state.common.codec;

import com.hedera.hapi.node.state.common.EntityNumber;
import com.hedera.hapi.node.state.common.schema.EntityNumberSchema;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.FieldDefinition;
import com.hedera.pbj.runtime.ProtoConstants;
import com.hedera.pbj.runtime.ProtoParserTools;
import com.hedera.pbj.runtime.ProtoWriterTools;
import com.hedera.pbj.runtime.UnknownFieldException;
import com.hedera.pbj.runtime.io.ReadableSequentialData;
import com.hedera.pbj.runtime.io.WritableSequentialData;
import com.hedera.pbj.runtime.io.stream.EOFException;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;

public final class EntityNumberProtoCodec
implements Codec<EntityNumber> {
    @NonNull
    public EntityNumber parse(@NonNull ReadableSequentialData input) throws IOException {
        return this.parseInternal(input, false);
    }

    @NonNull
    public EntityNumber parseStrict(@NonNull ReadableSequentialData input) throws IOException {
        return this.parseInternal(input, true);
    }

    public void write(@NonNull EntityNumber data, @NonNull WritableSequentialData out) throws IOException {
        ProtoWriterTools.writeLong((WritableSequentialData)out, (FieldDefinition)EntityNumberSchema.NUMBER, (long)data.number());
    }

    public int measure(@NonNull ReadableSequentialData input) throws IOException {
        long start = input.position();
        this.parse(input);
        long end = input.position();
        return (int)(end - start);
    }

    public int measureRecord(EntityNumber data) {
        int size = 0;
        return size += ProtoWriterTools.sizeOfLong((FieldDefinition)EntityNumberSchema.NUMBER, (long)data.number());
    }

    public boolean fastEquals(@NonNull EntityNumber item, @NonNull ReadableSequentialData input) throws IOException {
        return item.equals(this.parse(input));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NonNull
    private EntityNumber parseInternal(@NonNull ReadableSequentialData input, boolean strictMode) throws IOException {
        long temp_number = 0L;
        try {
            block5: while (input.hasRemaining()) {
                int tag = input.readVarInt(false);
                int field = tag >>> 3;
                FieldDefinition f = EntityNumberSchema.getField(field);
                switch (tag) {
                    case 8: {
                        long value;
                        temp_number = value = ProtoParserTools.readInt64((ReadableSequentialData)input);
                        continue block5;
                    }
                }
                int wireType = tag & 7;
                if (field == 0) {
                    throw new IOException("Bad protobuf encoding. We read a field value of " + field);
                }
                if (wireType > 5) {
                    throw new IOException("Cannot understand wire_type of " + wireType);
                }
                if (f != null) throw new IOException("Bad tag [" + tag + "], field [" + field + "] wireType [" + wireType + "]");
                if (strictMode) {
                    throw new UnknownFieldException(field);
                }
                ProtoParserTools.skipField((ReadableSequentialData)input, (ProtoConstants)ProtoConstants.get((int)wireType));
            }
            return new EntityNumber(temp_number);
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        return new EntityNumber(temp_number);
    }
}

