/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.state.consensus.codec;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.Key;
import com.hedera.hapi.node.base.TopicID;
import com.hedera.hapi.node.state.consensus.Topic;
import com.hedera.hapi.node.state.consensus.schema.TopicSchema;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.FieldDefinition;
import com.hedera.pbj.runtime.ProtoConstants;
import com.hedera.pbj.runtime.ProtoParserTools;
import com.hedera.pbj.runtime.ProtoWriterTools;
import com.hedera.pbj.runtime.UnknownFieldException;
import com.hedera.pbj.runtime.io.ReadableSequentialData;
import com.hedera.pbj.runtime.io.WritableSequentialData;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.hedera.pbj.runtime.io.buffer.RandomAccessData;
import com.hedera.pbj.runtime.io.stream.EOFException;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;

public final class TopicProtoCodec
implements Codec<Topic> {
    @NonNull
    public Topic parse(@NonNull ReadableSequentialData input) throws IOException {
        return this.parseInternal(input, false);
    }

    @NonNull
    public Topic parseStrict(@NonNull ReadableSequentialData input) throws IOException {
        return this.parseInternal(input, true);
    }

    public void write(@NonNull Topic data, @NonNull WritableSequentialData out) throws IOException {
        ProtoWriterTools.writeMessage((WritableSequentialData)out, (FieldDefinition)TopicSchema.TOPIC_ID, (Object)data.topicId(), (arg_0, arg_1) -> TopicID.PROTOBUF.write(arg_0, arg_1), arg_0 -> TopicID.PROTOBUF.measureRecord(arg_0));
        ProtoWriterTools.writeLong((WritableSequentialData)out, (FieldDefinition)TopicSchema.SEQUENCE_NUMBER, (long)data.sequenceNumber());
        ProtoWriterTools.writeLong((WritableSequentialData)out, (FieldDefinition)TopicSchema.EXPIRATION_SECOND, (long)data.expirationSecond());
        ProtoWriterTools.writeLong((WritableSequentialData)out, (FieldDefinition)TopicSchema.AUTO_RENEW_PERIOD, (long)data.autoRenewPeriod());
        ProtoWriterTools.writeMessage((WritableSequentialData)out, (FieldDefinition)TopicSchema.AUTO_RENEW_ACCOUNT_ID, (Object)data.autoRenewAccountId(), (arg_0, arg_1) -> AccountID.PROTOBUF.write(arg_0, arg_1), arg_0 -> AccountID.PROTOBUF.measureRecord(arg_0));
        ProtoWriterTools.writeBoolean((WritableSequentialData)out, (FieldDefinition)TopicSchema.DELETED, (boolean)data.deleted());
        ProtoWriterTools.writeBytes((WritableSequentialData)out, (FieldDefinition)TopicSchema.RUNNING_HASH, (RandomAccessData)data.runningHash());
        ProtoWriterTools.writeString((WritableSequentialData)out, (FieldDefinition)TopicSchema.MEMO, (String)data.memo());
        ProtoWriterTools.writeMessage((WritableSequentialData)out, (FieldDefinition)TopicSchema.ADMIN_KEY, (Object)data.adminKey(), (arg_0, arg_1) -> Key.PROTOBUF.write(arg_0, arg_1), arg_0 -> Key.PROTOBUF.measureRecord(arg_0));
        ProtoWriterTools.writeMessage((WritableSequentialData)out, (FieldDefinition)TopicSchema.SUBMIT_KEY, (Object)data.submitKey(), (arg_0, arg_1) -> Key.PROTOBUF.write(arg_0, arg_1), arg_0 -> Key.PROTOBUF.measureRecord(arg_0));
    }

    public int measure(@NonNull ReadableSequentialData input) throws IOException {
        long start = input.position();
        this.parse(input);
        long end = input.position();
        return (int)(end - start);
    }

    public int measureRecord(Topic data) {
        int size = 0;
        size += ProtoWriterTools.sizeOfMessage((FieldDefinition)TopicSchema.TOPIC_ID, (Object)data.topicId(), arg_0 -> TopicID.PROTOBUF.measureRecord(arg_0));
        size += ProtoWriterTools.sizeOfLong((FieldDefinition)TopicSchema.SEQUENCE_NUMBER, (long)data.sequenceNumber());
        size += ProtoWriterTools.sizeOfLong((FieldDefinition)TopicSchema.EXPIRATION_SECOND, (long)data.expirationSecond());
        size += ProtoWriterTools.sizeOfLong((FieldDefinition)TopicSchema.AUTO_RENEW_PERIOD, (long)data.autoRenewPeriod());
        size += ProtoWriterTools.sizeOfMessage((FieldDefinition)TopicSchema.AUTO_RENEW_ACCOUNT_ID, (Object)data.autoRenewAccountId(), arg_0 -> AccountID.PROTOBUF.measureRecord(arg_0));
        size += ProtoWriterTools.sizeOfBoolean((FieldDefinition)TopicSchema.DELETED, (boolean)data.deleted());
        size += ProtoWriterTools.sizeOfBytes((FieldDefinition)TopicSchema.RUNNING_HASH, (RandomAccessData)data.runningHash());
        size += ProtoWriterTools.sizeOfString((FieldDefinition)TopicSchema.MEMO, (String)data.memo());
        size += ProtoWriterTools.sizeOfMessage((FieldDefinition)TopicSchema.ADMIN_KEY, (Object)data.adminKey(), arg_0 -> Key.PROTOBUF.measureRecord(arg_0));
        return size += ProtoWriterTools.sizeOfMessage((FieldDefinition)TopicSchema.SUBMIT_KEY, (Object)data.submitKey(), arg_0 -> Key.PROTOBUF.measureRecord(arg_0));
    }

    public boolean fastEquals(@NonNull Topic item, @NonNull ReadableSequentialData input) throws IOException {
        return item.equals(this.parse(input));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NonNull
    private Topic parseInternal(@NonNull ReadableSequentialData input, boolean strictMode) throws IOException {
        temp_topic_id /* !! */  = null;
        temp_sequence_number = 0L;
        temp_expiration_second = 0L;
        temp_auto_renew_period = 0L;
        temp_auto_renew_account_id /* !! */  = null;
        temp_deleted = false;
        temp_running_hash = Bytes.EMPTY;
        temp_memo = "";
        temp_admin_key /* !! */  = null;
        temp_submit_key /* !! */  = null;
        try {
            block26: while (input.hasRemaining() != false) {
                tag = input.readVarInt(false);
                field = tag >>> 3;
                f = TopicSchema.getField(field);
                switch (tag) {
                    case 10: {
                        messageLength = input.readVarInt(false);
                        if (messageLength != 0) ** GOTO lbl22
                        value /* !! */  = TopicID.DEFAULT;
                        ** GOTO lbl35
lbl22:
                        // 1 sources

                        limitBefore = input.limit();
                        startPos = input.position();
                        try {
                            if (startPos + (long)messageLength > limitBefore) {
                                throw new BufferUnderflowException();
                            }
                            input.limit(startPos + (long)messageLength);
                            v0 = value /* !! */  = strictMode != false ? (TopicID)TopicID.PROTOBUF.parseStrict(input) : (TopicID)TopicID.PROTOBUF.parse(input);
                            if (startPos + (long)messageLength != input.position()) {
                                throw new BufferOverflowException();
                            }
                        }
                        finally {
                            input.limit(limitBefore);
                        }
lbl35:
                        // 2 sources

                        temp_topic_id /* !! */  = value /* !! */ ;
                        continue block26;
                    }
                    case 16: {
                        temp_sequence_number = value = ProtoParserTools.readInt64((ReadableSequentialData)input);
                        continue block26;
                    }
                    case 24: {
                        temp_expiration_second = value = ProtoParserTools.readInt64((ReadableSequentialData)input);
                        continue block26;
                    }
                    case 32: {
                        temp_auto_renew_period = value = ProtoParserTools.readInt64((ReadableSequentialData)input);
                        continue block26;
                    }
                    case 42: {
                        messageLength = input.readVarInt(false);
                        if (messageLength != 0) ** GOTO lbl51
                        value /* !! */  = AccountID.DEFAULT;
                        ** GOTO lbl64
lbl51:
                        // 1 sources

                        limitBefore = input.limit();
                        startPos = input.position();
                        try {
                            if (startPos + (long)messageLength > limitBefore) {
                                throw new BufferUnderflowException();
                            }
                            input.limit(startPos + (long)messageLength);
                            v1 /* !! */  = value /* !! */  = strictMode != false ? (AccountID)AccountID.PROTOBUF.parseStrict(input) : (AccountID)AccountID.PROTOBUF.parse(input);
                            if (startPos + (long)messageLength != input.position()) {
                                throw new BufferOverflowException();
                            }
                        }
                        finally {
                            input.limit(limitBefore);
                        }
lbl64:
                        // 2 sources

                        temp_auto_renew_account_id /* !! */  = value /* !! */ ;
                        continue block26;
                    }
                    case 48: {
                        temp_deleted = value = ProtoParserTools.readBool((ReadableSequentialData)input);
                        continue block26;
                    }
                    case 58: {
                        temp_running_hash = value = ProtoParserTools.readBytes((ReadableSequentialData)input);
                        continue block26;
                    }
                    case 66: {
                        temp_memo = value = ProtoParserTools.readString((ReadableSequentialData)input);
                        continue block26;
                    }
                    case 74: {
                        messageLength = input.readVarInt(false);
                        if (messageLength != 0) ** GOTO lbl80
                        value /* !! */  = Key.DEFAULT;
                        ** GOTO lbl93
lbl80:
                        // 1 sources

                        limitBefore = input.limit();
                        startPos = input.position();
                        try {
                            if (startPos + (long)messageLength > limitBefore) {
                                throw new BufferUnderflowException();
                            }
                            input.limit(startPos + (long)messageLength);
                            v2 /* !! */  = value /* !! */  = strictMode != false ? (Key)Key.PROTOBUF.parseStrict(input) : (Key)Key.PROTOBUF.parse(input);
                            if (startPos + (long)messageLength != input.position()) {
                                throw new BufferOverflowException();
                            }
                        }
                        finally {
                            input.limit(limitBefore);
                        }
lbl93:
                        // 2 sources

                        temp_admin_key /* !! */  = value /* !! */ ;
                        continue block26;
                    }
                    case 82: {
                        messageLength = input.readVarInt(false);
                        if (messageLength != 0) ** GOTO lbl100
                        value /* !! */  = Key.DEFAULT;
                        ** GOTO lbl113
lbl100:
                        // 1 sources

                        limitBefore = input.limit();
                        startPos = input.position();
                        try {
                            if (startPos + (long)messageLength > limitBefore) {
                                throw new BufferUnderflowException();
                            }
                            input.limit(startPos + (long)messageLength);
                            v3 /* !! */  = value /* !! */  = strictMode != false ? (Key)Key.PROTOBUF.parseStrict(input) : (Key)Key.PROTOBUF.parse(input);
                            if (startPos + (long)messageLength != input.position()) {
                                throw new BufferOverflowException();
                            }
                        }
                        finally {
                            input.limit(limitBefore);
                        }
lbl113:
                        // 2 sources

                        temp_submit_key /* !! */  = value /* !! */ ;
                        continue block26;
                    }
                }
                wireType = tag & 7;
                if (field == 0) {
                    throw new IOException("Bad protobuf encoding. We read a field value of " + field);
                }
                if (wireType > 5) {
                    throw new IOException("Cannot understand wire_type of " + wireType);
                }
                if (f != null) throw new IOException("Bad tag [" + tag + "], field [" + field + "] wireType [" + wireType + "]");
                if (strictMode) {
                    throw new UnknownFieldException(field);
                }
                ProtoParserTools.skipField((ReadableSequentialData)input, (ProtoConstants)ProtoConstants.get((int)wireType));
            }
            return new Topic(temp_topic_id /* !! */ , temp_sequence_number, temp_expiration_second, temp_auto_renew_period, (AccountID)temp_auto_renew_account_id /* !! */ , temp_deleted, temp_running_hash, temp_memo, (Key)temp_admin_key /* !! */ , (Key)temp_submit_key /* !! */ );
        }
        catch (EOFException var16_14) {
            // empty catch block
        }
        return new Topic(temp_topic_id /* !! */ , temp_sequence_number, temp_expiration_second, temp_auto_renew_period, (AccountID)temp_auto_renew_account_id /* !! */ , temp_deleted, temp_running_hash, temp_memo, (Key)temp_admin_key /* !! */ , (Key)temp_submit_key /* !! */ );
    }
}

