/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.state.contract;

import com.hedera.hapi.node.state.contract.codec.SlotKeyJsonCodec;
import com.hedera.hapi.node.state.contract.codec.SlotKeyProtoCodec;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.JsonCodec;
import com.hedera.pbj.runtime.io.buffer.Bytes;

public record SlotKey(long contractNumber, Bytes key) {
    public static final Codec<SlotKey> PROTOBUF = new SlotKeyProtoCodec();
    public static final JsonCodec<SlotKey> JSON = new SlotKeyJsonCodec();
    public static final SlotKey DEFAULT = SlotKey.newBuilder().build();

    @Override
    public int hashCode() {
        int result = 1;
        if (this.contractNumber != SlotKey.DEFAULT.contractNumber) {
            result = 31 * result + Long.hashCode(this.contractNumber);
        }
        if (this.key != null && !this.key.equals((Object)SlotKey.DEFAULT.key)) {
            result = 31 * result + this.key.hashCode();
        }
        long hashCode = result;
        hashCode += hashCode << 30;
        hashCode ^= hashCode >>> 27;
        hashCode += hashCode << 16;
        hashCode ^= hashCode >>> 20;
        hashCode += hashCode << 5;
        hashCode ^= hashCode >>> 18;
        hashCode += hashCode << 10;
        hashCode ^= hashCode >>> 24;
        hashCode += hashCode << 30;
        return (int)hashCode;
    }

    @Override
    public boolean equals(Object that) {
        if (that == null || this.getClass() != that.getClass()) {
            return false;
        }
        SlotKey thatObj = (SlotKey)that;
        if (this.contractNumber != thatObj.contractNumber) {
            return false;
        }
        if (this.key == null && thatObj.key != null) {
            return false;
        }
        return this.key == null || this.key.equals((Object)thatObj.key);
    }

    public Builder copyBuilder() {
        return new Builder(this.contractNumber, this.key);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        private long contractNumber = 0L;
        private Bytes key = Bytes.EMPTY;

        public Builder() {
        }

        public Builder(long contractNumber, Bytes key) {
            this.contractNumber = contractNumber;
            this.key = key;
        }

        public SlotKey build() {
            return new SlotKey(this.contractNumber, this.key);
        }

        public Builder contractNumber(long contractNumber) {
            this.contractNumber = contractNumber;
            return this;
        }

        public Builder key(Bytes key) {
            this.key = key;
            return this;
        }
    }
}

