/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.state.file;

import com.hedera.hapi.node.base.FileID;
import com.hedera.hapi.node.base.KeyList;
import com.hedera.hapi.node.state.file.codec.FileJsonCodec;
import com.hedera.hapi.node.state.file.codec.FileProtoCodec;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.JsonCodec;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Objects;
import java.util.function.Consumer;

public record File(@Nullable FileID fileId, long expirationSecond, @Nullable KeyList keys, Bytes contents, String memo, boolean deleted, long preSystemDeleteExpirationSecond) {
    public static final Codec<File> PROTOBUF = new FileProtoCodec();
    public static final JsonCodec<File> JSON = new FileJsonCodec();
    public static final File DEFAULT = File.newBuilder().build();

    @Override
    public int hashCode() {
        int result = 1;
        if (this.fileId != null && !this.fileId.equals(File.DEFAULT.fileId)) {
            result = 31 * result + this.fileId.hashCode();
        }
        if (this.expirationSecond != File.DEFAULT.expirationSecond) {
            result = 31 * result + Long.hashCode(this.expirationSecond);
        }
        if (this.keys != null && !this.keys.equals(File.DEFAULT.keys)) {
            result = 31 * result + this.keys.hashCode();
        }
        if (this.contents != null && !this.contents.equals((Object)File.DEFAULT.contents)) {
            result = 31 * result + this.contents.hashCode();
        }
        if (this.memo != null && !this.memo.equals(File.DEFAULT.memo)) {
            result = 31 * result + this.memo.hashCode();
        }
        if (this.deleted != File.DEFAULT.deleted) {
            result = 31 * result + Boolean.hashCode(this.deleted);
        }
        if (this.preSystemDeleteExpirationSecond != File.DEFAULT.preSystemDeleteExpirationSecond) {
            result = 31 * result + Long.hashCode(this.preSystemDeleteExpirationSecond);
        }
        long hashCode = result;
        hashCode += hashCode << 30;
        hashCode ^= hashCode >>> 27;
        hashCode += hashCode << 16;
        hashCode ^= hashCode >>> 20;
        hashCode += hashCode << 5;
        hashCode ^= hashCode >>> 18;
        hashCode += hashCode << 10;
        hashCode ^= hashCode >>> 24;
        hashCode += hashCode << 30;
        return (int)hashCode;
    }

    @Override
    public boolean equals(Object that) {
        if (that == null || this.getClass() != that.getClass()) {
            return false;
        }
        File thatObj = (File)that;
        if (this.fileId == null && thatObj.fileId != null) {
            return false;
        }
        if (this.fileId != null && !this.fileId.equals(thatObj.fileId)) {
            return false;
        }
        if (this.expirationSecond != thatObj.expirationSecond) {
            return false;
        }
        if (this.keys == null && thatObj.keys != null) {
            return false;
        }
        if (this.keys != null && !this.keys.equals(thatObj.keys)) {
            return false;
        }
        if (this.contents == null && thatObj.contents != null) {
            return false;
        }
        if (this.contents != null && !this.contents.equals((Object)thatObj.contents)) {
            return false;
        }
        if (this.memo == null && thatObj.memo != null) {
            return false;
        }
        if (this.memo != null && !this.memo.equals(thatObj.memo)) {
            return false;
        }
        if (this.deleted != thatObj.deleted) {
            return false;
        }
        return this.preSystemDeleteExpirationSecond == thatObj.preSystemDeleteExpirationSecond;
    }

    public boolean hasFileId() {
        return this.fileId != null;
    }

    public FileID fileIdOrElse(@NonNull FileID defaultValue) {
        return this.hasFileId() ? this.fileId : defaultValue;
    }

    @NonNull
    public FileID fileIdOrThrow() {
        return Objects.requireNonNull(this.fileId, "Field fileId is null");
    }

    public void ifFileId(@NonNull Consumer<FileID> ifPresent) {
        if (this.hasFileId()) {
            ifPresent.accept(this.fileId);
        }
    }

    public boolean hasKeys() {
        return this.keys != null;
    }

    public KeyList keysOrElse(@NonNull KeyList defaultValue) {
        return this.hasKeys() ? this.keys : defaultValue;
    }

    @NonNull
    public KeyList keysOrThrow() {
        return Objects.requireNonNull(this.keys, "Field keys is null");
    }

    public void ifKeys(@NonNull Consumer<KeyList> ifPresent) {
        if (this.hasKeys()) {
            ifPresent.accept(this.keys);
        }
    }

    public Builder copyBuilder() {
        return new Builder(this.fileId, this.expirationSecond, this.keys, this.contents, this.memo, this.deleted, this.preSystemDeleteExpirationSecond);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        private FileID fileId = null;
        private long expirationSecond = 0L;
        private KeyList keys = null;
        private Bytes contents = Bytes.EMPTY;
        private String memo = "";
        private boolean deleted = false;
        private long preSystemDeleteExpirationSecond = 0L;

        public Builder() {
        }

        public Builder(FileID fileId, long expirationSecond, KeyList keys, Bytes contents, String memo, boolean deleted, long preSystemDeleteExpirationSecond) {
            this.fileId = fileId;
            this.expirationSecond = expirationSecond;
            this.keys = keys;
            this.contents = contents;
            this.memo = memo;
            this.deleted = deleted;
            this.preSystemDeleteExpirationSecond = preSystemDeleteExpirationSecond;
        }

        public File build() {
            return new File(this.fileId, this.expirationSecond, this.keys, this.contents, this.memo, this.deleted, this.preSystemDeleteExpirationSecond);
        }

        public Builder fileId(FileID fileId) {
            this.fileId = fileId;
            return this;
        }

        public Builder fileId(FileID.Builder builder) {
            this.fileId = builder.build();
            return this;
        }

        public Builder expirationSecond(long expirationSecond) {
            this.expirationSecond = expirationSecond;
            return this;
        }

        public Builder keys(KeyList keys) {
            this.keys = keys;
            return this;
        }

        public Builder keys(KeyList.Builder builder) {
            this.keys = builder.build();
            return this;
        }

        public Builder contents(Bytes contents) {
            this.contents = contents;
            return this;
        }

        public Builder memo(String memo) {
            this.memo = memo;
            return this;
        }

        public Builder deleted(boolean deleted) {
            this.deleted = deleted;
            return this;
        }

        public Builder preSystemDeleteExpirationSecond(long preSystemDeleteExpirationSecond) {
            this.preSystemDeleteExpirationSecond = preSystemDeleteExpirationSecond;
            return this;
        }
    }
}

